/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.matcher;

import it.jrc.matcher.MatchResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MatchWords {
    private static final char cTerm = '\u0003';
    private static MatchWords matcherRef = null;
    private static final String terminator = "\u0003\u0003";
    private static HashMap<String, MatchWords> instanceMap = new HashMap();
    private static final boolean DEBUG = false;
    private Logger logger = LogManager.getLogger((String)"it.jrc.matcher.MatchWords");
    private String matcherId = null;
    private Object[] cLists = new Object[65535];
    private int nAll = 0;
    private int nAny = 0;
    private int nGraph = 0;
    private int nMaxMatch = 0;
    private int nWorkSpace = 0;
    private boolean bInit = false;
    private int[] all;
    private char[] allPatterns;
    private int[] any;

    private MatchWords() {
        this.matcherId = "";
    }

    private MatchWords(String id) {
        this.matcherId = id;
    }

    public static synchronized MatchWords getInstance(String id) {
        MatchWords matchWords = instanceMap.get(id);
        if (matchWords == null) {
            matchWords = new MatchWords(id);
            instanceMap.put(id, matchWords);
        }
        return matchWords;
    }

    public static synchronized MatchWords getObject() {
        return new MatchWords();
    }

    public static synchronized boolean hasInstance(String id) {
        return instanceMap.get(id) != null;
    }

    public static synchronized MatchWords getInstance() {
        if (matcherRef == null) {
            matcherRef = new MatchWords();
        }
        return matcherRef;
    }

    public synchronized boolean isInitialized() {
        return this.bInit;
    }

    public synchronized void setInitialized(boolean init) {
        this.bInit = init;
    }

    private boolean isIdeograph(char c) {
        if (c < '\u3400') {
            return false;
        }
        if (c >= '\u3400' && c <= '\u4dbf') {
            return true;
        }
        return c >= '\u4e00' && c <= '\u9fff';
    }

    private char mapC(char c) {
        if (Character.isLetterOrDigit(c)) {
            return c;
        }
        switch (c) {
            case '&': 
            case '-': 
            case '_': {
                return c;
            }
        }
        return '\u0003';
    }

    public synchronized void init(Hashtable words) {
        this.logger.info(this.matcherId + " matcher using 64K index array");
        this.cLists = new Object[65535];
        Arrays.fill(this.cLists, 0, 65535, null);
        this.allPatterns = null;
        StringBuilder asChars = new StringBuilder(4096);
        for (String pattern : words.keySet()) {
            Character start;
            int ind = 0;
            int offSet = 0;
            if ((start = Character.valueOf(pattern.charAt(ind++))).charValue() == '@') {
                start = Character.valueOf(pattern.charAt(ind));
                offSet = 1;
            }
            if (this.isIdeograph(start.charValue())) {
                ++this.nGraph;
            }
            if (start.charValue() == '[') {
                while (ind < pattern.length() && pattern.charAt(ind) != ']') {
                    ++ind;
                }
                for (int i = 1; i < ind; ++i) {
                    start = Character.valueOf(pattern.charAt(i));
                    Vector<Integer> list = (Vector<Integer>)this.cLists[start.charValue()];
                    if (list == null) {
                        this.cLists[start.charValue()] = list = new Vector<Integer>();
                    }
                    list.add(new Integer(asChars.length()) + ind);
                }
            } else {
                Vector<Integer> list = (Vector<Integer>)this.cLists[start.charValue()];
                if (list == null) {
                    this.cLists[start.charValue()] = list = new Vector<Integer>();
                }
                list.add(new Integer(asChars.length()) + offSet);
            }
            asChars.append(pattern);
            asChars.append('\u0003');
            asChars.append((char)pattern.length());
            StringBuilder weights = (StringBuilder)words.get(pattern);
            asChars.append((CharSequence)weights);
            weights = null;
        }
        this.allPatterns = asChars.toString().toCharArray();
        int nMax = 0;
        for (int c = 0; c < 65535; ++c) {
            Vector v = (Vector)this.cLists[c];
            if (v == null) continue;
            int size = v.size();
            if (size > nMax) {
                nMax = size;
            }
            int[] ind = new int[size];
            for (int i = 0; i < size; ++i) {
                ind[i] = (Integer)v.get(i);
            }
            this.cLists[c] = ind;
            v.clear();
            v = null;
        }
        this.all = (int[])this.cLists[37];
        if (this.all != null) {
            this.nAll = this.all.length;
        }
        this.any = (int[])this.cLists[95];
        if (this.any != null) {
            this.nAny = this.any.length;
        }
        asChars = null;
        this.nGraph = (this.nGraph + 4) / 4 * 4;
        if (this.nGraph < 128) {
            this.nGraph = 128;
        }
        if (this.nGraph > 1024) {
            this.nGraph = 1024;
        }
        this.logger.info("graph matching workspace size set at " + this.nGraph);
        this.nMaxMatch = nMax * 2 + this.nAll + this.nAny;
        this.logger.info(this.matcherId + " init: nMax = " + nMax + " nMaxMatch = " + this.nMaxMatch + " nAll = " + this.nAll + " nAny = " + this.nAny + " total table size = " + this.allPatterns.length);
        this.nWorkSpace = this.nMaxMatch * 2;
        this.logger.info("workspace size set at " + this.nWorkSpace);
        this.bInit = true;
    }

    private int matchGraphs(String text, int len, int index, char c, MatchResult result) {
        int[] graphs = new int[this.nGraph];
        int[] startgraphs = new int[this.nGraph];
        int state = 0;
        int nMatching = 0;
        Arrays.fill(graphs, -1);
        while (index < len && state < 99) {
            switch (state) {
                case 0: {
                    state = 1;
                    int[] clist = (int[])this.cLists[c];
                    if (clist != null) {
                        for (int i = 0; i < clist.length && i < this.nGraph; ++i) {
                            graphs[i] = clist[i];
                            startgraphs[i] = index - 1;
                            ++nMatching;
                        }
                    }
                }
                case 1: {
                    int[] clist;
                    c = text.charAt(index);
                    int nChecked = 0;
                    int nToCheck = nMatching;
                    for (int nG = 0; nChecked < nToCheck && nG < this.nGraph && state == 1; ++nG) {
                        int pNp = graphs[nG];
                        if (pNp < 0) continue;
                        ++nChecked;
                        char pattern = this.allPatterns[pNp + 1];
                        if (pattern == '\u0003') {
                            String theText = text.substring(startgraphs[nG], index);
                            result.addMatch(this.allPatterns, pNp, theText, startgraphs[nG], startgraphs[nG]);
                            graphs[nG] = -1;
                            --nMatching;
                            continue;
                        }
                        if (pattern == c) {
                            graphs[nG] = pNp + 1;
                            continue;
                        }
                        graphs[nG] = -1;
                        --nMatching;
                    }
                    if (this.isIdeograph(c)) {
                        clist = (int[])this.cLists[c];
                        if (clist != null) {
                            int ic = 0;
                            for (int n = 0; n < this.nGraph && ic < clist.length; ++n) {
                                if (graphs[n] >= 0) continue;
                                graphs[n] = clist[ic++];
                                startgraphs[n] = index;
                                ++nMatching;
                            }
                        }
                        ++index;
                        break;
                    }
                    state = 99;
                }
            }
        }
        return index;
    }

    public void match(String text, MatchResult matchResult) {
        int[] patterns = new int[this.nWorkSpace];
        int[] matchall = new int[this.nWorkSpace];
        int[] matchmulti = new int[this.nMaxMatch];
        int[] startmatch = new int[this.nWorkSpace];
        int[] startmulti = new int[this.nMaxMatch];
        int[] candidateMulti = new int[this.nMaxMatch];
        int[] candidateStart = new int[this.nMaxMatch];
        int[] tempMatchAll = new int[this.nMaxMatch];
        int nCandidates = 0;
        int nPatterns = 0;
        int nMatching = 0;
        int state = 0;
        int index = 0;
        int nMulti = 0;
        int nExtend = 0;
        int wordIndex = -1;
        char c = '\u0000';
        char lc = '\u0000';
        text = text + terminator;
        int nMax = text.length() - 1;
        while (index < nMax) {
            switch (state) {
                case 0: {
                    int i;
                    int indexOfPattern;
                    int indexOfPercent;
                    c = text.charAt(index++);
                    if (this.isIdeograph(c)) {
                        int oldIndex = index;
                        index = this.matchGraphs(text, nMax, index, c, matchResult);
                        wordIndex = wordIndex + index - oldIndex;
                        nMulti = 0;
                        break;
                    }
                    if (!Character.isLetterOrDigit(c)) break;
                    ++wordIndex;
                    lc = Character.toLowerCase(c);
                    int[] lcList = (int[])this.cLists[lc];
                    int nLowerMatch = 0;
                    if (lcList != null) {
                        nLowerMatch = lcList.length;
                    }
                    int nUpperMatch = 0;
                    int[] ucList = new int[]{};
                    if (c != lc && (ucList = (int[])this.cLists[c]) != null) {
                        nUpperMatch = ucList.length;
                    }
                    int keepMulti = 0;
                    nCandidates = 0;
                    if (nMulti > 0) {
                        for (int i2 = 0; i2 < nMulti; ++i2) {
                            tempMatchAll[i2] = -1;
                            int pNp = matchmulti[i2];
                            if (this.allPatterns[pNp] == c || this.allPatterns[pNp] == lc || this.allPatterns[pNp] == '_') {
                                candidateMulti[nCandidates] = pNp;
                                candidateStart[nCandidates++] = startmulti[i2];
                                ++keepMulti;
                                continue;
                            }
                            if (this.allPatterns[pNp] == '%') {
                                ++keepMulti;
                                indexOfPercent = pNp;
                                indexOfPattern = indexOfPercent + 1;
                                tempMatchAll[i2] = indexOfPercent;
                                if (this.allPatterns[indexOfPattern] == c || this.allPatterns[indexOfPattern] == lc) {
                                    matchmulti[i2] = indexOfPattern;
                                    continue;
                                }
                                matchmulti[i2] = indexOfPercent;
                                continue;
                            }
                            if (this.allPatterns[pNp] == '[') {
                                boolean inSet = false;
                                int ind = 1;
                                char cNext = this.allPatterns[pNp + ind];
                                while (!inSet && cNext != ']') {
                                    inSet = cNext == c || cNext == lc;
                                    cNext = this.allPatterns[pNp + ++ind];
                                }
                                while (this.allPatterns[pNp + ind] != '\u0003' && this.allPatterns[pNp + ind] != ']') {
                                    ++ind;
                                }
                                if (inSet) {
                                    matchmulti[i2] = pNp + ind;
                                    ++keepMulti;
                                    continue;
                                }
                                candidateMulti[nCandidates] = pNp;
                                candidateStart[nCandidates++] = startmulti[i2];
                                matchmulti[i2] = -1;
                                continue;
                            }
                            candidateMulti[nCandidates] = pNp;
                            candidateStart[nCandidates++] = startmulti[i2];
                            matchmulti[i2] = -1;
                        }
                    }
                    if ((nPatterns = nLowerMatch + nUpperMatch + this.nAll + this.nAny + keepMulti) > 0) {
                        int i3;
                        nMatching = nPatterns;
                        int iw = 0;
                        Arrays.fill(matchall, 0, nPatterns, -1);
                        Arrays.fill(startmatch, 0, nPatterns, index - 1);
                        if (lcList != null) {
                            System.arraycopy(lcList, 0, patterns, iw, lcList.length);
                            iw = lcList.length;
                        }
                        if (nUpperMatch > 0) {
                            System.arraycopy(ucList, 0, patterns, iw, nUpperMatch);
                            iw += nUpperMatch;
                        }
                        for (i3 = 0; i3 < this.nAny; ++i3) {
                            patterns[iw++] = this.any[i3];
                        }
                        for (i3 = 0; i3 < this.nAll; ++i3) {
                            indexOfPercent = this.all[i3];
                            indexOfPattern = indexOfPercent + 1;
                            matchall[iw] = indexOfPercent;
                            patterns[iw++] = this.allPatterns[indexOfPattern] == c || this.allPatterns[indexOfPattern] == lc ? indexOfPattern : indexOfPercent;
                        }
                        if (keepMulti > 0) {
                            int k = 0;
                            for (i = 0; i < nMulti; ++i) {
                                if (matchmulti[i] < 0) continue;
                                matchall[iw] = tempMatchAll[k++];
                                startmatch[iw] = startmulti[i];
                                patterns[iw++] = matchmulti[i];
                            }
                        }
                        state = 2;
                    } else {
                        state = 3;
                    }
                    nMulti = 0;
                    break;
                }
                case 2: {
                    int i;
                    c = text.charAt(index++);
                    c = this.isIdeograph(c) ? (char)'\u0003' : this.mapC(c);
                    lc = Character.toLowerCase(c);
                    for (int nP = 0; nP < nPatterns && state == 2; ++nP) {
                        int pNp = patterns[nP];
                        if (pNp < 0) continue;
                        char pattern = this.allPatterns[pNp + 1];
                        if (c == '\u0003' && pattern == '\u0003') {
                            String theText = text.substring(startmatch[nP], index - 1);
                            matchResult.addMatch(this.allPatterns, pNp, theText, wordIndex, startmatch[nP]);
                            patterns[nP] = -1;
                            if (--nMatching > 0) continue;
                            state = 0;
                            continue;
                        }
                        if (pattern == '%' && c == '\u0003' && this.allPatterns[pNp + 2] == '\u0003') {
                            String theText = text.substring(startmatch[nP], index - 1);
                            matchResult.addMatch(this.allPatterns, pNp + 1, theText, wordIndex, startmatch[nP]);
                            patterns[nP] = -1;
                            if (--nMatching > 0) continue;
                            state = 0;
                            continue;
                        }
                        if (pattern == '%' && c == '\u0003' && this.allPatterns[pNp + 2] == '+') {
                            startmulti[nMulti] = startmatch[nP];
                            matchmulti[nMulti++] = pNp + 3;
                            patterns[nP] = -1;
                            if (--nMatching > 0) continue;
                            state = 0;
                            continue;
                        }
                        if (pattern == '+' && c == '\u0003') {
                            startmulti[nMulti] = startmatch[nP];
                            matchmulti[nMulti++] = pNp + 2;
                            patterns[nP] = -1;
                            if (--nMatching > 0) continue;
                            state = 0;
                            continue;
                        }
                        if (c != '\u0003' && (pattern == lc || pattern == c || pattern == '_')) {
                            patterns[nP] = pNp + 1;
                            continue;
                        }
                        if (c != '\u0003' && pattern == '[') {
                            boolean inSet = false;
                            while (pattern != ']' && pattern != '\u0003' && !inSet) {
                                inSet = (pattern = this.allPatterns[++pNp + 1]) == lc || pattern == c;
                            }
                            while (pattern != ']' && pattern != '\u0003') {
                                pattern = this.allPatterns[++pNp + 1];
                            }
                            if (inSet) {
                                patterns[nP] = pNp + 1;
                                continue;
                            }
                            patterns[nP] = -1;
                            if (--nMatching > 0) continue;
                            state = 3;
                            continue;
                        }
                        if (c != '\u0003' && pattern == '%') {
                            int nC = pNp;
                            char cNext = this.allPatterns[nC + 2];
                            if (cNext != '\u0003' && (cNext == Character.toLowerCase(text.charAt(index)) || cNext == text.charAt(index))) {
                                matchall[nP] = nC;
                                patterns[nP] = nC + 1;
                                continue;
                            }
                            if (cNext != '\u0003' && (cNext == lc || cNext == c)) {
                                matchall[nP] = nC + 1;
                                patterns[nP] = nC + 2;
                                continue;
                            }
                            if (cNext != '+' || text.charAt(index) != ' ') continue;
                            matchall[nP] = nC;
                            patterns[nP] = nC + 1;
                            continue;
                        }
                        if (c != '\u0003' && pattern == ']') {
                            int[] lcList = (int[])this.cLists[lc];
                            int nLowerMatch = 0;
                            if (lcList != null) {
                                nLowerMatch = lcList.length;
                            }
                            int newMulti = 0;
                            int[] newCandidates = new int[nCandidates];
                            if (nCandidates > 0) {
                                for (i = 0; i < nCandidates; ++i) {
                                    char cTest = this.allPatterns[candidateMulti[i]];
                                    if (cTest != c && cTest != lc && cTest != '_') continue;
                                    newCandidates[newMulti++] = i;
                                }
                            }
                            if (nLowerMatch + newMulti + this.nAny > 0) {
                                int i4;
                                int newNumberOfPatterns = nPatterns + nExtend + nLowerMatch + newMulti + this.nAny;
                                if (newNumberOfPatterns > this.nWorkSpace) {
                                    this.logger.info("we have run out of space!!!!! old=" + this.nWorkSpace + " required = " + newNumberOfPatterns);
                                    int diff = newNumberOfPatterns - this.nWorkSpace;
                                    this.nWorkSpace += 2 * diff;
                                    int[] newPatterns = new int[this.nWorkSpace];
                                    System.arraycopy(patterns, 0, newPatterns, 0, patterns.length);
                                    int[] newMatchall = new int[this.nWorkSpace];
                                    System.arraycopy(matchall, 0, newMatchall, 0, patterns.length);
                                    int[] newStartmatch = new int[this.nWorkSpace];
                                    System.arraycopy(startmatch, 0, newStartmatch, 0, patterns.length);
                                    patterns = newPatterns;
                                    startmatch = newStartmatch;
                                    matchall = newMatchall;
                                    this.logger.info("new workspace set to " + this.nWorkSpace);
                                }
                                int endIndex = nPatterns + nExtend;
                                int nLower = 0;
                                for (i4 = 0; i4 < nLowerMatch; ++i4) {
                                    int patternInd = lcList[i4];
                                    if (patternInd <= 0 || this.allPatterns[patternInd - 1] == '@') continue;
                                    patterns[endIndex + nLower++] = patternInd;
                                }
                                endIndex += nLower;
                                for (i4 = 0; i4 < this.nAny; ++i4) {
                                    patterns[endIndex + i4] = this.any[i4];
                                }
                                endIndex += this.nAny;
                                for (i4 = nPatterns + nExtend; i4 < newNumberOfPatterns; ++i4) {
                                    startmatch[i4] = startmatch[nP];
                                }
                                for (i4 = 0; i4 < newMulti; ++i4) {
                                    patterns[endIndex] = candidateMulti[newCandidates[i4]];
                                    startmatch[endIndex++] = candidateStart[newCandidates[i4]];
                                }
                                nExtend = nExtend + nLower + this.nAny + newMulti;
                                nMatching = nMatching + nLower + this.nAny + newMulti;
                            }
                            patterns[nP] = -1;
                            if (--nMatching > 0) continue;
                            state = 3;
                            continue;
                        }
                        if (c != '\u0003') {
                            if (this.allPatterns[pNp] == '%' && matchall[nP] < 0) {
                                matchall[nP] = pNp;
                                continue;
                            }
                            if (matchall[nP] > 0) {
                                if (this.allPatterns[matchall[nP] + 1] == lc || this.allPatterns[matchall[nP] + 1] == c) {
                                    patterns[nP] = matchall[nP] + 1;
                                    continue;
                                }
                                patterns[nP] = matchall[nP];
                                continue;
                            }
                            patterns[nP] = -1;
                            if (--nMatching > 0) continue;
                            state = 3;
                            continue;
                        }
                        patterns[nP] = -1;
                        if (--nMatching > 0) continue;
                        state = 0;
                    }
                    if (c == '\u0003' && this.isIdeograph(text.charAt(index - 1))) {
                        --index;
                    }
                    nPatterns += nExtend;
                    nExtend = 0;
                    break;
                }
                case 3: {
                    c = text.charAt(index++);
                    c = this.mapC(c);
                    if (c == '\u0003') {
                        state = 0;
                        break;
                    }
                    if (!this.isIdeograph(c)) break;
                    --index;
                    state = 0;
                }
            }
        }
        matchResult.setWordCount(wordIndex + 1);
    }
}

