/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.license.internal;

import it.jrc.osint.license.LicenseService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class LicenseServiceImpl
implements LicenseService {
    private String versionLabel;

    public LicenseServiceImpl(BundleContext context) {
        Version v = context.getBundle().getVersion();
        StringBuilder verStr = new StringBuilder();
        verStr.append(v.getMajor());
        verStr.append(".");
        verStr.append(v.getMinor());
        verStr.append(".");
        verStr.append(v.getMicro());
        verStr.append(" (");
        String architecture = System.getProperty("os.arch");
        if (architecture.contains("64")) {
            verStr.append("64-bit");
        } else {
            verStr.append("32-bit");
        }
        verStr.append(")");
        this.versionLabel = verStr.toString();
    }

    @Override
    public String getVersionLabel() {
        return this.versionLabel;
    }

    @Override
    public boolean isEvaluation() {
        String licenseType = System.getProperty("lt");
        if (licenseType == null) {
            return false;
        }
        return "e".equals(licenseType);
    }
}

