/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFSDArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.InputFeatureStructureComparator;
import it.jrc.lt.regexpfs.module.CorleoneExternal;
import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.module.ProcessingException;
import it.jrc.lt.regexpfs.results.ResultPool;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;

public final class CorleoneDropper
extends Module {
    private static List<Instruction> _instructions;

    protected CorleoneDropper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initialize() {
        Properties myProperties = this.getModulesConfiguration();
        Configuration myConfig = Configuration.initializeFrom((Properties)myProperties);
        if (myConfig.isNull()) {
            Module.loggerMessage((String)("Could not initialize the configuration for the module [" + this.getComponentName() + "]"));
            return false;
        }
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            if (_instructions == null) {
                String typefile = myProperties.getProperty("TypeFile");
                if (typefile == null) {
                    Module.loggerMessage((String)("Missing property [TypeFile] in configuration file of the module [" + this.getComponentName() + "]"));
                    return false;
                }
                if (!new File(typefile).exists()) {
                    Module.loggerMessage((String)("property [TypeFile] in configuration file of the module [" + this.getComponentName() + "] refers to a file [" + typefile + "] that doesn't exist"));
                    return false;
                }
                LinkedHashMap<String, ArrayList<String>> mta = new LinkedHashMap<String, ArrayList<String>>();
                boolean b = CorleoneExternal.loadTypesFromFile(this.getComponentName(), typefile, mta);
                if (!b) {
                    Module.loggerMessage((String)("Could not initialize the configuration for the module [" + this.getComponentName() + "]"));
                    return false;
                }
                ArrayList<Instruction> instructions = new ArrayList<Instruction>();
                int i = 1;
                while (true) {
                    String s;
                    String dwhen = myProperties.getProperty("Drop." + i + ".when");
                    String dfrom = myProperties.getProperty("Drop." + i + ".from");
                    if (dwhen == null) break;
                    if (!mta.containsKey(dwhen)) {
                        Module.loggerMessage((String)("property [Drop." + i + ".when] in configuration file of the module [" + this.getComponentName() + "] refers to a type [" + dwhen + "] that doesn't exist"));
                        return false;
                    }
                    String dtarget = dfrom;
                    Instruction ins = new Instruction();
                    int idx = 0;
                    Iterator i$ = mta.keySet().iterator();
                    while (i$.hasNext() && !dwhen.equals(s = (String)i$.next())) {
                        ++idx;
                    }
                    ins._whentypeid = (short)idx;
                    ins._frommodulename = dtarget;
                    instructions.add(ins);
                    ++i;
                }
                _instructions = instructions;
            }
        }
        return true;
    }

    public static void term() {
        _instructions = null;
    }

    protected ArrayList<String> getTypes() {
        return new ArrayList<String>();
    }

    protected ArrayList<String> getAttributeNames(String type) {
        return new ArrayList<String>();
    }

    protected Object performTask(char[] inputText, ResultPool resultPool) throws ProcessingException {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(resultPool.getLastGrammarResult());
        for (Instruction ins : _instructions) {
            InputFSArrayList ifsal = resultPool.getMostRecentResultsForModule(ins._frommodulename);
            if (ifsal == null) {
                throw new AssertionError((Object)("CorleoneDropper instruction expects to find results for module [" + ins._frommodulename + "] but there was no result for such module"));
            }
            result.add(ifsal);
        }
        return result.toArray();
    }

    protected InputFSArrayList convertResult(Object obj, char[] inputText) {
        Instruction ins;
        int i;
        if (obj == null) {
            return null;
        }
        Object[] aobj = (Object[])obj;
        InputFSDArrayList ifsdal = (InputFSDArrayList)aobj[0];
        InputFSArrayList ifsal = ifsdal.convertToFlatList();
        HashMap<String, InputFSArrayList> m = new HashMap<String, InputFSArrayList>();
        for (i = 0; i < _instructions.size(); ++i) {
            ins = _instructions.get(i);
            m.put(ins._frommodulename, (InputFSArrayList)aobj[1 + i]);
        }
        for (i = 0; i < _instructions.size(); ++i) {
            ins = _instructions.get(i);
            ArrayList<InputFeatureStructure> lifs = new ArrayList<InputFeatureStructure>();
            for (int j = 0; j < ifsal.size(); ++j) {
                InputFeatureStructure ifs = ifsal.get(j);
                if (ins._whentypeid != ifs.getType()) continue;
                lifs.add(ifs);
            }
            Collections.sort(lifs, new Comparator<InputFeatureStructure>(){

                @Override
                public int compare(InputFeatureStructure o0, InputFeatureStructure o1) {
                    return o0.getStart() - o1.getStart();
                }
            });
            ArrayList<Integer> ldrop = new ArrayList<Integer>();
            InputFSArrayList ifsaldrop = (InputFSArrayList)m.get(ins._frommodulename);
            int k = 0;
            for (int j = 0; j < lifs.size(); ++j) {
                InputFeatureStructure ifsdrop;
                InputFeatureStructure ifs = (InputFeatureStructure)lifs.get(j);
                while (k < ifsaldrop.size() && (ifsdrop = ifsaldrop.get(k)).getStart() <= ifs.getEnd()) {
                    if (ifsdrop.getEnd() >= ifs.getStart() && (ifsdrop.getStart() != ifs.getStart() || ifsdrop.getEnd() != ifs.getEnd())) {
                        ldrop.add(k);
                    }
                    ++k;
                }
            }
            Collections.reverse(ldrop);
            LinkedHashSet lhs = new LinkedHashSet(ldrop);
            Iterator i$ = lhs.iterator();
            while (i$.hasNext()) {
                int d = (Integer)i$.next();
                ifsaldrop.get(d).setType((short)0);
                ifsaldrop.get(d).initializeAttributes((byte)0);
            }
            ifsaldrop.sort((Comparator)InputFeatureStructureComparator.getInstance());
        }
        return null;
    }

    private static final class Instruction {
        private short _whentypeid = (short)-1;
        private String _frommodulename;

        private Instruction() {
        }
    }
}

