/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.InputFeatureStructureComparator;
import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.results.ResultPool;
import it.jrc.rss.SimpleElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CorleoneExternal
extends Module {
    private static ArrayList<String> _types;
    private static Map<String, ArrayList<String>> _attributes;
    private static List<Transformation> _transformations;
    private static final ThreadLocal<List<SimpleElement>> _data;
    private static final ThreadLocal<int[]> _constraints;

    protected CorleoneExternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initialize() {
        Properties myProperties = this.getModulesConfiguration();
        Configuration myConfig = Configuration.initializeFrom((Properties)myProperties);
        if (myConfig.isNull()) {
            Module.loggerMessage((String)("Could not initialize the configuration for the module [" + this.getComponentName() + "]"));
            return false;
        }
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            if (_transformations == null) {
                String external;
                String typefile = myProperties.getProperty("TypeFile");
                if (typefile == null) {
                    Module.loggerMessage((String)("Missing property [TypeFile] in configuration file of the module [" + this.getComponentName() + "]"));
                    return false;
                }
                if (!new File(typefile).exists()) {
                    Module.loggerMessage((String)("property [TypeFile] in configuration file of the module [" + this.getComponentName() + "] refers to a file [" + typefile + "] that doesn't exist"));
                    return false;
                }
                LinkedHashMap<String, ArrayList<String>> mta = new LinkedHashMap<String, ArrayList<String>>();
                boolean b = CorleoneExternal.loadTypesFromFile(this.getComponentName(), typefile, mta);
                if (!b) {
                    Module.loggerMessage((String)("Could not initialize the configuration for the module [" + this.getComponentName() + "]"));
                    return false;
                }
                ArrayList<String> types = new ArrayList<String>();
                HashMap<String, ArrayList<String>> attributes = new HashMap<String, ArrayList<String>>();
                ArrayList<Transformation> transformations = new ArrayList<Transformation>();
                int i = 1;
                while ((external = myProperties.getProperty("External." + i)) != null) {
                    String[] aexternal = external.split(",");
                    if (aexternal.length < 2) {
                        Module.loggerMessage((String)("property [External." + i + "] in configuration file of the module [" + this.getComponentName() + "] is not of the correct format (element=type,attribute=attribute...)"));
                        return false;
                    }
                    Matcher m = Pattern.compile("(.+?)(\\((.+?)=(.+?)\\))?=(.+?)").matcher(aexternal[0]);
                    if (!m.matches()) {
                        Module.loggerMessage((String)("property [External." + i + "] in configuration file of the module [" + this.getComponentName() + "] type is not of the correct format (element=type)"));
                        return false;
                    }
                    String eelement = m.group(1);
                    String etype = m.group(5);
                    if (!mta.containsKey(etype)) {
                        Module.loggerMessage((String)("property [External." + i + "] in configuration file of the module [" + this.getComponentName() + "] refers to a type [" + etype + "] that doesn't exist"));
                        return false;
                    }
                    if (!types.contains(etype)) {
                        types.add(etype);
                        attributes.put(etype, (ArrayList<String>)mta.get(etype));
                    }
                    Transformation tra = new Transformation();
                    tra._element = eelement;
                    tra._typeid = (short)types.indexOf(etype);
                    tra._typeattributessize = (byte)((ArrayList)attributes.get(etype)).size();
                    if (m.group(3) != null && m.group(4) != null) {
                        tra._filtername = m.group(3);
                        tra._filtervalue = m.group(4).toLowerCase();
                    }
                    for (int j = 1; j < aexternal.length; ++j) {
                        m = Pattern.compile("(.+?)=(.+?)").matcher(aexternal[j]);
                        if (!m.matches()) {
                            Module.loggerMessage((String)("property [External." + i + "] in configuration file of the module [" + this.getComponentName() + "] attribute [" + aexternal[j] + "] is not of the correct format (attribute=attribute)"));
                            return false;
                        }
                        String attributeleft = m.group(1);
                        String attributeright = m.group(2);
                        if ("$START".equals(attributeright)) {
                            tra._start = attributeleft;
                            continue;
                        }
                        if ("$LENGTH".equals(attributeright)) {
                            tra._length = attributeleft;
                            continue;
                        }
                        if (attributeleft.startsWith("\"") && !attributeleft.endsWith("\"") || !attributeleft.startsWith("\"") && attributeleft.endsWith("\"")) {
                            Module.loggerMessage((String)("property [External." + i + "] in configuration file of the module [" + this.getComponentName() + "] attribute [" + aexternal[j] + "] is not of the correct format (\"constant\"=attribute)"));
                            return false;
                        }
                        int attributeidx = ((ArrayList)attributes.get(etype)).indexOf(attributeright);
                        if (attributeidx == -1) {
                            Module.loggerMessage((String)("property [External." + i + "] in configuration file of the module [" + this.getComponentName() + "] refers to an attribute [" + attributeright + "] that type [" + etype + "] doesn't have"));
                            return false;
                        }
                        tra.addAttribute(attributeleft, (byte)attributeidx);
                    }
                    if (tra._start == null) {
                        Module.loggerMessage((String)("property [External." + i + "] in configuration file of the module [" + this.getComponentName() + "] does not define mandatory attribute [$START] (<something>=$START)"));
                        return false;
                    }
                    if (tra._length == null) {
                        Module.loggerMessage((String)("property [External." + i + "] in configuration file of the module [" + this.getComponentName() + "] does not define mandatory attribute [$LENGTH] (<something>=$LENGTH)"));
                        return false;
                    }
                    transformations.add(tra);
                    ++i;
                }
                _types = types;
                _attributes = attributes;
                _transformations = transformations;
            }
        }
        return true;
    }

    public static void term() {
        _types = null;
        _attributes = null;
        _transformations = null;
    }

    protected ArrayList<String> getTypes() {
        return _types;
    }

    protected ArrayList<String> getAttributeNames(String type) {
        return _attributes.get(type);
    }

    protected Object performTask(char[] inputText, ResultPool resultPool) {
        List<SimpleElement> lse = _data.get();
        ArrayList<InputFeatureStructure> result = new ArrayList<InputFeatureStructure>();
        if (lse != null) {
            int[] constraints = _constraints.get();
            if (constraints[0] == -1) {
                constraints[0] = 0;
            }
            if (constraints[0] < -1 || constraints[0] > inputText.length) {
                Module.loggerMessage((String)("the module [" + this.getComponentName() + "] will not performTask() because constraint start [" + constraints[0] + "] is incompatible with inputText length [" + inputText.length + "]"));
                return result;
            }
            if (constraints[1] == -1) {
                constraints[1] = inputText.length;
            }
            if (constraints[1] < -1 || constraints[1] > inputText.length) {
                Module.loggerMessage((String)("the module [" + this.getComponentName() + "] will not performTask() because constraint stop [" + constraints[1] + "] is incompatible with inputText length [" + inputText.length + "]"));
                return result;
            }
            if (constraints[1] < constraints[0]) {
                Module.loggerMessage((String)("the module [" + this.getComponentName() + "] will not performTask() because constraint start [" + constraints[0] + "] and stop [" + constraints[1] + "] are incompatible"));
                return result;
            }
            if (constraints[2] < -1 || constraints[2] > inputText.length) {
                Module.loggerMessage((String)("the module [" + this.getComponentName() + "] will not performTask() because constraint offset [" + constraints[2] + "] is incompatible with inputText length [" + inputText.length + "]"));
                return result;
            }
            for (Transformation tra : _transformations) {
                for (SimpleElement se : lse) {
                    String value;
                    if (!tra._element.equals(se.getName()) || tra._filtername != null && ((value = se.getAttributeValue(tra._filtername)) == null || !tra._filtervalue.equals(value.toLowerCase()))) continue;
                    String pos = se.getAttributeValue(tra._start);
                    if (pos == null) {
                        Module.loggerMessage((String)("the element [" + se.getName() + "] cannot be used because it doesn't have the [" + tra._start + "] attribute"));
                        continue;
                    }
                    String[] aspos = pos.split(",");
                    int[] aipos = new int[aspos.length];
                    for (int i = 0; i < aspos.length; ++i) {
                        aipos[i] = Integer.parseInt(aspos[i]);
                    }
                    int length = -1;
                    int[] ailen = null;
                    if ("$value".equals(tra._length)) {
                        length = se.getValue().length();
                    } else {
                        String len = se.getAttributeValue(tra._length);
                        if (len == null) {
                            Module.loggerMessage((String)("the element [" + se.getName() + "] cannot be used because it doesn't have the [" + tra._length + "] attribute"));
                            continue;
                        }
                        String[] aslen = len.split(",");
                        ailen = new int[aslen.length];
                        for (int i = 0; i < aslen.length; ++i) {
                            ailen[i] = Integer.parseInt(aslen[i]);
                        }
                        if (aipos.length != ailen.length) {
                            Module.loggerMessage((String)("the element [" + se.getName() + "] cannot be used because the [" + tra._start + "] attribute and the [" + tra._length + "] attribute are not of the same number of elements"));
                            continue;
                        }
                    }
                    for (int i = 0; i < aipos.length; ++i) {
                        InputFeatureStructure ifs = new InputFeatureStructure();
                        ifs.setRuleID((int)InputFeatureStructure.UNBOUND);
                        ifs.setType(tra._typeid);
                        int start = aipos[i];
                        int end = -1;
                        end = length != -1 ? start + length - 1 : start + ailen[i] - 1;
                        if (constraints[0] > start || end > constraints[1]) continue;
                        if (constraints[2] > 0) {
                            start -= constraints[2];
                            end -= constraints[2];
                        }
                        ifs.setPosition(start, end);
                        Object[] atta = new String[tra._typeattributessize];
                        Arrays.fill(atta, "");
                        ifs.setAttributes(tra._typeattributessize, (String[])atta);
                        for (int j = 0; j < tra._attributenames.length; ++j) {
                            String val = null;
                            val = "$value".equals(tra._attributenames[j]) ? se.getValue() : ("$text".equals(tra._attributenames[j]) ? new String(inputText, ifs.getStart(), ifs.getEnd() - ifs.getStart() + 1) : ("$hash".equals(tra._attributenames[j]) ? String.valueOf(se.hashCode()) : (tra._attributenames[j].startsWith("\"") && tra._attributenames[j].endsWith("\"") ? tra._attributenames[j].substring(1, tra._attributenames[j].length() - 1) : se.getAttributeValue(tra._attributenames[j]))));
                            ifs.setAttribute((int)tra._attributeids[j], val);
                        }
                        result.add(ifs);
                    }
                }
            }
            Module.loggerMessage((String)("created #[" + result.size() + "] InputFeatureStructure out of #[" + lse.size() + "] SimpleElement"));
        }
        return result;
    }

    protected InputFSArrayList convertResult(Object obj, char[] inputText) {
        if (obj == null) {
            return null;
        }
        ArrayList ifsarr = (ArrayList)obj;
        InputFSArrayList result = new InputFSArrayList(ifsarr.size());
        for (InputFeatureStructure ifs : ifsarr) {
            result.add(ifs);
        }
        result.sort((Comparator)InputFeatureStructureComparator.getInstance());
        return result;
    }

    public static void setData(ArrayList<SimpleElement> data) {
        CorleoneExternal.setData(data, -1, -1, -1);
    }

    public static void setData(ArrayList<SimpleElement> data, int start, int stop, int offset) {
        _data.get().clear();
        if (data != null) {
            CorleoneExternal._constraints.get()[0] = start;
            CorleoneExternal._constraints.get()[1] = stop;
            CorleoneExternal._constraints.get()[2] = offset;
            _data.get().addAll(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadTypesFromFile(String componentName, String typefile, Map<String, ArrayList<String>> mta) {
        try {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(typefile)));
                String line = null;
                while ((line = br.readLine()) != null) {
                    String[] lina;
                    if ((line = line.replaceAll(" ", "")).startsWith("%") || (lina = line.split(":=")).length != 2) continue;
                    String typnam = lina[0].trim();
                    String typatt = lina[1].trim();
                    if (!typatt.startsWith("[") || !typatt.endsWith("]")) continue;
                    ArrayList<String> typeAttributes = new ArrayList<String>();
                    String[] typatta = typatt.substring(1, typatt.length() - 1).split(",");
                    for (int i = 0; i < typatta.length; ++i) {
                        typeAttributes.add(typatta[i].trim());
                    }
                    mta.put(typnam, typeAttributes);
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        catch (FileNotFoundException fnfex) {
            Module.loggerMessage((String)("Could not initialize the module [" + componentName + "] via reading the file [" + typefile + "] because of [" + fnfex.getMessage() + "]"));
            return false;
        }
        catch (IOException ioex) {
            Module.loggerMessage((String)("Could not initialize the module [" + componentName + "] via reading the file [" + typefile + "] because of [" + ioex.getMessage() + "]"));
            return false;
        }
        return true;
    }

    static {
        _data = new ThreadLocal<List<SimpleElement>>(){

            @Override
            public List<SimpleElement> initialValue() {
                return new ArrayList<SimpleElement>();
            }
        };
        _constraints = new ThreadLocal<int[]>(){

            @Override
            public int[] initialValue() {
                return new int[3];
            }
        };
    }

    private static final class Transformation {
        private String _element = null;
        private short _typeid = (short)-1;
        private byte _typeattributessize;
        private String _filtername;
        private String _filtervalue;
        private String _start;
        private String _length;
        private String[] _attributenames = null;
        private byte[] _attributeids = null;

        private Transformation() {
        }

        private void addAttribute(String name, byte id) {
            Object[] a;
            if (this._attributenames == null) {
                this._attributenames = new String[]{name};
            } else {
                a = new String[this._attributenames.length + 1];
                System.arraycopy(this._attributenames, 0, a, 0, this._attributenames.length);
                a[a.length - 1] = name;
                this._attributenames = a;
            }
            if (this._attributeids == null) {
                this._attributeids = new byte[]{id};
            } else {
                a = new byte[this._attributeids.length + 1];
                System.arraycopy(this._attributeids, 0, a, 0, this._attributeids.length);
                a[a.length - 1] = (String)id;
                this._attributeids = (byte[])a;
            }
        }
    }
}

