/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.module.CorleoneExternal;
import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.module.ProcessingException;
import it.jrc.lt.regexpfs.results.ResultPool;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class CorleoneReproducer
extends Module {
    private static ArrayList<String> _types;
    private static Map<String, ArrayList<String>> _attributes;
    private static List<Instruction> _instructions;

    protected CorleoneReproducer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initialize() {
        Properties myProperties = this.getModulesConfiguration();
        Configuration myConfig = Configuration.initializeFrom((Properties)myProperties);
        if (myConfig.isNull()) {
            Module.loggerMessage((String)("Could not initialize the configuration for the module [" + this.getComponentName() + "]"));
            return false;
        }
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            if (_instructions == null) {
                String typefile = myProperties.getProperty("TypeFile");
                if (typefile == null) {
                    Module.loggerMessage((String)("Missing property [TypeFile] in configuration file of the module [" + this.getComponentName() + "]"));
                    return false;
                }
                if (!new File(typefile).exists()) {
                    Module.loggerMessage((String)("property [TypeFile] in configuration file of the module [" + this.getComponentName() + "] refers to a file [" + typefile + "] that doesn't exist"));
                    return false;
                }
                LinkedHashMap<String, ArrayList<String>> mta = new LinkedHashMap<String, ArrayList<String>>();
                boolean b = CorleoneExternal.loadTypesFromFile(this.getComponentName(), typefile, mta);
                if (!b) {
                    Module.loggerMessage((String)("Could not initialize the configuration for the module [" + this.getComponentName() + "]"));
                    return false;
                }
                ArrayList<String> types = new ArrayList<String>();
                HashMap<String, ArrayList<String>> attributes = new HashMap<String, ArrayList<String>>();
                ArrayList<Instruction> instructions = new ArrayList<Instruction>();
                int i = 1;
                while (true) {
                    int j;
                    String[] arinherit;
                    String[] arsource;
                    String rtype = myProperties.getProperty("Reproduce." + i + ".type");
                    String rdefaults = myProperties.getProperty("Reproduce." + i + ".defaults");
                    String rsource = myProperties.getProperty("Reproduce." + i + ".source");
                    String rinherit = myProperties.getProperty("Reproduce." + i + ".inherit");
                    if (rtype == null) break;
                    if (!mta.containsKey(rtype)) {
                        Module.loggerMessage((String)("property [Reproduce." + i + ".type] in configuration file of the module [" + this.getComponentName() + "] refers to a type [" + rtype + "] that doesn't exist"));
                        return false;
                    }
                    String[] ardefaults = null;
                    if (rdefaults != null) {
                        ardefaults = rdefaults.trim().replaceAll(" +", " ").split(" ");
                        if (ardefaults.length % 2 != 0) {
                            Module.loggerMessage((String)("property [Reproduce." + i + ".defaults] in configuration file of the module [" + this.getComponentName() + "] is not in the expected format [attribute value]"));
                            return false;
                        }
                        for (int j2 = 0; j2 < ardefaults.length / 2; ++j2) {
                            if (((ArrayList)mta.get(rtype)).contains(ardefaults[2 * j2])) continue;
                            Module.loggerMessage((String)("property [Reproduce." + i + ".defaults] in configuration file of the module [" + this.getComponentName() + "] refers to an attribute [" + ardefaults[2 * j2] + "] that type [" + rtype + "] doesn't have"));
                            return false;
                        }
                    }
                    if ((arsource = rsource.trim().replaceAll(" +", " ").split(" ")).length != 2) {
                        Module.loggerMessage((String)("property [Reproduce." + i + ".source] in configuration file of the module [" + this.getComponentName() + "] is not in the expected format [ModuleName ModuleType]"));
                        return false;
                    }
                    if (!mta.containsKey(arsource[1])) {
                        Module.loggerMessage((String)("property [Reproduce." + i + ".source] in configuration file of the module [" + this.getComponentName() + "] refers to a type [" + arsource[1] + "] that doesn't exist"));
                        return false;
                    }
                    if (!rtype.equals(arsource[1])) {
                        List ls = (List)mta.get(arsource[1]);
                        List lt = (List)mta.get(rtype);
                        if (!((Object)ls).equals(lt = lt.subList(0, Math.min(ls.size(), lt.size())))) {
                            Module.loggerMessage((String)("property [Reproduce." + i + ".type] type [" + rtype + "] in configuration file of the module [" + this.getComponentName() + "] must have the same attributes (leading, in the same order) as [Reproduce." + i + ".source.type] type [" + arsource[1] + "] has"));
                            return false;
                        }
                    }
                    if ((arinherit = rinherit.trim().replaceAll(" +", " ").split(" ")).length < 3) {
                        Module.loggerMessage((String)("property [Reproduce." + i + ".inherit] in configuration file of the module [" + this.getComponentName() + "] is not in the expected format [ModuleName ModuleType TypeAttributes]"));
                        return false;
                    }
                    if (!mta.containsKey(arinherit[1])) {
                        Module.loggerMessage((String)("property [Reproduce." + i + ".inherit] in configuration file of the module [" + this.getComponentName() + "] refers to a type [" + arinherit[1] + "] that doesn't exist"));
                        return false;
                    }
                    for (int j3 = 2; j3 < arinherit.length; ++j3) {
                        if (!((ArrayList)mta.get(arinherit[1])).contains(arinherit[j3])) {
                            Module.loggerMessage((String)("property [Reproduce." + i + ".inherit] type [" + arinherit[1] + "] in configuration file of the module [" + this.getComponentName() + "] refers to an attribute [" + arinherit[j3] + "] that doesn't exist"));
                            return false;
                        }
                        if (((ArrayList)mta.get(rtype)).contains(arinherit[j3])) continue;
                        Module.loggerMessage((String)("property [Reproduce." + i + ".type] type [" + rtype + "] in configuration file of the module [" + this.getComponentName() + "] must have attribute [" + arinherit[j3] + "] as property [Reproduce." + i + ".inherit] type [" + arinherit[1] + "] has"));
                        return false;
                    }
                    Instruction ins = new Instruction();
                    if (!rtype.equals(arsource[1])) {
                        ins._typeid = (short)types.size();
                        ins._typeattributessize = (byte)((ArrayList)mta.get(rtype)).size();
                        types.add(rtype);
                        attributes.put(rtype, (ArrayList<String>)mta.get(rtype));
                    }
                    if (ardefaults != null) {
                        Instruction.access$302(ins, new Object[ardefaults.length]);
                        for (j = 0; j < ardefaults.length / 2; ++j) {
                            ((Instruction)ins)._defaults[2 * j] = ((ArrayList)mta.get(rtype)).indexOf(ardefaults[2 * j]);
                            ((Instruction)ins)._defaults[2 * j + 1] = ardefaults[2 * j + 1];
                        }
                    }
                    ins._sourcemodulename = arsource[0];
                    ins._sourcetypeattributessize = (byte)((ArrayList)mta.get(arsource[1])).size();
                    ins._inheritmodulename = arinherit[0];
                    Instruction.access$702(ins, new int[arinherit.length - 2][]);
                    for (j = 0; j < ins._inheritattributesids.length; ++j) {
                        ((Instruction)ins)._inheritattributesids[j] = new int[]{((ArrayList)mta.get(arinherit[1])).indexOf(arinherit[j + 2]), ((ArrayList)mta.get(rtype)).indexOf(arinherit[j + 2])};
                    }
                    instructions.add(ins);
                    ++i;
                }
                _types = types;
                _attributes = attributes;
                _instructions = instructions;
            }
        }
        return true;
    }

    public static void term() {
        _types = null;
        _attributes = null;
        _instructions = null;
    }

    protected ArrayList<String> getTypes() {
        return _types;
    }

    protected ArrayList<String> getAttributeNames(String type) {
        return _attributes.get(type);
    }

    protected Object performTask(char[] inputText, ResultPool resultPool) throws ProcessingException {
        Object[] result = new Object[2 * _instructions.size()];
        int i = 0;
        for (Instruction ins : _instructions) {
            result[i++] = resultPool.getCurrentResultsForModule(ins._sourcemodulename);
            result[i++] = resultPool.getCurrentResultsForModule(ins._inheritmodulename);
        }
        return result;
    }

    protected InputFSArrayList convertResult(Object obj, char[] inputText) {
        if (obj == null) {
            return null;
        }
        Object[] aobj = (Object[])obj;
        InputFSArrayList result = new InputFSArrayList();
        for (int i = 0; i < _instructions.size(); ++i) {
            InputFeatureStructure ifs;
            int j;
            Instruction ins = _instructions.get(i);
            InputFSArrayList ifsal = (InputFSArrayList)aobj[2 * i];
            if (ins._typeid != -1) {
                InputFSArrayList ifsalcopy = new InputFSArrayList();
                for (int j2 = 0; j2 < ifsal.size(); ++j2) {
                    InputFeatureStructure ifs2 = ifsal.get(j2);
                    InputFeatureStructure ifscopy = new InputFeatureStructure();
                    ifscopy.setPosition(ifs2.getStart(), ifs2.getEnd());
                    ifscopy.setType(ins._typeid);
                    ifscopy.initializeAttributes(ins._typeattributessize);
                    for (int k = 0; k < ins._sourcetypeattributessize; ++k) {
                        ifscopy.setAttribute(k, ifs2.getValue(k));
                    }
                    ifsalcopy.add(ifscopy);
                    result.add(ifscopy);
                }
                ifsal = ifsalcopy;
            }
            InputFSArrayList ifsalinherit = (InputFSArrayList)aobj[2 * i + 1];
            ReproducerHelper rh = new ReproducerHelper(ifsalinherit, ins._inheritattributesids);
            for (j = 0; j < ifsal.size(); ++j) {
                ifs = ifsal.get(j);
                Object[][] aao = rh.getAt(ifs.getStart(), ifs.getEnd());
                if (aao == null) continue;
                for (Object[] ao : aao) {
                    ifs.setAttribute(((Integer)ao[0]).intValue(), (String)ao[1]);
                }
            }
            if (ins._defaults == null) continue;
            for (j = 0; j < ifsal.size(); ++j) {
                ifs = ifsal.get(j);
                for (int k = 0; k < ins._defaults.length / 2; ++k) {
                    int idx = (Integer)ins._defaults[2 * k];
                    if (ifs.getValue(idx) != null) continue;
                    ifs.setAttribute(idx, (String)ins._defaults[2 * k + 1]);
                }
            }
        }
        return result;
    }

    private final class ReproducerHelper {
        private InputFSArrayList _ifsal;
        private int[][] _attributes;
        private int _idxcurrent;
        private int _startcurrent;

        private ReproducerHelper(InputFSArrayList ifsal, int[][] attributes) {
            this._ifsal = ifsal;
            this._attributes = attributes;
            if (this._ifsal.isEmpty()) {
                this._idxcurrent = -1;
                this._startcurrent = Integer.MAX_VALUE;
            } else {
                this._idxcurrent = 0;
                this._startcurrent = this._ifsal.get(0).getStart();
            }
        }

        private Object[][] getAt(int start, int end) {
            Object[][] result = null;
            if (end >= this._startcurrent) {
                ArrayList<Object[]> ls = new ArrayList<Object[]>();
                for (int i = this._idxcurrent; i < this._ifsal.size(); ++i) {
                    InputFeatureStructure ifs = this._ifsal.get(i);
                    if (ifs.getEnd() < start) {
                        this._idxcurrent = i;
                        this._startcurrent = ifs.getEnd() + 1;
                    }
                    if (ifs.getStart() > end) break;
                    if (start < ifs.getStart() || end > ifs.getEnd()) continue;
                    for (int[] att : this._attributes) {
                        String v = ifs.getValue(att[0]);
                        if (v == null) continue;
                        ls.add(new Object[]{att[1], v});
                    }
                }
                result = (Object[][])ls.toArray((T[])new Object[0][]);
            }
            return result;
        }
    }

    private static final class Instruction {
        private short _typeid = (short)-1;
        private Object[] _defaults;
        private byte _typeattributessize;
        private String _sourcemodulename;
        private byte _sourcetypeattributessize;
        private String _inheritmodulename;
        private int[][] _inheritattributesids;

        private Instruction() {
        }

        static /* synthetic */ Object[] access$302(Instruction x0, Object[] x1) {
            x0._defaults = x1;
            return x1;
        }

        static /* synthetic */ int[][] access$702(Instruction x0, int[][] x1) {
            x0._inheritattributesids = x1;
            return x1;
        }
    }
}

