/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.grabber;

import it.jrc.osint.grabber.GrabberService;
import it.jrc.osint.grabber.GrabberServicePreferences;
import it.jrc.osint.grabber.internal.GrabberServiceImpl;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.net.ProxyServiceClient;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class GrabberPlugin
extends Plugin {
    private static final Logger log = LogManager.getLogger((String)GrabberPlugin.class.getName());
    public static final String PLUGIN_ID = "it.jrc.osint.grabber";
    private static GrabberPlugin plugin;
    private GrabberServiceImpl grabberService;
    private ProxyServiceClient proxyServiceClient;
    private EventBroker eventBroker;

    public static GrabberPlugin getPlugin() {
        return plugin;
    }

    public static GrabberService getGrabberService() {
        return GrabberPlugin.getPlugin().grabberService;
    }

    public static EventBroker getEventBroker() {
        return GrabberPlugin.getPlugin().eventBroker;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.eventBroker = new EventBroker(context);
        this.proxyServiceClient = new ProxyServiceClient(context);
        this.grabberService = new GrabberServiceImpl(this.eventBroker, this.proxyServiceClient);
        this.grabberService.start();
        this.initPreferences();
    }

    public void stop(BundleContext context) throws Exception {
        this.grabberService.stop();
        this.proxyServiceClient.stop();
        this.eventBroker.stop();
        plugin = null;
        super.stop(context);
    }

    private void initPreferences() {
        GrabberServicePreferences gsPrefs = new GrabberServicePreferences(PLUGIN_ID);
        gsPrefs.init();
    }
}

