/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.grabber.internal;

import com.google.common.collect.ArrayListMultimap;
import it.jrc.emmutils.HTTPStream;
import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.console.OSINTConsolePlugin;
import it.jrc.osint.grabber.GrabberPlugin;
import it.jrc.osint.grabber.GrabberService;
import it.jrc.osint.grabber.GrabberServiceEvent;
import it.jrc.osint.grabber.GrabberServicePreferences;
import it.jrc.osint.grabber.internal.GrabItemTask;
import it.jrc.osint.grabber.internal.GrabberParameters;
import it.jrc.osint.grabber.internal.GrabberServiceEventImpl;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.GrabberMetaData;
import it.jrc.osint.metadata.SearchMetaData;
import it.jrc.osint.operations.FetchStatus;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.util.URLUtil;
import it.jrc.osint.util.concurrent.CollectionProducer;
import it.jrc.osint.util.concurrent.DefaultProcessingContext;
import it.jrc.osint.util.concurrent.ListConsumer;
import it.jrc.osint.util.concurrent.ParallelProcessor;
import it.jrc.osint.util.concurrent.ProcessingContext;
import it.jrc.osint.util.concurrent.ProcessingException;
import it.jrc.osint.util.concurrent.ProcessorParameters;
import it.jrc.osint.util.concurrent.Producer;
import it.jrc.osint.util.concurrent.Task;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.SystemEventImpl;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.osint.util.io.TmpDirSupport;
import it.jrc.osint.util.net.ProxyData;
import it.jrc.osint.util.net.ProxyServiceClient;
import it.jrc.osint.workspace.CaseProject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class GrabberServiceImpl
implements GrabberService {
    private static final Logger log = LogManager.getLogger((String)GrabberServiceImpl.class.getName());
    private static final int SERIAL_DOWNLOAD_THRESHOLD = 5;
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();
    private EventBroker eventBroker;
    private ProxyServiceClient proxyServiceClient;
    private TmpDirSupport tmpDirSupport = new TmpDirSupport();

    public GrabberServiceImpl(EventBroker eventBroker, ProxyServiceClient proxyServiceClient) {
        this.eventBroker = eventBroker;
        this.proxyServiceClient = proxyServiceClient;
    }

    private GrabberParameters getParameters() {
        int maxParallelThreads = this.getGrabberServicePreferences().getMaxParallelThreads();
        int minimumRandomDelay = this.getGrabberServicePreferences().getMinimumRandomDelayMs();
        int httpTimeoutMs = this.getGrabberServicePreferences().getHttpTimeoutMs();
        GrabberParameters params = new GrabberParameters();
        params.setThreadPoolSize(maxParallelThreads);
        params.setMinimumRandomDelayMs(minimumRandomDelay);
        params.setHttpTimeOutMillis(httpTimeoutMs);
        return params;
    }

    public void start() {
        this.tmpDirSupport.init(GrabberPlugin.getPlugin().getStateLocation().toFile());
        this.eventBroker.register(new String[]{"osint/grabber/grabbingFinished"}, this.topicEventListener);
    }

    public void stop() {
        this.eventBroker.unregister(this.topicEventListener);
        this.tmpDirSupport.cleanup();
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        String proposedFileName = null;
        proposedFileName = prefix.endsWith(suffix) ? prefix : String.valueOf(prefix) + suffix;
        String fileName = FileUtil.getNextAvailableName((File)this.tmpDirSupport.getTmpDir(), (String)proposedFileName);
        File tempFile = new File(this.tmpDirSupport.getTmpDir(), fileName);
        return tempFile;
    }

    @Override
    public void grab(List<URLBookmark> bookmarks, String operationName, CaseProject targetProject) {
        this.updateHttpStreamProxy();
        if (bookmarks == null || bookmarks.isEmpty()) {
            return;
        }
        ArrayListMultimap domainMap = ArrayListMultimap.create();
        for (URLBookmark bm : bookmarks) {
            String domainKey = URLUtil.getDomainName((String)bm.getURL());
            if (domainKey == null) continue;
            domainMap.put((Object)domainKey, (Object)bm);
        }
        String correlationId = SystemEventImpl.createCorrelationId();
        ArrayList<URLBookmark> parallelDownloadBookmarks = new ArrayList<URLBookmark>();
        for (String domainKey : domainMap.keySet()) {
            List domainBookmarks = domainMap.get((Object)domainKey);
            if (domainBookmarks.size() > 5) {
                this.grabSerial(domainBookmarks, operationName, targetProject, correlationId);
                continue;
            }
            parallelDownloadBookmarks.addAll(domainBookmarks);
        }
        if (!parallelDownloadBookmarks.isEmpty()) {
            this.grabParallel(parallelDownloadBookmarks, operationName, targetProject, correlationId);
        }
    }

    private void grabParallel(List<URLBookmark> bookmarks, String operationName, CaseProject targetProject, String correlationId) {
        List<DocumentMetaItem> inputItemList = this.createInputItemList(bookmarks);
        GrabberJob job = new GrabberJob("HTTP Grabber", inputItemList, operationName, targetProject, this.getParameters(), correlationId);
        job.addJobChangeListener((IJobChangeListener)new JobChangeListener());
        job.schedule();
    }

    private void grabSerial(List<URLBookmark> bookmarks, String operationName, CaseProject targetProject, String correlationId) {
        List<DocumentMetaItem> inputItemList = this.createInputItemList(bookmarks);
        GrabberParameters parameters = this.getParameters();
        parameters.setThreadPoolSize(1);
        parameters.setMinimumRandomDelayMs(3000);
        GrabberJob job = new GrabberJob("HTTP Grabber", inputItemList, operationName, targetProject, parameters, correlationId);
        job.addJobChangeListener((IJobChangeListener)new JobChangeListener());
        job.schedule();
    }

    private List<DocumentMetaItem> createInputItemList(List<URLBookmark> bookmarks) {
        ArrayList<DocumentMetaItem> itemList = new ArrayList<DocumentMetaItem>();
        for (URLBookmark bm : bookmarks) {
            DocumentMetaItem item = new DocumentMetaItem();
            SearchMetaData smd = new SearchMetaData(item);
            smd.setSearchEngine(bm.getSearchEngine());
            smd.setSearchQuery(bm.getSearchQuery());
            item.setLink(bm.getURL());
            itemList.add(item);
        }
        return itemList;
    }

    @Override
    public boolean grabImage(String url, File targetFile) {
        this.updateHttpStreamProxy();
        try (HTTPStream httpStream = new HTTPStream(url, 5000L);){
            if (httpStream.getStatus() == 200) {
                log.debug("httpStream.redirectLocation=" + httpStream.getRedirectLocation());
                boolean bl = this.downloadBinaryContent(httpStream, targetFile);
                return bl;
            }
            return false;
        }
    }

    private boolean downloadBinaryContent(HTTPStream httpStream, File targetFile) {
        if (httpStream.getType() != null && httpStream.getType().equals("html")) {
            return false;
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            try {
                int ch;
                in = new BufferedInputStream((InputStream)httpStream);
                out = new BufferedOutputStream(new FileOutputStream(targetFile));
                while ((ch = in.read()) != -1) {
                    out.write(ch);
                }
                out.flush();
            }
            catch (Throwable t) {
                FileUtil.close(in);
                FileUtil.close(out);
                return false;
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close((InputStream)in);
        FileUtil.close((OutputStream)out);
        return true;
    }

    private void updateHttpStreamProxy() {
        if (this.proxyServiceClient == null) {
            return;
        }
        if (this.proxyServiceClient.isProxyEnabled("HTTP")) {
            ProxyData pd = this.proxyServiceClient.getProxyData("HTTP");
            HTTPStream.setProxy((String)pd.getProxyHost(), (String)Integer.toString(pd.getProxyPort()), (String)pd.getNonProxiedHostsList(), (String)pd.getUserId(), (String)pd.getUserPassword());
        } else {
            HTTPStream.disableProxy();
        }
    }

    public GrabberServicePreferences getGrabberServicePreferences() {
        return new GrabberServicePreferences("it.jrc.osint.grabber");
    }

    private class GrabberJob
    extends Job {
        private GrabberParameters params;
        private Producer<DocumentMetaItem> producer;
        private ListConsumer<DocumentMetaItem> consumer;
        private String operationName;
        private CaseProject targetProject;
        private String correlationId;

        public GrabberJob(String jobName, List<DocumentMetaItem> inputItems, String operationName, CaseProject targetProject, GrabberParameters params, String correlationId) {
            super(jobName);
            this.producer = new CollectionProducer(inputItems);
            this.operationName = operationName;
            this.targetProject = targetProject;
            this.params = params;
            if (this.params == null) {
                this.params = new GrabberParameters();
            }
            this.correlationId = correlationId;
            this.consumer = new ListConsumer();
        }

        protected IStatus run(IProgressMonitor monitor) {
            log.debug("Grabber started");
            try {
                ParallelProcessor grabberProcessor = new ParallelProcessor(this.producer, this.consumer, (Task)new GrabItemTask(OSINTConsolePlugin.getConsole(), GrabberServiceImpl.this));
                int expectedItemCount = this.producer.expectedItemCount();
                if (expectedItemCount > 0 && expectedItemCount < this.params.getThreadPoolSize()) {
                    this.params.setThreadPoolSize(expectedItemCount);
                }
                grabberProcessor.setParameters((ProcessorParameters)this.params);
                grabberProcessor.setContext((ProcessingContext)new GrabberProcessingContext(this.params));
                grabberProcessor.setName("http-grabber");
                grabberProcessor.setItemsDescriptor("URLs");
                grabberProcessor.setTaskDescriptor("Downloading");
                Future processorFuture = grabberProcessor.start(monitor);
                processorFuture.get();
            }
            catch (Exception e) {
                log.error("Grabber failed", (Throwable)e);
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        List<DocumentMetaItem> getResultItems() {
            return this.consumer.getConsumedItems();
        }

        String getResultName() {
            return this.operationName;
        }

        CaseProject getTargetProject() {
            return this.targetProject;
        }

        String getCorrelationId() {
            return this.correlationId;
        }
    }

    class GrabberProcessingContext
    extends DefaultProcessingContext {
        private GrabberParameters params;

        public GrabberProcessingContext(GrabberParameters params) {
            this.params = params;
        }

        public int getMaxTextSize() {
            return this.params.getMaxTextSize();
        }

        public int getMinTextSize() {
            return this.params.getMinTextSize();
        }

        public long getHttpTimeoutMillis() {
            return this.params.getHttpTimeOutMillis();
        }

        public void init() throws ProcessingException {
        }

        public int getMiniumRandomDelayMs() {
            return this.params.getMinimumRandomDelayMs();
        }
    }

    private class JobChangeListener
    extends JobChangeAdapter {
        public void done(IJobChangeEvent event) {
            if (event == null) {
                return;
            }
            GrabberJob job = (GrabberJob)event.getJob();
            GrabberServiceEventImpl grabberEvent = new GrabberServiceEventImpl("osint/grabber/grabbingFinished", job.getCorrelationId());
            grabberEvent.setTargetProject(job.getTargetProject());
            if (event.getResult() == Status.OK_STATUS) {
                grabberEvent.setStatus(OperationStatus.OK_STATUS);
                grabberEvent.setOperationName(job.getResultName());
                ArrayList<DocumentMetaItem> downloadedItems = new ArrayList<DocumentMetaItem>();
                ArrayList<DocumentMetaItem> failedItems = new ArrayList<DocumentMetaItem>();
                for (DocumentMetaItem item : job.getResultItems()) {
                    GrabberMetaData gmd = new GrabberMetaData(item);
                    if (gmd.getFetchStatus() == FetchStatus.SUCCESS) {
                        downloadedItems.add(item);
                        continue;
                    }
                    failedItems.add(item);
                }
                grabberEvent.setDownloadedItems(downloadedItems);
                grabberEvent.setFailedItems(failedItems);
            } else {
                grabberEvent.setStatus(OperationStatus.CANCEL_STATUS);
            }
            GrabberPlugin.getEventBroker().postEvent((SystemEvent)grabberEvent);
        }
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            GrabberServiceEvent gsEvent;
            if ("osint/grabber/grabbingFinished".equals(event.getTopic()) && (gsEvent = (GrabberServiceEvent)event).getStatus() == OperationStatus.OK_STATUS) {
                List<DocumentMetaItem> downloadedItems = gsEvent.getDownloadedItems();
                ArrayList<File> importFiles = new ArrayList<File>();
                String operationName = gsEvent.getOperationName();
                ListIterator<DocumentMetaItem> itemIterator = downloadedItems.listIterator();
                while (itemIterator.hasNext()) {
                    DocumentMetaItem item = itemIterator.next();
                    GrabberMetaData gmd = new GrabberMetaData(item);
                    File importFile = null;
                    try {
                        String filePath = gmd.getRawContentPath();
                        importFile = new File(filePath);
                    }
                    catch (Throwable t) {
                        log.error("Failed to find downloaded file for import", t);
                    }
                    if (importFile != null) {
                        importFiles.add(importFile);
                        continue;
                    }
                    itemIterator.remove();
                }
                IPath targetPath = gsEvent.getTargetProject().getDocumentFolderPath().append(operationName);
                gsEvent.getTargetProject().importFiles(importFiles, downloadedItems, targetPath, gsEvent.getCorrelationId());
            }
        }
    }
}

