/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.ui.decorator;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.ui.WorkspaceUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.widgets.Display;

public class ConfigProjectDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    private static final Logger log = LogManager.getLogger((String)ConfigProjectDecorator.class.getName());

    public void decorate(Object element, final IDecoration decoration) {
        if (element instanceof IProject) {
            IProject aProject = (IProject)element;
            try {
                if (aProject.isAccessible() && aProject.hasNature("it.jrc.osint.workspace.configProjectNature")) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ImageDescriptor overlayIcon = WorkspaceUIPlugin.getPlugin().getImageRegistry().getDescriptor("config_overlay");
                                decoration.addOverlay(overlayIcon, 0);
                            }
                            catch (Throwable t) {
                                log.error("Failed to add Config project overlay icon", t);
                            }
                        }
                    });
                }
            }
            catch (Throwable t) {
                log.error("Decoration failed", t);
            }
        }
    }
}

