/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.graph;

import it.jrc.osint.analysis.graph.GraphEdge;
import it.jrc.osint.analysis.relation.DocumentEntityRelation;
import it.jrc.osint.extract.entities.Entity;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DocumentEntityEdge
implements GraphEdge<Object> {
    private Entity entityVertex;
    private String docVertex;
    private int weight;
    private final int hashCode;

    public DocumentEntityEdge(Entity entVertex, String docVertex, DocumentEntityRelation aRelation) {
        this.entityVertex = entVertex;
        this.docVertex = docVertex;
        this.weight = aRelation.getWeight();
        this.hashCode = new HashCodeBuilder(13, 31).append(this.entityVertex.getId()).append((Object)this.docVertex).toHashCode();
    }

    public Entity getEntity() {
        return this.entityVertex;
    }

    public String getDocumentId() {
        return this.docVertex;
    }

    @Override
    public Object getOtherVertex(Object ent) {
        if (this.entityVertex.equals(ent)) {
            return this.docVertex;
        }
        if (this.docVertex.equals(ent)) {
            return this.entityVertex;
        }
        return null;
    }

    public Entity getEntityVertex() {
        return this.entityVertex;
    }

    public String getDocumentVertex() {
        return this.docVertex;
    }

    @Override
    public Object[] getVertices() {
        return new Object[]{this.docVertex, this.entityVertex};
    }

    public String getLabel() {
        return "";
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public void increaseWeight() {
        ++this.weight;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (otherObject == this) {
            return true;
        }
        if (otherObject instanceof DocumentEntityEdge) {
            DocumentEntityEdge otherEdge = (DocumentEntityEdge)otherObject;
            return this.entityVertex.equals((Object)otherEdge.entityVertex) && this.docVertex.equals(otherEdge.docVertex);
        }
        return false;
    }
}

