/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.graph;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import it.jrc.osint.analysis.graph.DocumentEntityEdge;
import it.jrc.osint.analysis.graph.RelationshipGraph;
import it.jrc.osint.analysis.relation.DocumentEntityRelation;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.jgrapht.EdgeFactory;

public class DocumentEntityRelationshipGraph
extends RelationshipGraph<Object, DocumentEntityEdge> {
    private static final Logger log = LogManager.getLogger((String)DocumentEntityRelationshipGraph.class.getName());
    private LoadingCache<Entity, Set<String>> relatedDocsCache = CacheBuilder.newBuilder().build((CacheLoader)new RelatedDocsLoader());
    private LoadingCache<String, Set<Entity>> relatedEntityCache = CacheBuilder.newBuilder().build((CacheLoader)new RelatedEntitiesLoader());

    @Override
    public boolean contains(Object vertex) {
        return this.getVertices().contains(vertex);
    }

    @Override
    public void addEdge(DocumentEntityRelation newRelation) {
        String documentId;
        Entity entity = newRelation.getEntity();
        if (!this.graph.containsVertex((Object)entity)) {
            this.graph.addVertex((Object)entity);
        }
        if (!this.graph.containsVertex((Object)(documentId = newRelation.getDocumentId()))) {
            this.graph.addVertex((Object)documentId);
        }
        DocumentEntityEdge dee = new DocumentEntityEdge(entity, documentId, newRelation);
        this.graph.addEdge((Object)dee.getEntityVertex(), (Object)dee.getDocumentVertex(), (Object)dee);
    }

    public int getEntityOccurrences(Entity entityVertex) {
        int result = 0;
        try {
            if (entityVertex == null) {
                return result;
            }
            if (!this.graph.containsVertex((Object)entityVertex)) {
                return result;
            }
            Set edgeSet = this.graph.edgesOf((Object)entityVertex);
            Iterator iterator = edgeSet.iterator();
            while (iterator.hasNext()) {
                DocumentEntityEdge edge;
                DocumentEntityEdge entityDocEdge = edge = (DocumentEntityEdge)iterator.next();
                result += entityDocEdge.getWeight();
            }
        }
        catch (Throwable t) {
            log.error("Failed to compute number of entity occurrences", t);
        }
        return result;
    }

    public int getEntityOccurrences(String documentVertex, Entity entityVertex) {
        DocumentEntityEdge edge = (DocumentEntityEdge)this.graph.getEdge((Object)documentVertex, (Object)entityVertex);
        if (edge != null) {
            DocumentEntityEdge docEntityEdge = edge;
            return docEntityEdge.getWeight();
        }
        return 0;
    }

    public Set<String> getRelatedDocumentIds(Entity entityVertex) {
        try {
            return (Set)this.relatedDocsCache.get((Object)entityVertex);
        }
        catch (Throwable t) {
            log.error("Failed to load related documents from cache", t);
            return Collections.emptySet();
        }
    }

    private Set<String> doGetRelatedDocumentIds(Entity entityVertex) {
        HashSet<String> result = new HashSet<String>();
        if (entityVertex == null) {
            return result;
        }
        if (!this.graph.containsVertex((Object)entityVertex)) {
            return result;
        }
        Set edgeSet = this.graph.edgesOf((Object)entityVertex);
        for (DocumentEntityEdge edge : edgeSet) {
            String relatedDocId = edge.getDocumentId();
            result.add(relatedDocId);
        }
        return result;
    }

    public Set<Entity> getRelatedEntities(String docVertex) {
        try {
            return (Set)this.relatedEntityCache.get((Object)docVertex);
        }
        catch (Throwable t) {
            log.error("Failed to load related entities for document from cache", t);
            return Collections.emptySet();
        }
    }

    private Set<Entity> doGetRelatedEntities(String docVertex) {
        HashSet<Entity> result = new HashSet<Entity>();
        if (docVertex == null) {
            return result;
        }
        if (!this.graph.containsVertex((Object)docVertex)) {
            return result;
        }
        Set edgeSet = this.graph.edgesOf((Object)docVertex);
        for (DocumentEntityEdge edge : edgeSet) {
            Entity relatedEntity = edge.getEntity();
            result.add(relatedEntity);
        }
        return result;
    }

    public Set<DocumentEntityEdge> getEdges(String docVertex) {
        HashSet<DocumentEntityEdge> result = new HashSet<DocumentEntityEdge>();
        if (docVertex == null) {
            return result;
        }
        if (!this.graph.containsVertex((Object)docVertex)) {
            return result;
        }
        return this.graph.edgesOf((Object)docVertex);
    }

    @Override
    protected EdgeFactory<Object, DocumentEntityEdge> getEdgeFactory() {
        log.error("getEdgeFactory not implemented");
        throw new NotImplementedException("getEdgeFactory not implemented");
    }

    public Set<String> getConnectingDocuments(Entity entityA, Entity entityB) {
        Set<String> aDocs = this.getRelatedDocumentIds(entityA);
        Set<String> bDocs = this.getRelatedDocumentIds(entityB);
        Sets.SetView intersecDocs = Sets.intersection(aDocs, bDocs);
        return intersecDocs.immutableCopy();
    }

    private class RelatedDocsLoader
    extends CacheLoader<Entity, Set<String>> {
        private RelatedDocsLoader() {
        }

        public Set<String> load(Entity anEntity) throws Exception {
            return DocumentEntityRelationshipGraph.this.doGetRelatedDocumentIds(anEntity);
        }
    }

    private class RelatedEntitiesLoader
    extends CacheLoader<String, Set<Entity>> {
        private RelatedEntitiesLoader() {
        }

        public Set<Entity> load(String docVertex) throws Exception {
            return DocumentEntityRelationshipGraph.this.doGetRelatedEntities(docVertex);
        }
    }
}

