/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.graph;

import it.jrc.osint.analysis.graph.GraphEdge;
import it.jrc.osint.extract.entities.Entity;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class EntityEntityEdge
implements GraphEdge<Entity> {
    private Entity sourceVertex;
    private Entity targetVertex;
    private int weight = 1;
    private final int hashCode;

    public EntityEntityEdge(Entity sourceVertex, Entity targetVertex) {
        this.sourceVertex = sourceVertex;
        this.targetVertex = targetVertex;
        this.hashCode = new HashCodeBuilder(13, 37).append(this.sourceVertex.getId()).append(this.targetVertex.getId()).hashCode();
    }

    public Entity[] getVertices() {
        return new Entity[]{this.sourceVertex, this.targetVertex};
    }

    public Entity getSourceVertex() {
        return this.sourceVertex;
    }

    public Entity getTargetVertex() {
        return this.targetVertex;
    }

    @Override
    public Entity getOtherVertex(Entity ent) {
        if (this.sourceVertex.equals((Object)ent)) {
            return this.targetVertex;
        }
        return this.sourceVertex;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public void increaseWeight() {
        ++this.weight;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (otherObject == this) {
            return true;
        }
        if (otherObject instanceof EntityEntityEdge) {
            EntityEntityEdge otherEdge = (EntityEntityEdge)otherObject;
            return this.sourceVertex.equals((Object)otherEdge.sourceVertex) && this.targetVertex.equals((Object)otherEdge.targetVertex) || this.sourceVertex.equals((Object)otherEdge.targetVertex) && this.targetVertex.equals((Object)otherEdge.sourceVertex);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.sourceVertex.toString()) + " -- " + this.targetVertex.toString();
    }
}

