/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.graph;

import it.jrc.osint.analysis.graph.GraphEdge;
import it.jrc.osint.analysis.graph.SimpleTableGraph;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.KShortestPaths;

public abstract class RelationshipGraph<V, E extends GraphEdge<V>> {
    private static final Logger log = LogManager.getLogger((String)RelationshipGraph.class.getName());
    protected UndirectedGraph<V, E> graph = new SimpleTableGraph();

    protected abstract EdgeFactory<V, E> getEdgeFactory();

    public void clear() {
        this.graph = new SimpleTableGraph();
    }

    public void addEdge(E edge) {
        if (edge != null && !this.graph.containsEdge(edge)) {
            Object v1 = edge.getVertices()[0];
            Object v2 = edge.getVertices()[1];
            if (!this.graph.containsVertex(v1)) {
                this.graph.addVertex(v1);
            }
            if (!this.graph.containsVertex(v2)) {
                this.graph.addVertex(v2);
            }
            this.graph.addEdge(v1, v2, edge);
        }
    }

    public E getEdge(V sourceVertex, V destVertex) {
        return (E)((GraphEdge)this.graph.getEdge(sourceVertex, destVertex));
    }

    public void addVertex(V vertex) {
        if (vertex != null && !this.graph.containsVertex(vertex)) {
            this.graph.addVertex(vertex);
        }
    }

    public void removeVertex(V vertex) {
        if (vertex != null && this.graph.containsVertex(vertex)) {
            this.graph.removeVertex(vertex);
        }
    }

    public Set<V> getRelatedVertices(V vertex) {
        if (vertex == null) {
            return Collections.emptySet();
        }
        HashSet<V> result = new HashSet<V>();
        if (vertex != null) {
            Set edgeSet = this.graph.edgesOf(vertex);
            for (GraphEdge edge : edgeSet) {
                V relatedVertex = edge.getOtherVertex(vertex);
                result.add(relatedVertex);
            }
        }
        return result;
    }

    public boolean contains(V vertex) {
        return this.graph.containsVertex(vertex);
    }

    public Set<V> getVertices() {
        return this.graph.vertexSet();
    }

    public Set<E> getEdges() {
        return this.graph.edgeSet();
    }

    public int calculateShortestPath(V start, V end) {
        if (start.equals(end)) {
            return 0;
        }
        KShortestPaths ksp = new KShortestPaths(this.graph, start, 1);
        List shortestPaths = ksp.getPaths(end);
        if (shortestPaths.size() == 0) {
            return -1;
        }
        return ((GraphPath)shortestPaths.get(0)).getEdgeList().size();
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }
}

