/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.graph;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.UndirectedGraph;

public class SimpleTableGraph<V, E>
implements UndirectedGraph<V, E> {
    private static final Logger log = LogManager.getLogger((String)SimpleTableGraph.class.getName());
    private Table<V, V, E> table = HashBasedTable.create();
    private Set<V> vertexSet = new HashSet<V>();
    private Map<E, EdgeEntry> edgeMap = new HashMap<E, EdgeEntry>();
    private EdgeFactory<V, E> edgeFactory;

    public SimpleTableGraph() {
    }

    public SimpleTableGraph(EdgeFactory<V, E> edgeFactory) {
        this.edgeFactory = edgeFactory;
    }

    public E addEdge(V vertex1, V vertex2) {
        if (vertex1 == null || vertex2 == null) {
            throw new NullPointerException("Vertex parameter is null");
        }
        if (!this.containsVertex(vertex1) || !this.containsVertex(vertex2)) {
            throw new IllegalArgumentException("Vertex parameter not contained in graph");
        }
        if (this.edgeFactory != null) {
            E existingEdge = this.getEdge(vertex1, vertex2);
            if (existingEdge == null) {
                Object newEdge = this.getEdgeFactory().createEdge(vertex1, vertex2);
                if (this.addEdge(vertex1, vertex2, newEdge)) {
                    return (E)newEdge;
                }
                return null;
            }
            return null;
        }
        throw new IllegalStateException("No EdgeFactory set");
    }

    public boolean addEdge(V vertex1, V vertex2, E edge) {
        if (vertex1 == null || vertex2 == null) {
            throw new NullPointerException("Vertex parameter is null");
        }
        if (!this.containsVertex(vertex1) || !this.containsVertex(vertex2)) {
            throw new IllegalArgumentException("Vertex parameter not existing");
        }
        if (this.table.contains(vertex1, vertex2)) {
            return false;
        }
        this.table.put(vertex1, vertex2, edge);
        this.table.put(vertex2, vertex1, edge);
        EdgeEntry edgeEntry = new EdgeEntry(vertex1, vertex2);
        this.edgeMap.put(edge, edgeEntry);
        return true;
    }

    public boolean addVertex(V vertex) {
        return this.vertexSet.add(vertex);
    }

    public boolean containsEdge(E edge) {
        return this.edgeMap.containsKey(edge);
    }

    public boolean containsEdge(V vertex1, V vertex2) {
        return this.table.contains(vertex1, vertex2);
    }

    public boolean containsVertex(V vertex) {
        return this.vertexSet.contains(vertex);
    }

    public Set<E> edgeSet() {
        return this.edgeMap.keySet();
    }

    public Set<E> edgesOf(V vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException("Vertex parameter not in graph");
        }
        if (vertex == null) {
            throw new NullPointerException("Vertex parameter is null");
        }
        Map columnMap = this.table.column(vertex);
        HashSet edgeSet = new HashSet();
        edgeSet.addAll(columnMap.values());
        return edgeSet;
    }

    public Set<E> getAllEdges(V vertex1, V vertex2) {
        if (!this.containsVertex(vertex1) || !this.containsVertex(vertex2)) {
            return null;
        }
        HashSet<E> resultSet = new HashSet<E>();
        resultSet.add(this.getEdge(vertex1, vertex2));
        return resultSet;
    }

    public E getEdge(V vertex1, V vertex2) {
        return (E)this.table.get(vertex1, vertex2);
    }

    public EdgeFactory<V, E> getEdgeFactory() {
        return this.edgeFactory;
    }

    public V getEdgeSource(E edge) {
        if (this.containsEdge(edge)) {
            EdgeEntry ee = this.edgeMap.get(edge);
            return ee.getSourceVertex();
        }
        return null;
    }

    public V getEdgeTarget(E edge) {
        if (this.containsEdge(edge)) {
            EdgeEntry ee = this.edgeMap.get(edge);
            return ee.getTargetVertex();
        }
        return null;
    }

    public double getEdgeWeight(E edge) {
        return 1.0;
    }

    public boolean removeAllEdges(Collection<? extends E> edges) {
        boolean graphChanged = false;
        for (E edge : edges) {
            EdgeEntry ee;
            if (!this.containsEdge(edge) || (ee = this.edgeMap.get(edge)) == null) continue;
            this.table.remove(ee.getSourceVertex(), ee.getTargetVertex());
            this.table.remove(ee.getTargetVertex(), ee.getSourceVertex());
            this.edgeMap.remove(edge);
            graphChanged = true;
        }
        return graphChanged;
    }

    public Set<E> removeAllEdges(V vertex1, V vertex2) {
        if (!this.containsVertex(vertex1) || !this.containsVertex(vertex2)) {
            return null;
        }
        HashSet<Object> resultSet = new HashSet<Object>();
        Object edge = this.table.get(vertex1, vertex2);
        if (edge != null) {
            this.table.remove(vertex1, vertex2);
            this.table.remove(vertex2, vertex1);
            this.edgeMap.remove(edge);
            resultSet.add(edge);
        }
        return resultSet;
    }

    public boolean removeAllVertices(Collection<? extends V> vertices) {
        boolean graphChanged = false;
        for (V vertex : vertices) {
            if (!this.vertexSet.contains(vertex)) continue;
            this.vertexSet.remove(vertex);
            if (this.table.containsRow(vertex)) {
                this.table.row(vertex).clear();
            }
            if (this.table.containsColumn(vertex)) {
                this.table.column(vertex).clear();
            }
            graphChanged = true;
        }
        return graphChanged;
    }

    public boolean removeEdge(E edge) {
        boolean graphChanged = false;
        if (this.containsEdge(edge)) {
            EdgeEntry ee = this.edgeMap.remove(edge);
            this.table.remove(ee.getSourceVertex(), ee.getTargetVertex());
            this.table.remove(ee.getTargetVertex(), ee.getSourceVertex());
            graphChanged = true;
        }
        return graphChanged;
    }

    public E removeEdge(V vertex1, V vertex2) {
        E removedEdge = null;
        if (this.containsEdge(vertex1, vertex2)) {
            removedEdge = this.getEdge(vertex1, vertex2);
            EdgeEntry ee = this.edgeMap.remove(removedEdge);
            this.table.remove(ee.getSourceVertex(), ee.getTargetVertex());
            this.table.remove(ee.getTargetVertex(), ee.getSourceVertex());
        }
        return removedEdge;
    }

    public boolean removeVertex(V vertex) {
        if (this.containsVertex(vertex)) {
            this.vertexSet.remove(vertex);
            if (this.table.containsRow(vertex)) {
                this.table.row(vertex).clear();
            }
            if (this.table.containsColumn(vertex)) {
                this.table.column(vertex).clear();
            }
            return true;
        }
        return false;
    }

    public Set<V> vertexSet() {
        return this.vertexSet;
    }

    public int degreeOf(V vertex) {
        return this.table.row(vertex).size();
    }

    private class EdgeEntry {
        private V sourceVertex;
        private V targetVertex;

        EdgeEntry(V sourceVertex, V targetVertex) {
            this.sourceVertex = sourceVertex;
            this.targetVertex = targetVertex;
        }

        V getSourceVertex() {
            return this.sourceVertex;
        }

        V getTargetVertex() {
            return this.targetVertex;
        }

        public String toString() {
            return String.valueOf(this.sourceVertex.toString()) + ":" + this.targetVertex.toString();
        }
    }
}

