/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.internal;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.ErrorConditions;
import it.jrc.osint.analysis.graph.DocumentEntityRelationshipGraph;
import it.jrc.osint.analysis.graph.EntityEntityEdge;
import it.jrc.osint.analysis.graph.EntityEntityRelationshipGraph;
import it.jrc.osint.analysis.relation.DocumentEntityRelation;
import it.jrc.osint.analysis.relation.DocumentEntityRelationImpl;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationResult;
import it.jrc.osint.operations.OperationStatus;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jgrapht.alg.BellmanFordShortestPath;

public class AnalysisDatamodelImpl
implements AnalysisDatamodel {
    private static final Logger log = LogManager.getLogger((String)AnalysisDatamodelImpl.class.getName());
    public static final AnalysisDatamodel NULL_DATAMODEL = new AnalysisDatamodelImpl(ResourceId.NULL_ID);
    private Set<String> documentSet = new HashSet<String>();
    private Map<Long, Entity> entityMap = new HashMap<Long, Entity>();
    private DocumentEntityRelationshipGraph docEntityGraph = new DocumentEntityRelationshipGraph();
    private EntityEntityRelationshipGraph entityEntityGraph = new EntityEntityRelationshipGraph();
    private ResourceId projectId;

    public AnalysisDatamodelImpl(ResourceId projectId) {
        this.projectId = projectId;
    }

    @Override
    public boolean isNull() {
        return ResourceId.NULL_ID.equals((Object)this.projectId);
    }

    @Override
    public ResourceId getProjectId() {
        return this.projectId;
    }

    @Override
    public boolean contains(ResourceId docId) {
        return this.getDocumentIds().contains(docId.toString());
    }

    @Override
    public Set<String> getDocumentIds() {
        return this.documentSet;
    }

    @Override
    public Set<Entity> getEntities() {
        HashSet<Entity> resultSet = new HashSet<Entity>();
        resultSet.addAll(this.entityMap.values());
        return resultSet;
    }

    @Override
    public Entity getEntity(long anId) {
        return this.entityMap.get(anId);
    }

    @Override
    public Entity findEntityByName(String name) {
        if (name == null || "".equals(name)) {
            return Entity.NULL_ENTITY;
        }
        String nameToFind = name.trim();
        for (Entity e : this.entityMap.values()) {
            String entityName = e.getName();
            if (entityName == null || !(entityName = entityName.trim()).equals(nameToFind)) continue;
            return e;
        }
        return Entity.NULL_ENTITY;
    }

    @Override
    public OperationResult<Set<Entity>> findEntityByNamePattern(String namePattern) {
        HashSet resultSet = new HashSet();
        if (namePattern == null || "".equals(namePattern)) {
            return new OperationResult(resultSet, OperationStatus.CANCEL_STATUS);
        }
        Pattern p = null;
        try {
            p = Pattern.compile(namePattern);
        }
        catch (PatternSyntaxException e) {
            return new OperationResult(resultSet, new OperationStatus(ErrorConditions.getErrorConditions().getErrorCondition(ErrorConditions.REGEX_PATTERN_COMPILE_FAILED, e)));
        }
        Set<Entity> allEntities = this.getEntities();
        Iterator<Entity> entitiesIterator = allEntities.iterator();
        while (entitiesIterator.hasNext()) {
            Entity anEntity = entitiesIterator.next();
            Matcher m = p.matcher(anEntity.getName());
            if (m.matches()) continue;
            entitiesIterator.remove();
        }
        return new OperationResult(allEntities, OperationStatus.OK_STATUS);
    }

    @Override
    public OperationResult<Set<Entity>> findEntityByEntityType(String typeAcronym) {
        HashSet resultSet = new HashSet();
        if (typeAcronym == null || "".equals(typeAcronym)) {
            return new OperationResult(resultSet, OperationStatus.CANCEL_STATUS);
        }
        Set<Entity> allEntities = this.getEntities();
        Iterator<Entity> entitiesIterator = allEntities.iterator();
        while (entitiesIterator.hasNext()) {
            Entity anEntity = entitiesIterator.next();
            String entityTypeId = anEntity.getType();
            if (typeAcronym.equals(entityTypeId)) continue;
            entitiesIterator.remove();
        }
        return new OperationResult(allEntities, OperationStatus.OK_STATUS);
    }

    void addDocumentEntityRelations(ResourceId docId, Set<DocumentEntityRelation> docEntityRelations) {
        for (DocumentEntityRelation rel : docEntityRelations) {
            if (rel == DocumentEntityRelationImpl.NULL_RELATION) continue;
            this.entityMap.put(rel.getEntity().getId(), rel.getEntity());
            this.documentSet.add(rel.getDocumentId());
            this.docEntityGraph.addEdge(rel);
        }
        this.entityEntityGraph.addEdges(docId, docEntityRelations);
    }

    @Override
    public DocumentEntityRelationshipGraph getDocumentEntityRelationshipGraph() {
        return this.docEntityGraph;
    }

    @Override
    public synchronized EntityEntityRelationshipGraph getEntityEntityRelationshipGraph(IProgressMonitor monitor) {
        return this.entityEntityGraph;
    }

    @Override
    public synchronized Set<EntityEntityEdge> calculateShortestPathsBellmannFord(Set<Entity> existingVertices, Entity newVertex, int maxHops, IProgressMonitor monitor) {
        if (existingVertices == null || existingVertices.isEmpty() || newVertex == null) {
            return Collections.emptySet();
        }
        if (!this.docEntityGraph.contains(newVertex)) {
            log.debug("addShortestPaths: datamodel does not contain vertex ");
            return Collections.emptySet();
        }
        try {
            HashSet<EntityEntityEdge> edgesToAdd = new HashSet<EntityEntityEdge>();
            if (monitor.isCanceled()) {
                Set<EntityEntityEdge> set = Collections.emptySet();
                return set;
            }
            int existingVertexCount = existingVertices.size();
            if (existingVertexCount == 0) {
                existingVertexCount = 1;
            }
            monitor.beginTask("Calculating entity-entity graph", existingVertexCount + 50);
            EntityEntityRelationshipGraph eerGraph = this.getEntityEntityRelationshipGraph((IProgressMonitor)new SubProgressMonitor(monitor, 50));
            BellmanFordShortestPath dsp = new BellmanFordShortestPath(eerGraph.getGraph(), (Object)newVertex, maxHops);
            for (Entity existingVertex : existingVertices) {
                if (existingVertex.equals((Object)newVertex)) continue;
                List edgeList = dsp.getPathEdgeList((Object)existingVertex);
                for (EntityEntityEdge edge : edgeList) {
                    edgesToAdd.add(edge);
                }
                monitor.worked(1);
            }
            HashSet<EntityEntityEdge> hashSet = edgesToAdd;
            return hashSet;
        }
        catch (Throwable t) {
            log.error("Failed to add shortest paths between existing and new entity", t);
            Set<EntityEntityEdge> set = Collections.emptySet();
            return set;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Set<ResourceId> getRelatedDocumentIds(Entity anEntity) {
        Set<String> relatedDocIds = this.docEntityGraph.getRelatedDocumentIds(anEntity);
        HashSet<ResourceId> resultSet = new HashSet<ResourceId>();
        for (String docId : relatedDocIds) {
            resultSet.add(new ResourceId(docId));
        }
        return resultSet;
    }

    @Override
    public Set<Entity> getRelatedEntities(ResourceId docId) {
        return this.docEntityGraph.getRelatedEntities(docId.toString());
    }

    @Override
    public Set<Entity> getRelatedEntities(Entity anEntity) {
        Set<ResourceId> relatedDocIds = this.getRelatedDocumentIds(anEntity);
        HashSet<Entity> resultSet = new HashSet<Entity>();
        for (ResourceId aDocId : relatedDocIds) {
            Set<Entity> docRelatedEntities = this.getRelatedEntities(aDocId);
            resultSet.addAll(docRelatedEntities);
        }
        return resultSet;
    }

    @Override
    public int getEntityOccurrenceCount(Entity anEntity) {
        return this.docEntityGraph.getEntityOccurrences(anEntity);
    }

    @Override
    public int getEntityOccurrenceCount(Entity anEntity, ResourceId docId) {
        return this.docEntityGraph.getEntityOccurrences(docId.toString(), anEntity);
    }

    @Override
    public int getRelatedDocsCount(Entity anEntity) {
        return this.getRelatedDocumentIds(anEntity).size();
    }

    @Override
    public int getCooccurrenceCount(Entity entityA, Entity entityB) {
        EntityEntityRelationshipGraph eerGraph = this.getEntityEntityRelationshipGraph(null);
        EntityEntityEdge eee = (EntityEntityEdge)eerGraph.getEdge(entityA, entityB);
        if (eee != null) {
            return eee.getWeight();
        }
        return 0;
    }

    @Override
    public int getCooccurrenceDocsCount(Entity entityA, Entity entityB) {
        return this.getConnectingDocuments(entityA, entityB).size();
    }

    @Override
    public Set<ResourceId> getConnectingDocuments(Entity entityA, Entity entityB) {
        Set<String> connectingDocs = this.docEntityGraph.getConnectingDocuments(entityA, entityB);
        HashSet<ResourceId> resultSet = new HashSet<ResourceId>();
        for (String docId : connectingDocs) {
            resultSet.add(new ResourceId(docId));
        }
        return resultSet;
    }

    public int hashCode() {
        return this.getProjectId().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof AnalysisDatamodelImpl) {
            AnalysisDatamodel otherModel = (AnalysisDatamodel)other;
            return this.getProjectId().equals((Object)otherModel.getProjectId());
        }
        return false;
    }
}

