/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.parser;

import it.jrc.osint.analysis.parser.ParseException;
import it.jrc.rss.SimpleAttribute;
import it.jrc.rss.SimpleElement;

public abstract class _ElementParserBase {
    protected String getMandatoryAttribute(SimpleElement se, String attributeName) throws ParseException {
        SimpleAttribute sa = se.getAttribute(attributeName);
        if (sa == null) {
            throw new ParseException("Could not find mandatory attribute " + attributeName);
        }
        String value = sa.value;
        if (value == null || "".equals(value)) {
            throw new ParseException("Could not find value of mandatory attribute " + attributeName);
        }
        return value;
    }

    protected String getOptionalAttribute(SimpleElement se, String attributeName, String defaultValue) throws ParseException {
        SimpleAttribute sa = se.getAttribute(attributeName);
        if (sa == null) {
            return defaultValue;
        }
        return sa.value;
    }

    protected int toInt(String str) throws ParseException {
        int result = 0;
        try {
            result = Integer.parseInt(str);
            return result;
        }
        catch (Throwable t) {
            throw new ParseException("Could not parse to integer value", t);
        }
    }

    protected long toLong(String str) throws ParseException {
        long result = 0L;
        try {
            result = Long.parseLong(str);
            return result;
        }
        catch (Throwable t) {
            throw new ParseException("Could not parse to long value", t);
        }
    }

    protected int[] toIntArray(String str) throws ParseException {
        if (str == null || "".equals(str)) {
            return new int[0];
        }
        try {
            String[] intParts = str.split(",");
            int[] results = null;
            if ("".equals(intParts[intParts.length - 1])) {
                results = new int[intParts.length - 1];
            }
            results = new int[intParts.length];
            int i = 0;
            String[] stringArray = intParts;
            int n = intParts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (!"".equals(part)) {
                    results[i++] = Integer.parseInt(part);
                }
                ++n2;
            }
            return results;
        }
        catch (Throwable t) {
            throw new ParseException("Failed to parse to int array", t);
        }
    }
}

