/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui;

import it.jrc.osint.extract.ExtractPlugin;
import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.extract.NameVariantDatabase;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.ui.TextStyleRegistry;
import it.jrc.osint.workspace.WorkspaceService;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ExtractUIPlugin
extends AbstractUIPlugin {
    private static final Logger log = LogManager.getLogger((String)ExtractUIPlugin.class.getName());
    public static final String PLUGIN_ID = "it.jrc.osint.extract.ui";
    public static final String RED_COLOR = "red";
    public static final String BLACK_COLOR = "black";
    private static ExtractUIPlugin plugin;
    private TextStyleRegistry textStyleRegistry;
    private ColorRegistry colorRegistry;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ExtractUIPlugin getPlugin() {
        return plugin;
    }

    private void initializeColorRegistry(ColorRegistry reg) {
        reg.put(RED_COLOR, new RGB(255, 0, 0));
        reg.put(BLACK_COLOR, new RGB(0, 0, 0));
        reg.put("p", new RGB(0, 57, 230));
        reg.put("o", new RGB(57, 0, 230));
        reg.put("t", new RGB(172, 0, 230));
        reg.put("ur", new RGB(230, 0, 172));
        reg.put("dt", new RGB(0, 172, 230));
        reg.put("cc", new RGB(36, 91, 255));
        reg.put("pn", new RGB(92, 136, 255));
        reg.put("em", new RGB(230, 0, 57));
        reg.put("zc", new RGB(0, 230, 57));
        reg.put("pi", new RGB(57, 230, 0));
    }

    private ColorRegistry createColorRegistry() {
        if (Display.getCurrent() != null) {
            return new ColorRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ColorRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    private ColorRegistry getColorRegistry() {
        if (this.colorRegistry == null) {
            this.colorRegistry = this.createColorRegistry();
            this.initializeColorRegistry(this.colorRegistry);
        }
        return this.colorRegistry;
    }

    private void initializeTextStyleRegistry() {
        this.textStyleRegistry = new TextStyleRegistry();
        this.textStyleRegistry.register("error", this.getColor(RED_COLOR));
        this.textStyleRegistry.register("output", this.getColor(BLACK_COLOR));
    }

    public Color getColor(String symbolicName) {
        Color result = this.getColorRegistry().get(symbolicName);
        if (result == null) {
            result = this.getColorRegistry().get(BLACK_COLOR);
        }
        return result;
    }

    public TextStyleRegistry getTextStyleRegistry() {
        if (this.textStyleRegistry == null) {
            this.initializeTextStyleRegistry();
        }
        return this.textStyleRegistry;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put("cross", ExtractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/famfamfam/cross.gif"));
        reg.put("error_ovr", ExtractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/eclipse.pde.ui/icons/ovr16/error_co.gif"));
    }

    public static ExtractionService getExtractionService() {
        return ExtractPlugin.getExtractionService();
    }

    public static NameVariantDatabase getNameVariantDatabase() {
        return ExtractPlugin.getNameVariantDatabase();
    }

    public static WorkspaceService getWorkspaceService() {
        return ExtractPlugin.getWorkspaceService();
    }
}

