/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.decorator;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.MarkerUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.widgets.Display;

public class ExtractionStatusDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    private static final Logger log = LogManager.getLogger((String)ExtractionStatusDecorator.class.getName());

    public void decorate(Object element, final IDecoration decoration) {
        if (element instanceof IResource) {
            IProject aProject;
            if (element instanceof IProject && !(aProject = (IProject)element).isAccessible()) {
                return;
            }
            IResource aResource = (IResource)element;
            boolean isMarkedForExtraction = MarkerUtil.isMarked((IResource)aResource, (String)"it.jrc.osint.workspace.entityExtractionMarker");
            if (isMarkedForExtraction) {
                log.debug("Decorating " + aResource.getName());
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        decoration.addPrefix("> ");
                    }
                });
            }
        }
    }
}

