/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.decorator;

import it.jrc.osint.extract.ui.ExtractUIPlugin;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.MarkerUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.widgets.Display;

public class TextExtractionErrorDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    private static final Logger log = LogManager.getLogger((String)TextExtractionErrorDecorator.class.getName());

    public void decorate(Object element, final IDecoration decoration) {
        if (element instanceof IResource) {
            IResource aResource = (IResource)element;
            if (!(aResource instanceof IFile)) {
                return;
            }
            boolean isMarkedWithErrorStatus = MarkerUtil.isMarked((IResource)aResource, (String)"it.jrc.osint.workspace.errorStatusMarker");
            if (isMarkedWithErrorStatus) {
                log.debug("Decorating " + aResource.getName());
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ImageDescriptor overlayIcon = ExtractUIPlugin.getPlugin().getImageRegistry().getDescriptor("error_ovr");
                        decoration.addOverlay(overlayIcon, 2);
                    }
                });
            }
        }
    }
}

