/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.dialog;

import it.jrc.osint.extract.NameVariant;
import it.jrc.osint.extract.NameVariantDatabase;
import it.jrc.osint.extract.NameVariantProfile;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.extract.ui.dialog.EditProfileDialog;
import it.jrc.osint.extract.ui.dialog.EditProfileModel;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class EditProfileController {
    private static final Logger log = LogManager.getLogger((String)EditProfileController.class.getName());
    private NameVariantDatabase nvdb;
    private EditProfileDialog view;
    private EditProfileModel model;

    public EditProfileController(NameVariantDatabase nvdb) {
        this.nvdb = nvdb;
    }

    public void editExistingProfile(NameVariantProfile profile, OperationContext context) {
        this.model = new EditProfileModel(profile, context);
    }

    public void editNewProfile(OperationContext context) {
        NameVariant newVariant = this.createNameVariant("New_Variant", "p");
        ArrayList<NameVariant> variants = new ArrayList<NameVariant>();
        variants.add(newVariant);
        NameVariantProfile newProfile = new NameVariantProfile(variants);
        this.nvdb.createVariantProfile(newProfile, context);
        this.model = new EditProfileModel(newProfile, context);
    }

    public int openView(Shell parentShell) {
        if (this.view == null) {
            this.view = new EditProfileDialog(parentShell, this);
        }
        return this.view.open();
    }

    void onViewCreation() {
        this.view.setProfileName(this.model.getProfileName());
        this.view.getEntityTypeComboViewer().setInput((Object)this.getNameVariantDb().getSupportedEntityTypes());
        String entityTypeStr = this.model.getEntityType();
        EntityType entityType = this.getNameVariantDb().findEntityTypeById(entityTypeStr);
        this.view.getEntityTypeComboViewer().setSelection((ISelection)new StructuredSelection((Object)entityType));
        this.view.getNameVariantTableViewer().setInput(this.model.getNameVariants());
        this.view.enableAddButton();
        this.view.disableIgnoreButton();
        this.view.disableChangeProfileButton();
    }

    public String getProfileName() {
        return this.model.getProfileName();
    }

    public void changeNameOfVariant(NameVariant variant, String newName) {
        String variantName = variant.getName();
        if (variantName != null && variantName.equals(newName)) {
            return;
        }
        boolean validated = true;
        if (newName == null || "".equals(newName)) {
            this.view.showWarningDialog("Empty variant names are not supported");
            validated = false;
        }
        if (validated && this.model.hasVariantName(newName)) {
            this.view.showWarningDialog("Variant name \"" + newName + "\" already exists within this profile, please choose different name");
            validated = false;
        }
        if (validated && this.existsVariantName(newName, variant.getType())) {
            this.view.showWarningDialog("Variant name \"" + newName + "\" already exists as part of another profile, please choose different name");
            validated = false;
        }
        if (validated) {
            this.nvdb.changeNameOfVariant(variant, newName, this.model.getOperationContext());
            variant.setName(newName);
        }
        this.view.setProfileName(this.model.getProfileName());
        this.view.refreshNameVariantTableViewer();
    }

    public void changeEntityTypeOfProfile(EntityType newEntityType) {
        NameVariantProfile profile = this.model.getProfile();
        if (profile.getCanonicalNameVariant().getType().equals(newEntityType.getId())) {
            return;
        }
        this.getNameVariantDb().changeEntityTypeOfProfile(profile, newEntityType.getId(), this.model.getOperationContext());
        this.model.setEntityType(newEntityType.getId());
    }

    public void changeValidStateOfVariant(NameVariant variant, Boolean newState) {
        boolean state = variant.isValid();
        if (!newState.equals(state)) {
            this.nvdb.changeValidStateOfVariant(variant, newState, this.model.getOperationContext());
            variant.setValid(newState.booleanValue());
        }
        this.view.refreshNameVariantTableViewer();
    }

    void addNewNameVariant() {
        List<NameVariant> variants = this.model.getNameVariants();
        String initialNewName = this.nextAvailableNameVariant(this.model.getProfileName(), variants);
        NameVariant newVariant = new NameVariant(-1L, initialNewName);
        newVariant.setValid(true);
        this.model.getProfile().add(newVariant);
        this.getNameVariantDb().addNameVariant(this.model.getProfile(), newVariant.getName(), newVariant, this.model.getOperationContext());
        this.view.refreshNameVariantTableViewer();
    }

    void deleteNameVariant() {
        boolean isSingleVariantProfile;
        NameVariant nameVariant = this.model.getSelectedVariant();
        boolean isCanonicalVariant = this.model.isCanonicalVariant(nameVariant);
        boolean bl = isSingleVariantProfile = this.model.getNameVariants().size() == 1;
        if (isSingleVariantProfile) {
            this.view.showInfoDialog("Please delete the complete profile from the main dialog");
            return;
        }
        if (isCanonicalVariant) {
            NameVariant nonCanonicalVariant = this.model.getNonCanonicalNameVariant();
            if (nonCanonicalVariant == null) {
                this.view.showWarningDialog("Please select a non canonical variant to delete");
                log.error("Failed to delete canonical name variant, no other variant found");
                return;
            }
            this.performChangeCanonicalVariantOfProfile(nonCanonicalVariant);
        }
        this.model.getProfile().remove(nameVariant);
        this.getNameVariantDb().deleteNameVariant(this.model.getProfile(), nameVariant, this.model.getOperationContext());
        this.view.refreshNameVariantTableViewer();
    }

    private String nextAvailableNameVariant(String newName, List<NameVariant> variants) {
        String nextAvailableName = newName;
        int i = 1;
        while (this.hasNameVariant(nextAvailableName, variants)) {
            nextAvailableName = String.valueOf(newName) + "_" + i++;
        }
        return nextAvailableName;
    }

    private boolean hasNameVariant(String name, List<NameVariant> variants) {
        for (NameVariant v : variants) {
            if (v == null || !v.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    void selectNameVariant(NameVariant nv) {
        this.model.selectNameVariant(nv);
        if (nv.isStoredInDB()) {
            this.view.setIgnoreButtonLabel("Ignore Variant");
        } else {
            this.view.setIgnoreButtonLabel("Remove Variant");
        }
        this.view.enableIgnoreButton();
        this.view.enableChangeProfileButton();
    }

    void deselectNameVariant() {
        this.model.selectNameVariant(null);
        this.view.disableIgnoreButton();
        this.view.disableChangeProfileButton();
        this.view.setIgnoreButtonLabel("Ignore Variant");
    }

    void changeCanonicalVariantOfProfile() {
        NameVariant newCanonicalVariant = this.model.getSelectedVariant();
        if (newCanonicalVariant == null) {
            return;
        }
        this.performChangeCanonicalVariantOfProfile(newCanonicalVariant);
    }

    private void performChangeCanonicalVariantOfProfile(NameVariant newCanonicalVariant) {
        NameVariant oldCanonicalVariant = this.model.getCanonicalNameVariant();
        if (newCanonicalVariant.equals((Object)oldCanonicalVariant)) {
            return;
        }
        this.getNameVariantDb().changeCanonicalVariantOfProfile(this.model.getProfile(), newCanonicalVariant, this.model.getOperationContext());
        this.model.setCanonicalVariant(newCanonicalVariant);
        this.view.setProfileName(this.model.getProfileName());
        this.view.refreshNameVariantTableViewer();
    }

    private NameVariantDatabase getNameVariantDb() {
        return this.nvdb;
    }

    public NameVariant createNameVariant(String name, String type) {
        String variantName = this.nextAvailableNameVariant(name, type);
        NameVariant nv = new NameVariant(variantName, type);
        return nv;
    }

    private String nextAvailableNameVariant(String name, String type) {
        String nextAvailableName = name;
        int i = 1;
        while (this.existsVariantName(nextAvailableName, type)) {
            nextAvailableName = String.valueOf(name) + "_" + i++;
        }
        return nextAvailableName;
    }

    public boolean existsVariantName(String variantName, String type) {
        return this.getNameVariantDb().existsVariantName(variantName, type);
    }
}

