/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.dialog;

import it.jrc.osint.extract.NameVariant;
import it.jrc.osint.extract.NameVariantProfile;
import it.jrc.osint.operations.OperationContext;
import java.util.List;

class EditProfileModel {
    private NameVariantProfile profile;
    private NameVariant selectedVariant;
    private OperationContext operationContext;

    EditProfileModel(NameVariantProfile aProfile, OperationContext operationContext) {
        this.profile = aProfile;
        this.operationContext = operationContext;
    }

    OperationContext getOperationContext() {
        return this.operationContext;
    }

    List<NameVariant> getNameVariants() {
        return this.profile.getNameVariants();
    }

    NameVariant getCanonicalNameVariant() {
        return this.profile.getCanonicalNameVariant();
    }

    NameVariant getNonCanonicalNameVariant() {
        NameVariant cnv = this.getCanonicalNameVariant();
        List nameVariants = this.profile.getNameVariants();
        for (NameVariant aVariant : nameVariants) {
            if (cnv.equals((Object)aVariant)) continue;
            return aVariant;
        }
        return null;
    }

    String getProfileName() {
        return this.getCanonicalNameVariant().getName();
    }

    boolean isCanonicalVariant(NameVariant aVariant) {
        return this.getCanonicalNameVariant().equals((Object)aVariant);
    }

    void setCanonicalVariant(NameVariant aVariant) {
        this.profile.setCanonicalNameVariant(aVariant);
    }

    String getEntityType() {
        return this.getCanonicalNameVariant().getType();
    }

    void setEntityType(String newType) {
        if (newType == null) {
            return;
        }
        List<NameVariant> nameVariants = this.getNameVariants();
        for (NameVariant nv : nameVariants) {
            nv.setType(newType);
        }
    }

    NameVariantProfile getProfile() {
        return this.profile;
    }

    void selectNameVariant(NameVariant selectedVariant) {
        this.selectedVariant = selectedVariant;
    }

    NameVariant getSelectedVariant() {
        return this.selectedVariant;
    }

    boolean hasVariantName(String name) {
        List variants = this.profile.getNameVariants();
        for (NameVariant nv : variants) {
            String variantName = nv.getName();
            if (variantName == null || !variantName.equals(name)) continue;
            return true;
        }
        return false;
    }
}

