/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.handler;

import it.jrc.osint.extract.ui.ExtractUIPlugin;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CleanBuildExtractionHandler
extends AbstractHandler
implements IHandler {
    private static final Logger log = LogManager.getLogger((String)CleanBuildExtractionHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        if (window == null) {
            return null;
        }
        ISelectionService selectionSvc = window.getSelectionService();
        if (selectionSvc == null) {
            log.error("Failed to acquire selection service");
            return null;
        }
        ISelection selection = selectionSvc.getSelection();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        TreeSelection treeSelection = (TreeSelection)selection;
        TreePath[] paths = treeSelection.getPaths();
        if (paths == null) {
            return null;
        }
        IProject project = (IProject)paths[0].getFirstSegment();
        if (project == null || !project.isAccessible()) {
            log.error("Handler called on closed or non-existing project");
            return null;
        }
        WorkspaceService ws = ExtractUIPlugin.getWorkspaceService();
        CaseProject cp = ws.getCaseProjectByName(project.getName());
        if (cp == null) {
            log.error("Handler called on project which could not be found");
            return null;
        }
        cp.cleanAndBuild();
        return null;
    }
}

