/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.preferences;

import it.jrc.osint.extract.ui.ExtractUIPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class EntityExtractionPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor runVariantMatching;
    private BooleanFieldEditor runGeoCoding;
    private BooleanFieldEditor runExpressionTypes;
    private BooleanFieldEditor matchExpressionTypesHTML;
    private BooleanFieldEditor runEntityGuessing;
    private BooleanFieldEditor preloadExtractionTools;
    private ComboFieldEditor defaultGuessingLanguage;

    public EntityExtractionPreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "it.jrc.osint.extract"));
        this.setDescription("Enabled Extraction Steps");
    }

    protected void createFieldEditors() {
        this.runVariantMatching = new BooleanFieldEditor("runVariantMatching", "Match Name Variant Database", this.getFieldEditorParent());
        this.addField((FieldEditor)this.runVariantMatching);
        this.runGeoCoding = new BooleanFieldEditor("runGeoCoding", "Extract Geo Locations", this.getFieldEditorParent());
        this.addField((FieldEditor)this.runGeoCoding);
        this.runExpressionTypes = new BooleanFieldEditor("runExpressionTypes", "Extract Custom Entity Types (Regular Expression Types)", this.getFieldEditorParent());
        this.addField((FieldEditor)this.runExpressionTypes);
        this.runEntityGuessing = new BooleanFieldEditor("runEntityGuessing", "Perform Entity Guessing", this.getFieldEditorParent());
        this.addField((FieldEditor)this.runEntityGuessing);
        this.defaultGuessingLanguage = new ComboFieldEditor("entityGuessingDefaultLanguage", "Entity Guessing Default Language", this.getGuessingDefaultLanguageComboModel(), this.getFieldEditorParent());
        this.addField((FieldEditor)this.defaultGuessingLanguage);
        this.preloadExtractionTools = new BooleanFieldEditor("preloadExtractionTools", "Pre-load Extraction Tools", this.getFieldEditorParent());
        this.addField((FieldEditor)this.preloadExtractionTools);
        this.matchExpressionTypesHTML = new BooleanFieldEditor("matchExpressionTypesAgainstHTML", "Extract Custom Entity Types from HTML Source", this.getFieldEditorParent());
        this.addField((FieldEditor)this.matchExpressionTypesHTML);
    }

    private String[][] getGuessingDefaultLanguageComboModel() {
        ArrayList availableGuessingLanguages = new ArrayList(ExtractUIPlugin.getExtractionService().getGuessingLanguages());
        Collections.sort(availableGuessingLanguages);
        String[][] comboModel = new String[availableGuessingLanguages.size()][2];
        int i = 0;
        while (i < availableGuessingLanguages.size()) {
            comboModel[i][0] = new Locale((String)availableGuessingLanguages.get(i)).getDisplayName();
            comboModel[i][1] = (String)availableGuessingLanguages.get(i);
            ++i;
        }
        return comboModel;
    }

    public void init(IWorkbench workbench) {
    }
}

