/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.view;

import it.jrc.osint.extract.ui.ExtractUIPlugin;
import it.jrc.osint.extract.ui.view.TestRegexViewController;
import it.jrc.osint.extract.ui.view.TestRegexViewModel;
import it.jrc.osint.util.ui.PartListenerAdapter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class TestRegexView
extends ViewPart {
    public static final String ID = "it.jrc.osint.extract.ui.view.TestRegexView";
    private Button matchButton;
    private Button btnBricsRegexMode;
    private Button btnJavaRegexMode;
    private Text exprText;
    private Text inputText;
    private StyledText outputText;
    private TestRegexViewController controller = new TestRegexViewController(this);
    private IPartListener partListener;

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite inputComposite = new Composite(container, 0);
        inputComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        inputComposite.setBounds(0, 0, 64, 64);
        inputComposite.setLayout((Layout)new GridLayout(3, false));
        Label lblNewLabel = new Label(inputComposite, 0);
        lblNewLabel.setBounds(0, 0, 55, 15);
        lblNewLabel.setText("Regular Expression:");
        this.exprText = new Text(inputComposite, 2048);
        this.exprText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                if (me.getSource() == TestRegexView.this.exprText) {
                    TestRegexView.this.controller.expressionEdited(TestRegexView.this.exprText.getText());
                }
            }
        });
        this.exprText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.exprText.setBounds(0, 0, 76, 21);
        this.matchButton = new Button(inputComposite, 0);
        this.matchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TestRegexView.this.controller.matchExpression();
            }

            public void widgetSelected(SelectionEvent e) {
                TestRegexView.this.controller.matchExpression();
            }
        });
        this.matchButton.setText("Match");
        Group grpMode = new Group(inputComposite, 0);
        grpMode.setText("Expression Syntax");
        grpMode.setLayout((Layout)new GridLayout(2, false));
        this.btnBricsRegexMode = new Button((Composite)grpMode, 16);
        this.btnBricsRegexMode.setText("BRICS");
        this.btnJavaRegexMode = new Button((Composite)grpMode, 16);
        this.btnJavaRegexMode.setLayoutData((Object)new GridData(16384, 0x1000000, false, true, 1, 1));
        this.btnJavaRegexMode.setText("Java Regex");
        this.btnBricsRegexMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TestRegexView.this.btnBricsRegexMode.getSelection()) {
                    TestRegexView.this.btnBricsRegexMode.setSelection(true);
                    TestRegexView.this.btnJavaRegexMode.setSelection(false);
                    TestRegexView.this.controller.selectBricsRegexMode();
                }
            }
        });
        this.btnJavaRegexMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TestRegexView.this.btnJavaRegexMode.getSelection()) {
                    TestRegexView.this.btnJavaRegexMode.setSelection(true);
                    TestRegexView.this.btnBricsRegexMode.setSelection(false);
                    TestRegexView.this.controller.selectJavaRegexMode();
                }
            }
        });
        new Label(inputComposite, 0);
        new Label(inputComposite, 0);
        Label lblNewLabel_1 = new Label(inputComposite, 0);
        lblNewLabel_1.setSize(55, 15);
        lblNewLabel_1.setText("Text to match:");
        new Label(inputComposite, 0);
        new Label(inputComposite, 0);
        this.inputText = new Text(inputComposite, 18498);
        this.inputText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                if (me.getSource() == TestRegexView.this.inputText) {
                    TestRegexView.this.controller.inputTextEdited(TestRegexView.this.inputText.getText());
                }
            }
        });
        GridData gd_inputText = new GridData(4, 4, true, false, 3, 1);
        gd_inputText.heightHint = 200;
        this.inputText.setLayoutData((Object)gd_inputText);
        Composite resultComposite = new Composite(container, 0);
        resultComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        resultComposite.setBounds(0, 0, 64, 64);
        resultComposite.setLayout((Layout)new GridLayout(1, false));
        Label lblNewLabel_2 = new Label(resultComposite, 0);
        lblNewLabel_2.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblNewLabel_2.setText("Found Matches:");
        this.outputText = new StyledText(resultComposite, 2056);
        this.outputText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.outputText.setBounds(0, 0, 69, 19);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
        this.partListener = new PartListenerImpl();
        this.getSite().getPage().addPartListener(this.partListener);
    }

    void performRefresh() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestRegexView.this.inputText.setText(TestRegexView.this.controller.getInputText());
                TestRegexView.this.exprText.setText(TestRegexView.this.controller.getExpression());
                TestRegexViewModel.RegexMode regexMode = TestRegexView.this.controller.getRegexMode();
                if (regexMode.equals((Object)TestRegexViewModel.RegexMode.BRICS)) {
                    TestRegexView.this.btnBricsRegexMode.setSelection(true);
                    TestRegexView.this.btnJavaRegexMode.setSelection(false);
                } else {
                    TestRegexView.this.btnBricsRegexMode.setSelection(false);
                    TestRegexView.this.btnJavaRegexMode.setSelection(true);
                }
            }
        });
    }

    private void removeListeners() {
        if (this.partListener != null) {
            this.getSite().getPage().removePartListener(this.partListener);
        }
    }

    private void createActions() {
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.controller.init(memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.controller.saveState(memento);
    }

    private void initializeToolBar() {
    }

    private void initializeMenu() {
    }

    public void setFocus() {
    }

    void setOutputText(final String text) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestRegexView.this.outputText.setText(text);
            }
        });
    }

    void showErrorMessage(final String errorMessage) {
        this.clearOutput();
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestRegexView.this.outputText.setText(errorMessage);
                TestRegexView.this.outputText.setStyleRange(TestRegexView.this.getErrorStyleRange(errorMessage.length()));
            }
        });
    }

    void showMatchResult(final String matchResult) {
        this.clearOutput();
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestRegexView.this.outputText.setText(matchResult);
                TestRegexView.this.outputText.setStyleRange(TestRegexView.this.getOutputStyleRange(matchResult.length()));
            }
        });
    }

    void clearOutput() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestRegexView.this.outputText.setText("");
            }
        });
    }

    private StyleRange getErrorStyleRange(int messageLength) {
        Color[] colors = ExtractUIPlugin.getPlugin().getTextStyleRegistry().getColors("error");
        StyleRange sr = new StyleRange(0, messageLength, colors[0], colors[1]);
        return sr;
    }

    private StyleRange getOutputStyleRange(int messageLength) {
        Color[] colors = ExtractUIPlugin.getPlugin().getTextStyleRegistry().getColors("output");
        StyleRange sr = new StyleRange(0, messageLength, colors[0], colors[1]);
        return sr;
    }

    private class PartListenerImpl
    extends PartListenerAdapter {
        private PartListenerImpl() {
        }

        public void partOpened(IWorkbenchPart part) {
            super.partOpened(part);
            if (TestRegexView.this == part) {
                TestRegexView.this.controller.onPartOpened();
            }
        }

        public void partClosed(IWorkbenchPart part) {
            super.partClosed(part);
            if (TestRegexView.this == part) {
                TestRegexView.this.controller.onPartClosed();
                TestRegexView.this.removeListeners();
            }
        }
    }
}

