/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.ui.browser;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;

public class OpenBrowserHandler
extends AbstractHandler {
    private static final Logger log = LogManager.getLogger((String)OpenBrowserHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            URL url = null;
            String urlParam = event.getParameter("url");
            if (urlParam != null) {
                url = new URL(urlParam);
            }
            WebBrowserEditorInput input = new WebBrowserEditorInput(url, 6);
            page.openEditor((IEditorInput)input, "it.jrc.osint.ui.browser.editor");
            return null;
        }
        catch (PartInitException e) {
            log.error("Failed to open new browser editor", (Throwable)e);
            throw new ExecutionException("Failed to open new browser editor", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("Error occurred cannot open browser editor", t);
            throw new ExecutionException("Error occurred", t);
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

