/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.AbstractWebBrowser;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.DefaultBrowserSupport;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserUtil;

public class ExternalBrowserInstance
extends AbstractWebBrowser {
    protected IBrowserDescriptor browser;
    protected Process process;

    public ExternalBrowserInstance(String id, IBrowserDescriptor browser) {
        super(id);
        this.browser = browser;
    }

    public void openURL(URL url) throws PartInitException {
        String urlText = url.toExternalForm();
        ArrayList<String> cmdOptions = new ArrayList<String>();
        String location = this.browser.getLocation();
        cmdOptions.add(location);
        String parameters = this.browser.getParameters();
        Trace.trace(Trace.FINEST, "Launching external Web browser: " + location + " - " + parameters + " - " + urlText);
        String params = WebBrowserUtil.createParameterString(parameters, urlText);
        try {
            if (Util.isMac()) {
                cmdOptions.add(0, "-a");
                cmdOptions.add(0, "open");
            }
            if (params != null && params.length() != 0) {
                cmdOptions.add(params);
            }
            String[] cmd = cmdOptions.toArray(new String[cmdOptions.size()]);
            Trace.trace(Trace.FINEST, "Launching " + this.join(" ", cmd));
            this.process = Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not launch external browser", e);
            WebBrowserUtil.openError(NLS.bind((String)Messages.errorCouldNotLaunchWebBrowser, (Object)urlText));
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ExternalBrowserInstance.this.process.waitFor();
                    DefaultBrowserSupport.getInstance().removeBrowser((IWebBrowser)ExternalBrowserInstance.this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private String join(String delim, String ... data) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < data.length) {
            sb.append(data[i]);
            if (i >= data.length - 1) break;
            sb.append(delim);
            ++i;
        }
        return sb.toString();
    }

    public boolean close() {
        try {
            this.process.destroy();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

