/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser.browsers;

import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.AbstractWebBrowser;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.eclipse.ui.internal.browser.browsers.StreamConsumer;

public class DefaultBrowser
extends AbstractWebBrowser {
    protected String location;
    protected String parameters;

    public DefaultBrowser(String id, String location, String parameters) {
        super(id);
        this.location = location;
        this.parameters = parameters;
    }

    public void openURL(URL url2) throws PartInitException {
        String path = this.location;
        String url = url2.toExternalForm();
        String[] command = this.prepareCommand(path, url);
        if (command != null && command.length > 0) {
            Trace.trace(Trace.FINER, "Command: " + command[0]);
        }
        try {
            Process pr = Runtime.getRuntime().exec(command);
            StreamConsumer outConsumer = new StreamConsumer(pr.getInputStream());
            outConsumer.setName("Custom browser adapter output reader");
            outConsumer.start();
            StreamConsumer errConsumer = new StreamConsumer(pr.getErrorStream());
            errConsumer.setName("Custom browser adapter error reader");
            errConsumer.start();
        }
        catch (Exception e) {
            WebBrowserUIPlugin.logError("Launching URL \"" + url + "\" using browser program \"" + path + "\" has failed.  Specify another browser in help preferences.", e);
            throw new PartInitException(NLS.bind((String)Messages.errorCouldNotLaunchWebBrowser, (Object)path));
        }
    }

    protected String[] prepareCommand(String path, String url) {
        ArrayList<String> tokenList = new ArrayList<String>();
        StringTokenizer qTokenizer = new StringTokenizer(path.trim(), "\"", true);
        boolean withinQuotation = false;
        String quotedString = "";
        while (qTokenizer.hasMoreTokens()) {
            String curToken = qTokenizer.nextToken();
            if (curToken.equals("\"")) {
                if (withinQuotation) {
                    if ("win32".equalsIgnoreCase(Platform.getOS())) {
                        tokenList.add("\"" + quotedString + "\"");
                    } else {
                        tokenList.add(quotedString);
                    }
                } else {
                    quotedString = "";
                }
                withinQuotation = !withinQuotation;
                continue;
            }
            if (withinQuotation) {
                quotedString = curToken;
                continue;
            }
            StringTokenizer parser = new StringTokenizer(curToken.trim());
            while (parser.hasMoreTokens()) {
                tokenList.add(parser.nextToken());
            }
        }
        boolean substituted = false;
        int i = 0;
        while (i < tokenList.size()) {
            String token = (String)tokenList.get(i);
            String newToken = this.doSubstitutions(token, url);
            if (newToken != null) {
                tokenList.set(i, newToken);
                substituted = true;
            }
            ++i;
        }
        if (!substituted) {
            tokenList.add(url);
        }
        String[] command = new String[tokenList.size()];
        tokenList.toArray(command);
        return command;
    }

    protected String doSubstitutions(String token, String url) {
        boolean substituted = false;
        StringBuffer newToken = new StringBuffer(token);
        String substitutionMarker = "%1";
        int index = newToken.indexOf(substitutionMarker);
        while (index != -1) {
            newToken.replace(index, index + substitutionMarker.length(), url);
            index = newToken.indexOf(substitutionMarker, index + url.length());
            substituted = true;
        }
        if (substituted) {
            return newToken.toString();
        }
        return null;
    }
}

