/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2.participant;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.ide.refactoring.IResourceRelocationStrategy;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationChange;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationContext;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ui.refactoring2.ChangeConverter;
import org.eclipse.xtext.ui.refactoring2.LtkIssueAcceptor;
import org.eclipse.xtext.ui.refactoring2.ResourceURIConverter;
import org.eclipse.xtext.ui.refactoring2.participant.ResourceRelocationStrategyRegistry;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.LiveScopeResourceSetInitializer;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pure;

public class ResourceRelocationProcessor {
    private static final Logger LOG = Logger.getLogger(ResourceRelocationProcessor.class);
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private LiveScopeResourceSetInitializer liveScopeResourceSetInitializer;
    @Inject
    @Accessors(value={AccessorType.PACKAGE_GETTER})
    private LtkIssueAcceptor issues;
    @Inject
    @Extension
    private ResourceURIConverter _resourceURIConverter;
    @Inject
    private IChangeSerializer changeSerializer;
    @Inject
    private ResourceRelocationStrategyRegistry strategyRegistry;
    @Inject
    private ChangeConverter.Factory changeConverterFactory;
    private List<ResourceRelocationChange> uriChanges = CollectionLiterals.newArrayList();
    private Set<IResource> excludedResources = CollectionLiterals.newHashSet();
    private IProject project;

    public Change createChange(String name, ResourceRelocationContext.ChangeType type, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        boolean _isEmpty = this.uriChanges.isEmpty();
        if (_isEmpty) {
            return null;
        }
        ResourceSet resourceSet = this.resourceSetProvider.get(this.project);
        this.liveScopeResourceSetInitializer.initialize(resourceSet);
        ResourceRelocationContext context = new ResourceRelocationContext(type, this.uriChanges, (RefactoringIssueAcceptor)this.issues, this.changeSerializer, resourceSet);
        this.executeParticipants(context);
        Predicate _function = it -> !(it instanceof MoveResourceChange) && !(it instanceof RenameResourceChange) || !this.excludedResources.contains(it.getModifiedElement());
        ChangeConverter changeConverter = this.changeConverterFactory.create(name, (Predicate<Change>)_function, this.issues);
        this.changeSerializer.applyModifications((IAcceptor)changeConverter);
        return changeConverter.getChange();
    }

    protected void executeParticipants(ResourceRelocationContext context) {
        boolean _tripleEquals;
        List<? extends IResourceRelocationStrategy> strategies = this.strategyRegistry.getStrategies();
        ResourceRelocationContext.ChangeType _changeType = context.getChangeType();
        boolean bl = _tripleEquals = _changeType == ResourceRelocationContext.ChangeType.COPY;
        if (_tripleEquals) {
            IChangeSerializer _changeSerializer = context.getChangeSerializer();
            _changeSerializer.setUpdateRelatedFiles(false);
        }
        Consumer<IResourceRelocationStrategy> _function = it -> {
            try {
                it.applyChange(context);
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    Throwable t = _t;
                    this.issues.add(RefactoringIssueAcceptor.Severity.ERROR, "Error applying resource changes", t);
                    LOG.error((Object)t.getMessage(), t);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        };
        strategies.forEach(_function);
    }

    public void addChangedResource(IResource resource, IPath fromPath, IPath toPath) {
        try {
            boolean _isPrefixOf;
            if (this.project == null) {
                this.project = resource.getProject();
            }
            if (_isPrefixOf = fromPath.isPrefixOf(resource.getFullPath())) {
                URI oldURI = this._resourceURIConverter.toURI(resource);
                URI newURI = this._resourceURIConverter.toURI(toPath.append(resource.getFullPath().removeFirstSegments(fromPath.segmentCount())));
                this.excludedResources.add(resource);
                if (resource instanceof IFile) {
                    ResourceRelocationChange uriChange = new ResourceRelocationChange(oldURI, newURI, true);
                    this.uriChanges.add(uriChange);
                } else if (resource instanceof IContainer) {
                    ResourceRelocationChange uriChange_1 = new ResourceRelocationChange(oldURI, newURI, false);
                    this.uriChanges.add(uriChange_1);
                    Consumer<IResource> _function = member -> this.addChangedResource((IResource)member, fromPath, toPath);
                    ((List)Conversions.doWrapArray((Object)((IContainer)resource).members())).forEach(_function);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Pure
    LtkIssueAcceptor getIssues() {
        return this.issues;
    }
}

