/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.chromium;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.HttpCookie;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.annotations.Direct;
import jnr.ffi.annotations.Encoding;
import jnr.ffi.provider.jffi.NativeClosureManager;
import jnr.ffi.provider.jffi.NativeRuntime;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.chromium.Browser;
import org.eclipse.swt.chromium.BrowserFunction;
import org.eclipse.swt.chromium.OpenWindowListener;
import org.eclipse.swt.chromium.WebBrowser;
import org.eclipse.swt.chromium.WindowEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.chromium.CEF;
import org.eclipse.swt.internal.chromium.CEFFactory;
import org.eclipse.swt.internal.chromium.ResourceExpander;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;

class Chromium
extends WebBrowser {
    private static final String DATA_TEXT_URL = "data:text/html;base64,";
    private static final String VERSION = "0901";
    private static final String CEFVERSION = "3071";
    private static final String SHARED_LIB_V = "chromium_swt-0901";
    private static final int MAX_PROGRESS = 100;
    private static final int LOOP = 50;
    Browser chromium;
    OpenWindowListener[] openWindowListeners = new OpenWindowListener[0];
    private static Lib lib = Chromium.loadLib();
    private static String cefrustPath;
    private static AtomicInteger browsers;
    private static CompletableFuture<Boolean> cefInitilized;
    private static CEF.cef_app_t app;
    private static CEF.cef_browser_process_handler_t browserProcessHandler;
    private static boolean shuttindDown;
    private static CEF.cef_cookie_visitor_t cookieVisitor;
    private static CompletableFuture<Boolean> cookieVisited;
    private static int EVAL;
    private static int INSTANCES;
    private static Runnable loopWork;
    private static boolean loopDisable;
    private static boolean pumpDisable;
    private static int disposingAny;
    private long hwnd;
    private Pointer browser;
    private CEF.cef_client_t clientHandler;
    private CEF.cef_focus_handler_t focusHandler;
    private CEF.cef_life_span_handler_t lifeSpanHandler;
    private CEF.cef_load_handler_t loadHandler;
    private CEF.cef_display_handler_t displayHandler;
    private CEF.cef_request_handler_t requestHandler;
    private CEF.cef_jsdialog_handler_t jsDialogHandler;
    private CEF.cef_context_menu_handler_t contextMenuHandler;
    private CEF.cef_string_visitor_t textVisitor;
    private FocusListener focusListener;
    private String url;
    private String postData;
    private String[] headers;
    private String text = "";
    private CompletableFuture<String> textReady;
    private boolean canGoBack;
    private boolean canGoForward;
    private CompletableFuture<Boolean> enableProgress = new CompletableFuture();
    private CompletableFuture<Boolean> created = new CompletableFuture();
    private boolean disposing;
    private int instance;
    private boolean hasFocus;
    private boolean ignoreFirstFocus = true;
    private PaintListener paintListener;
    private WindowEvent isPopup;
    private List<Struct> popupHandlers = new ArrayList<Struct>();

    static {
        browsers = new AtomicInteger(0);
        EVAL = 1;
        INSTANCES = 0;
        disposingAny = 0;
    }

    public Chromium() {
        this.instance = ++INSTANCES;
    }

    @Override
    public void addOpenWindowListener(OpenWindowListener listener) {
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, this.openWindowListeners.length);
        this.openWindowListeners = newOpenWindowListeners;
        this.openWindowListeners[this.openWindowListeners.length - 1] = listener;
    }

    @Override
    public void removeOpenWindowListener(OpenWindowListener listener) {
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.openWindowListeners.length) {
            if (listener == this.openWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new OpenWindowListener[0];
            return;
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, index);
        System.arraycopy(this.openWindowListeners, index + 1, newOpenWindowListeners, index, this.openWindowListeners.length - index - 1);
        this.openWindowListeners = newOpenWindowListeners;
    }

    @Override
    public void setBrowser(Browser browser) {
        this.chromium = browser;
    }

    @Override
    public void createFunction(BrowserFunction function) {
        this.created.thenRun(() -> {
            this.checkBrowser();
            for (BrowserFunction current : this.functions.values()) {
                if (!current.name.equals(browserFunction.name)) continue;
                this.deregisterFunction(current);
                break;
            }
            browserFunction.index = this.getNextFunctionIndex();
            this.registerFunction(function);
            if (!lib.cefswt_function(this.browser, browserFunction.name, browserFunction.index)) {
                throw new SWTException("Cannot create BrowserFunction");
            }
        });
    }

    @Override
    public void destroyFunction(BrowserFunction function) {
        this.checkBrowser();
    }

    @Override
    public void create(Composite parent, int style) {
        this.initCEF(this.chromium.getDisplay());
        this.debugPrint("initCef Done");
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Chromium.this.debugPrint("paintControl");
                Chromium.this.chromium.removePaintListener(this);
                Chromium.this.createBrowser();
                Chromium.this.paintListener = null;
            }
        };
        this.chromium.addPaintListener(this.paintListener);
    }

    private Pointer debugPrint(String log) {
        System.out.println("J" + this.instance + ":" + Thread.currentThread().getName() + ":" + log + (this.url != null ? " (" + Chromium.getPlainUrl(this.url) + ")" : " empty-url"));
        return null;
    }

    private static Pointer debug(String log) {
        System.out.println("J:" + log);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCEF(Display display) {
        Lib lib = Chromium.lib;
        synchronized (lib) {
            if (app == null) {
                CEFFactory.create();
                app = CEFFactory.newApp();
                Chromium.browserProcessHandler = CEFFactory.newBrowserProcessHandler();
                cefInitilized = new CompletableFuture();
                Chromium.browserProcessHandler.on_context_initialized.set(browserProcessHandler -> {
                    this.debugPrint("OnContextInitialized");
                    cefInitilized.complete(true);
                });
                Runnable runnable = () -> {
                    if (lib == null || display.isDisposed()) {
                        return;
                    }
                    Chromium.safe_loop_work();
                };
                Chromium.browserProcessHandler.on_schedule_message_pump_work.set((pbrowserProcessHandler, delay) -> {
                    if (lib == null || display.isDisposed() || browsers.get() <= 0 || pumpDisable || disposingAny > 0) {
                        return;
                    }
                    Runnable scheduleWork = () -> {
                        this.restartLoop(display, delay);
                        display.timerExec(-1, runnable);
                        display.timerExec(delay, runnable);
                    };
                    if (Display.getCurrent() != null) {
                        if (delay <= 0) {
                            this.restartLoop(display, 0);
                            display.asyncExec(runnable);
                        } else {
                            scheduleWork.run();
                        }
                    } else if (delay <= 0) {
                        display.asyncExec(() -> {
                            this.restartLoop(display, 0);
                            runnable.run();
                        });
                    } else {
                        display.asyncExec(scheduleWork);
                    }
                });
                Chromium.app.get_browser_process_handler.set(appPtr -> browserProcessHandler);
                System.out.println("cefrust.path: " + cefrustPath);
                int debugPort = 0;
                try {
                    debugPort = Integer.parseInt(System.getProperty("org.eclipse.swt.chromium.remote-debugging-port", "0"));
                }
                catch (NumberFormatException e) {
                    debugPort = 0;
                }
                Chromium.lib.cefswt_init(app, cefrustPath, VERSION, debugPort);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public synchronized void start() {
                if (app == null || shuttindDown) {
                    return;
                }
                if (Display.getCurrent() != null) {
                    Chromium.internalShutdown();
                } else {
                    Display.getDefault().syncExec(() -> Chromium.internalShutdown());
                }
            }
        });
    }

    private static void safe_loop_work() {
        if (browsers.get() > 0 && !loopDisable) {
            if (lib.cefswt_do_message_loop_work() == 0) {
                System.err.println("error looping");
            }
            if (pumpDisable) {
                pumpDisable = false;
            }
        }
    }

    private void restartLoop(Display display, int ms) {
        if (loopWork != null) {
            display.timerExec(-1, loopWork);
            display.timerExec(50 + ms, loopWork);
        }
    }

    private long getHandle(Composite control) {
        long hwnd = 0L;
        String platform = SWT.getPlatform();
        if ("cocoa".equals(platform)) {
            try {
                Field field = Control.class.getDeclaredField("view");
                field.setAccessible(true);
                Object nsview = field.get(control);
                Class<?> idClass = Class.forName("org.eclipse.swt.internal.cocoa.id");
                Field idField = idClass.getField("id");
                hwnd = idField.getLong(nsview);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("win32".equals(platform)) {
            try {
                Field field = Control.class.getDeclaredField("handle");
                field.setAccessible(true);
                hwnd = (Long)field.get(control);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                Field field = Widget.class.getDeclaredField("handle");
                field.setAccessible(true);
                hwnd = (Long)field.get(control);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hwnd;
    }

    private void prepareBrowser() {
        this.hwnd = this.getHandle(this.chromium);
        this.chromium.addDisposeListener(e -> {
            this.debugPrint("disposing chromium");
            this.dispose();
        });
        this.focusListener = new CefFocusListener();
        this.chromium.addFocusListener(this.focusListener);
        this.set_text_visitor();
        this.clientHandler = CEFFactory.newClient();
        this.initializeClientHandler(this.clientHandler);
        this.set_focus_handler();
        this.set_life_span_handler();
        this.set_load_handler();
        this.set_display_handler();
        this.set_request_handler();
        this.set_jsdialog_handler();
        this.set_context_menu_handler();
        this.clientHandler.on_process_message_received.set((c, browser_1, source, processMessage) -> this.browserFunctionCalled(source, processMessage));
        this.chromium.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!Chromium.this.chromium.isDisposed() && Chromium.this.browser != null) {
                    Point size = Chromium.this.getChromiumSize();
                    lib.cefswt_resized(Chromium.this.browser, size.x, size.y);
                }
            }
        });
    }

    private void createBrowser() {
        if (this.url == null) {
            this.url = "about:blank";
        }
        this.prepareBrowser();
        Display display = this.chromium.getDisplay();
        Color bgColor = display.getSystemColor(22);
        int cefBgColor = this.cefColor(bgColor.getAlpha(), bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
        Point size = this.getChromiumSize();
        lib.cefswt_create_browser(this.hwnd, this.url, this.clientHandler, size.x, size.y, this.jsEnabledOnNextPage ? 1 : 0, cefBgColor);
    }

    private void createPopup(Pointer windowInfo, Pointer client, WindowEvent event) {
        if (this.paintListener != null) {
            this.chromium.removePaintListener(this.paintListener);
            this.paintListener = null;
        }
        this.isPopup = event;
        String platform = SWT.getPlatform();
        if ("gtk".equals(platform) && this.chromium.getDisplay().getActiveShell() != this.chromium.getShell()) {
            boolean visible = this.chromium.getShell().isVisible();
            this.chromium.getShell().open();
            this.chromium.getShell().setVisible(visible);
        }
        this.prepareBrowser();
        long popupHandle = this.hwnd;
        this.debugPrint("popup will use hwnd:" + popupHandle);
        Point size = this.chromium.getParent().getSize();
        size = DPIUtil.autoScaleUp((Point)size);
        lib.cefswt_set_window_info_parent(windowInfo, client, this.clientHandler, popupHandle, 0, 0, size.x, size.y);
        this.debugPrint("reparent popup");
    }

    private void createDefaultPopup(Pointer windowInfo, Pointer client, WindowEvent event) {
        CEF.cef_client_t nullHandler = CEFFactory.newClient();
        this.initializeClientHandler(nullHandler);
        CEF.cef_life_span_handler_t popupHandler = CEFFactory.newLifeSpanHandler();
        popupHandler.on_after_created.set((self, browser) -> {
            Chromium.debug("popup on_after_created");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        popupHandler.on_before_close.set((plifeSpanHandler, browser) -> {
            Chromium.debug("popup OnBeforeClose");
            this.popupHandlers.remove((Object)nullHandler);
            this.popupHandlers.remove((Object)popupHandler);
            --disposingAny;
        });
        popupHandler.do_close.set((plifeSpanHandler, browser) -> {
            Chromium.debug("popup DoClose");
            ++disposingAny;
            return 0;
        });
        nullHandler.get_life_span_handler.set(self -> popupHandler);
        this.popupHandlers.add(popupHandler);
        this.popupHandlers.add(nullHandler);
        lib.cefswt_set_window_info_parent(windowInfo, client, nullHandler, 0L, event.location.x, event.location.y, event.size.x, event.size.y);
        this.debugPrint("default popup");
    }

    private int cefColor(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b << 0;
    }

    private Point getChromiumSize() {
        Point size = this.chromium.getSize();
        return DPIUtil.autoScaleUp((Point)size);
    }

    private void set_life_span_handler() {
        this.lifeSpanHandler = CEFFactory.newLifeSpanHandler();
        this.lifeSpanHandler.on_before_close.set((plifeSpanHandler, browser) -> {
            this.debugPrint("OnBeforeClose");
            lib.cefswt_free(browser);
            this.browser = null;
            this.clientHandler = null;
            this.focusHandler = null;
            this.lifeSpanHandler = null;
            this.loadHandler = null;
            this.displayHandler = null;
            this.requestHandler = null;
            this.jsDialogHandler = null;
            this.contextMenuHandler = null;
            --disposingAny;
            if (browsers.decrementAndGet() == 0 && shuttindDown) {
                Chromium.internalShutdown();
            }
        });
        this.lifeSpanHandler.do_close.set((plifeSpanHandler, browser) -> {
            if (!lib.cefswt_is_same(this.browser, browser)) {
                this.debugPrint("DoClose popup:" + this.browser + ":" + browser);
                return 0;
            }
            this.debugPrint("DoClose");
            if (!this.disposing && !this.chromium.isDisposed() && this.closeWindowListeners != null) {
                org.eclipse.swt.browser.WindowEvent event = new org.eclipse.swt.browser.WindowEvent((Widget)this.chromium);
                event.display = this.chromium.getDisplay();
                event.widget = this.chromium;
                CloseWindowListener[] closeWindowListenerArray = this.closeWindowListeners;
                int n = this.closeWindowListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    CloseWindowListener listener = closeWindowListenerArray[n2];
                    listener.close(event);
                    ++n2;
                }
            }
            if (!this.disposing) {
                this.chromium.dispose();
            }
            if ("gtk".equals(SWT.getPlatform())) {
                this.waitForClose(this.chromium.getDisplay());
            }
            return 1;
        });
        this.lifeSpanHandler.on_after_created.set((self, browser) -> {
            if (this.chromium.isDisposed() || this.visibilityWindowListeners == null) {
                return;
            }
            this.debugPrint("on_after_created " + browser);
            if (browser != null) {
                this.browser = browser;
                browsers.incrementAndGet();
                if (this.isPopup == null) {
                    Point size = this.getChromiumSize();
                    lib.cefswt_resized(browser, size.x, size.y);
                }
                if (this.isPopup != null && this.url != null) {
                    this.debugPrint("load url after created");
                    this.doSetUrlPost(browser, this.url, this.postData, this.headers);
                } else if (!"about:blank".equals(this.url)) {
                    this.enableProgress.complete(true);
                }
            }
            this.created.complete(true);
            if (browsers.get() == 1) {
                this.debugPrint("STARTING MSG LOOP");
                Display display = this.chromium.getDisplay();
                Chromium.doMessageLoop(display);
            }
            this.debugPrint("on_after_created handling " + browser);
            if (this.chromium == null || this.chromium.isDisposed() || this.visibilityWindowListeners == null) {
                return;
            }
            org.eclipse.swt.browser.WindowEvent event = new org.eclipse.swt.browser.WindowEvent((Widget)this.chromium);
            event.display = this.chromium.getDisplay();
            event.widget = this.chromium;
            event.size = new Point(0, 0);
            event.location = new Point(0, 0);
            if (this.isPopup != null) {
                event.size = this.isPopup.size;
                event.location = this.isPopup.location;
                event.addressBar = this.isPopup.addressBar;
                event.menuBar = this.isPopup.menuBar;
                event.statusBar = this.isPopup.statusBar;
                event.toolBar = this.isPopup.toolBar;
                if (event.size != null && !event.size.equals((Object)new Point(0, 0))) {
                    Point size = event.size;
                    this.chromium.getShell().setSize(this.chromium.getShell().computeSize(size.x, size.y));
                }
                VisibilityWindowListener[] visibilityWindowListenerArray = this.visibilityWindowListeners;
                int n = this.visibilityWindowListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    VisibilityWindowListener listener = visibilityWindowListenerArray[n2];
                    listener.show(event);
                    ++n2;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.lifeSpanHandler.on_before_popup.set((self, browser, frame, target_url, target_frame_name, target_disposition, user_gesture, popupFeatures, windowInfo, client, settings, no_javascript_access) -> {
            this.debugPrint("on_before_popup " + browser);
            if (this.chromium.isDisposed()) {
                return 1;
            }
            if (this.openWindowListeners == null) {
                return 0;
            }
            loopDisable = true;
            pumpDisable = true;
            WindowEvent event = new WindowEvent((Widget)this.chromium);
            this.chromium.getDisplay().syncExec(() -> {
                this.debugPrint("on_before_popup syncExec" + browser);
                windowEvent.display = this.chromium.getDisplay();
                windowEvent.widget = this.chromium;
                windowEvent.required = false;
                windowEvent.addressBar = cef_popup_features_t2.locationBarVisible.get() == 1;
                windowEvent.menuBar = cef_popup_features_t2.menuBarVisible.get() == 1;
                windowEvent.statusBar = cef_popup_features_t2.statusBarVisible.get() == 1;
                windowEvent.toolBar = cef_popup_features_t2.toolBarVisible.get() == 1;
                int x = cef_popup_features_t2.xSet.get() == 1 ? cef_popup_features_t2.x.get() : 0;
                int y = cef_popup_features_t2.ySet.get() == 1 ? cef_popup_features_t2.y.get() : 0;
                windowEvent.location = new Point(x, y);
                int width = cef_popup_features_t2.widthSet.get() == 1 ? cef_popup_features_t2.width.get() : 0;
                int height = cef_popup_features_t2.heightSet.get() == 1 ? cef_popup_features_t2.height.get() : 0;
                windowEvent.size = new Point(width, height);
                OpenWindowListener[] openWindowListenerArray = this.openWindowListeners;
                int n = this.openWindowListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    OpenWindowListener listener = openWindowListenerArray[n2];
                    listener.open(event);
                    ++n2;
                }
                if (windowEvent.browser != null) {
                    windowEvent.browser.webBrowser.createPopup(windowInfo, client, event);
                } else {
                    this.createDefaultPopup(windowInfo, client, event);
                }
            });
            loopDisable = false;
            if (event.browser == null && event.required) {
                return 1;
            }
            return 0;
        });
        this.clientHandler.get_life_span_handler.set(client -> this.lifeSpanHandler);
    }

    private void waitForClose(Display display) {
        display.asyncExec(() -> {
            if (this.browser != null) {
                this.waitForClose(display);
            }
        });
    }

    private void set_load_handler() {
        this.loadHandler = CEFFactory.newLoadHandler();
        this.loadHandler.on_loading_state_change.set((self_, browser, isLoading, canGoBack, canGoForward) -> {
            this.debugPrint("on_loading_state_change " + isLoading);
            this.canGoBack = canGoBack == 1;
            boolean bl = this.canGoForward = canGoForward == 1;
            if (this.chromium.isDisposed() || this.progressListeners == null) {
                return;
            }
            this.updateText();
            if (this.isPopup != null) {
                this.textReady.thenRun(() -> {
                    boolean bl = this.enableProgress.complete(true);
                });
            } else {
                if (!this.enableProgress.isDone() && isLoading == 0) {
                    this.textReady.thenRun(() -> this.enableProgress.complete(true));
                    return;
                }
                if (!this.enableProgress.isDone()) {
                    return;
                }
            }
            ProgressEvent event = new ProgressEvent((Widget)this.chromium);
            event.display = this.chromium.getDisplay();
            event.widget = this.chromium;
            event.current = 100;
            event.current = isLoading == 1 ? 1 : 100;
            event.total = 100;
            if (isLoading == 1) {
                this.debugPrint("progress changed");
                ProgressListener[] progressListenerArray = this.progressListeners;
                int n = this.progressListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ProgressListener listener = progressListenerArray[n2];
                    listener.changed(event);
                    ++n2;
                }
            } else {
                this.textReady.thenRun(() -> {
                    this.debugPrint("progress completed");
                    this.chromium.getDisplay().asyncExec(() -> {
                        ProgressListener[] progressListenerArray = this.progressListeners;
                        int n = this.progressListeners.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ProgressListener listener = progressListenerArray[n2];
                            listener.completed(event);
                            ++n2;
                        }
                    });
                });
            }
        });
        this.loadHandler.on_load_end.set((self, browser, frame, http_status) -> {});
        this.clientHandler.get_load_handler.set(client -> this.loadHandler);
    }

    private void set_display_handler() {
        this.displayHandler = CEFFactory.newDisplayHandler();
        this.displayHandler.on_title_change.set((self, browser, title) -> {
            if (this.chromium.isDisposed() || this.titleListeners == null) {
                return;
            }
            String str = Chromium.getPlainUrl(lib.cefswt_cefstring_to_java(title));
            this.debugPrint("on_title_change: " + str);
            TitleEvent event = new TitleEvent((Widget)this.chromium);
            event.display = this.chromium.getDisplay();
            event.widget = this.chromium;
            event.title = str;
            TitleListener[] titleListenerArray = this.titleListeners;
            int n = this.titleListeners.length;
            int n2 = 0;
            while (n2 < n) {
                TitleListener listener = titleListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
        });
        this.displayHandler.on_address_change.set((self, browser, frame, url) -> {
            if (this.chromium.isDisposed() || this.locationListeners == null) {
                return;
            }
            LocationEvent event = new LocationEvent((Widget)this.chromium);
            event.display = this.chromium.getDisplay();
            event.widget = this.chromium;
            event.doit = true;
            event.location = Chromium.getPlainUrl(lib.cefswt_cefstring_to_java(url));
            event.top = lib.cefswt_is_main_frame(frame);
            if (!this.enableProgress.isDone()) {
                this.debugPrint("!on_address_change to " + event.location + " " + (event.top ? "main" : "!main"));
                return;
            }
            this.debugPrint("on_address_change to " + event.location + " " + (event.top ? "main" : "!main"));
            this.chromium.getDisplay().asyncExec(() -> {
                LocationListener[] locationListenerArray = this.locationListeners;
                int n = this.locationListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    LocationListener listener = locationListenerArray[n2];
                    listener.changed(event);
                    ++n2;
                }
            });
        });
        this.displayHandler.on_status_message.set((self, browser, status) -> {
            if (this.chromium.isDisposed() || this.statusTextListeners == null) {
                return;
            }
            String str = lib.cefswt_cefstring_to_java(status);
            StatusTextEvent event = new StatusTextEvent((Widget)this.chromium);
            event.display = this.chromium.getDisplay();
            event.widget = this.chromium;
            event.text = str;
            StatusTextListener[] statusTextListenerArray = this.statusTextListeners;
            int n = this.statusTextListeners.length;
            int n2 = 0;
            while (n2 < n) {
                StatusTextListener listener = statusTextListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
        });
        this.clientHandler.get_display_handler.set(client -> this.displayHandler);
    }

    private void set_request_handler() {
        this.requestHandler = CEFFactory.newRequestHandler();
        this.requestHandler.on_before_browse.set((self, browser, frame, request, is_redirect) -> {
            if (this.chromium.isDisposed() || this.locationListeners == null) {
                return 0;
            }
            if (lib.cefswt_is_main_frame(frame)) {
                LocationEvent event = new LocationEvent((Widget)this.chromium);
                event.display = this.chromium.getDisplay();
                event.widget = this.chromium;
                event.doit = true;
                event.location = lib.cefswt_request_to_java(request);
                this.debugPrint("on_before_browse:" + event.location);
                try {
                    loopDisable = true;
                    LocationListener[] locationListenerArray = this.locationListeners;
                    int n = this.locationListeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LocationListener listener = locationListenerArray[n2];
                        listener.changing(event);
                        ++n2;
                    }
                }
                finally {
                    loopDisable = false;
                }
                if (!event.doit) {
                    this.debugPrint("canceled nav, dependats:" + this.enableProgress.getNumberOfDependents());
                    this.enableProgress = new CompletableFuture();
                }
                return event.doit ? 0 : 1;
            }
            return 0;
        });
        this.clientHandler.get_request_handler.set(client -> this.requestHandler);
    }

    private void set_jsdialog_handler() {
        if (!"gtk".equals(SWT.getPlatform())) {
            return;
        }
        this.jsDialogHandler = CEFFactory.newJsDialogHandler();
        this.jsDialogHandler.on_jsdialog.set((self_, browser, origin_url, dialog_type, message_text, default_prompt_text, callback, suppress_message) -> {
            if (this.chromium.isDisposed()) {
                return 0;
            }
            int style = 16;
            switch (dialog_type) {
                case JSDIALOGTYPE_ALERT: {
                    style = 2;
                    break;
                }
                case JSDIALOGTYPE_CONFIRM: {
                    style = 8;
                    break;
                }
                case JSDIALOGTYPE_PROMPT: {
                    style = 196;
                }
            }
            String url = lib.cefswt_cefstring_to_java(origin_url);
            String msg = lib.cefswt_cefstring_to_java(message_text);
            String prompt = lib.cefswt_cefstring_to_java(default_prompt_text);
            MessageBox box = new MessageBox(this.chromium.getShell(), style);
            box.setText(Chromium.getPlainUrl(url));
            if (prompt != null) {
                box.setMessage(msg);
            } else {
                box.setMessage(msg);
            }
            int open = box.open();
            lib.cefswt_dialog_close(callback, open == 32 || open == 64 ? 1 : 0, default_prompt_text);
            this.chromium.getShell().forceActive();
            return 1;
        });
        this.clientHandler.get_jsdialog_handler.set(client -> this.jsDialogHandler);
    }

    private void set_context_menu_handler() {
        this.contextMenuHandler = CEFFactory.newContextMenuHandler();
        this.contextMenuHandler.on_before_context_menu.set((self, browser, frame, params, model) -> this.debugPrint("on_before_context_menu"));
        this.contextMenuHandler.run_context_menu.set((self, browser, frame, params, model, callback) -> {
            this.debugPrint("run_context_menu");
            if (this.chromium.getMenu() != null) {
                this.chromium.getMenu().setVisible(true);
                lib.cefswt_context_menu_cancel(callback);
                return 1;
            }
            return 0;
        });
        this.clientHandler.get_context_menu_handler.set(client -> this.contextMenuHandler);
    }

    private void set_text_visitor() {
        this.textVisitor = CEFFactory.newStringVisitor();
        this.textVisitor.visit.set((self, cefString) -> {
            String newtext;
            String string = newtext = cefString != null ? lib.cefswt_cefstring_to_java(cefString) : null;
            if (newtext != null) {
                this.text = newtext;
                this.debugPrint("text visited completed");
                this.textReady.complete(this.text);
            } else {
                this.debugPrint("text visited null");
            }
        });
    }

    private void set_focus_handler() {
        this.focusHandler = CEFFactory.newFocusHandler();
        this.focusHandler.on_got_focus.set((focusHandler, browser_1) -> {
            this.debugPrint("CALLBACK OnGotFocus");
            this.hasFocus = true;
            if (this.chromium.getDisplay().getFocusControl() != null) {
                this.chromium.setFocus();
            }
            this.browserFocus(true);
        });
        this.focusHandler.on_set_focus.set((focusHandler, browser_1, focusSource) -> {
            this.debugPrint("CALLBACK OnSetFocus " + (Object)((Object)focusSource));
            if (this.ignoreFirstFocus) {
                this.ignoreFirstFocus = false;
                return 1;
            }
            return 0;
        });
        this.focusHandler.on_take_focus.set((focusHandler, browser_1, next) -> {
            int indexOf;
            this.debugPrint("CALLBACK OnTakeFocus " + next);
            this.hasFocus = false;
            Control[] tabOrder = this.chromium.getParent().getTabList();
            if (tabOrder.length == 0) {
                tabOrder = this.chromium.getParent().getChildren();
            }
            if ((indexOf = Arrays.asList(tabOrder).indexOf((Object)this.chromium)) != -1) {
                int newIndex;
                int n = newIndex = next == 1 ? indexOf + 1 : indexOf - 1;
                if (newIndex > 0 && newIndex < tabOrder.length && !tabOrder[newIndex].isDisposed()) {
                    tabOrder[newIndex].setFocus();
                    return;
                }
            }
            if (!this.chromium.getParent().isDisposed()) {
                this.chromium.getParent().setFocus();
            }
        });
        this.clientHandler.get_focus_handler.set(client -> this.focusHandler);
    }

    @Override
    public boolean isFocusControl() {
        return this.hasFocus;
    }

    private static void doMessageLoop(final Display display) {
        loopWork = new Runnable(){

            @Override
            public void run() {
                if (lib != null && !display.isDisposed()) {
                    Chromium.safe_loop_work();
                    display.timerExec(50, loopWork);
                } else {
                    Chromium.debug("STOPPING MSG LOOP");
                }
            }
        };
        display.timerExec(50, loopWork);
    }

    private synchronized void checkBrowser() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.browser == null) {
            SWT.error((int)24);
        }
    }

    protected void initializeClientHandler(CEF.cef_client_t client) {
        client.get_context_menu_handler.set(c -> null);
        client.get_dialog_handler.set(c -> Chromium.debug("get_dialog_handler"));
        client.get_download_handler.set(c -> Chromium.debug("get_download_handler"));
        client.get_drag_handler.set(c -> Chromium.debug("get_drag_handler"));
        client.get_geolocation_handler.set(c -> Chromium.debug("get_geolocation_handler"));
        client.get_jsdialog_handler.set(c -> null);
        client.get_keyboard_handler.set(c -> null);
        client.get_render_handler.set(c -> null);
        client.on_process_message_received.set((c, browser_1, source, processMessage) -> {
            Chromium.debug("on_process_message_received");
            return 0;
        });
        client.get_find_handler.set(c -> Chromium.debug("get_find_handler"));
    }

    private int browserFunctionCalled(CEF.cef_process_id_t source, Pointer processMessage) {
        if (source != CEF.cef_process_id_t.PID_RENDERER || !this.jsEnabled || this.disposing || this.chromium == null || this.chromium.isDisposed()) {
            return 0;
        }
        CEFFactory.FunctionSt fn = lib.cefswt_function_id(processMessage);
        int id = fn.id.get();
        if (id < 0) {
            return 0;
        }
        int argsSize = fn.args.intValue();
        Object[] args = new Object[argsSize];
        int i = 0;
        while (i < argsSize) {
            int arg = i;
            CEFFactory.EvalReturned callback = (loop, type, value) -> {
                if (loop == 1) {
                    System.out.println("DISPATCH");
                    this.chromium.getDisplay().readAndDispatch();
                } else {
                    objectArray[n] = this.mapType(type, value);
                }
            };
            lib.cefswt_function_arg(processMessage, i, callback);
            ++i;
        }
        Object ret = ((BrowserFunction)this.functions.get(id)).function(args);
        Object[] returnPair = this.convertType(ret);
        CEFFactory.ReturnType returnType = (CEFFactory.ReturnType)((Object)returnPair[0]);
        String returnStr = (String)returnPair[1];
        lib.cefswt_function_return(this.browser, id, fn.port.get(), returnType, returnStr);
        return 1;
    }

    private Object[] convertType(Object ret) {
        CEFFactory.ReturnType returnType = CEFFactory.ReturnType.Error;
        String returnStr = "";
        if (ret == null) {
            returnType = CEFFactory.ReturnType.Null;
            returnStr = "null";
        } else if (Boolean.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Bool;
            returnStr = Boolean.TRUE.equals(ret) ? "1" : "0";
        } else if (Number.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Double;
            returnStr = NumberFormat.getInstance(Locale.US).format(ret);
        } else if (String.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Str;
            returnStr = ret.toString();
        } else if (ret.getClass().isArray()) {
            returnType = CEFFactory.ReturnType.Array;
            StringBuilder buffer = new StringBuilder();
            buffer.append("\"");
            int i = 0;
            while (i < Array.getLength(ret)) {
                if (i > 0) {
                    buffer.append(";");
                }
                Object[] arrayElem = this.convertType(Array.get(ret, i));
                buffer.append("'");
                buffer.append(((CEFFactory.ReturnType)((Object)arrayElem[0])).intValue());
                buffer.append(",");
                buffer.append((String)arrayElem[1]);
                buffer.append("'");
                ++i;
            }
            buffer.append("\"");
            returnStr = buffer.toString();
        } else {
            returnStr = "Unsupported return type " + ret.getClass().getName();
        }
        return new Object[]{returnType, returnStr};
    }

    protected void browserFocus(boolean set) {
        if (!this.chromium.isDisposed() && this.browser != null) {
            long parent;
            long l = parent = Display.getDefault().getActiveShell() == null ? 0L : this.getHandle(this.chromium.getParent());
            if (this.chromium.getDisplay().getActiveShell() != this.chromium.getShell()) {
                return;
            }
            lib.cefswt_set_focus(this.browser, set, parent);
        }
    }

    public void dispose() {
        if (this.disposing || this.chromium.isDisposed()) {
            return;
        }
        this.disposing = true;
        ++disposingAny;
        if (this.focusListener != null) {
            this.chromium.removeFocusListener(this.focusListener);
        }
        this.focusListener = null;
        if (this.browser != null) {
            this.debugPrint("call close_browser");
            lib.cefswt_close_browser(this.browser);
        }
        this.chromium = null;
    }

    public static void shutdown() {
        String platform = SWT.getPlatform();
        if ("cocoa".equals(platform)) {
            return;
        }
        Chromium.debug("Shutdown from API");
        Chromium.internalShutdown();
    }

    private static synchronized void internalShutdown() {
        if (lib == null || app == null) {
            return;
        }
        if (browsers.get() == 0) {
            app = null;
            Chromium.debug("shutting down CEF on exit from thread " + Thread.currentThread().getName());
            lib.cefswt_shutdown();
            Chromium.debug("after shutting down CEF");
        } else if (!shuttindDown) {
            shuttindDown = true;
            Chromium.debug("delaying shutdown due browsers not disposed yet");
        }
    }

    private static Lib loadLib() {
        String gtk;
        Chromium.fixJNRClosureClassLoader();
        String platform = SWT.getPlatform();
        if ("gtk".equals(platform) && (gtk = System.getProperty("org.eclipse.swt.internal.gtk.version", "")).startsWith("2")) {
            throw new SWTException(47, "Chromium Browser is no longer supported in GTK2. ");
        }
        String subDir = "chromium-3071";
        File cefrustlib = null;
        try {
            String mapLibraryName = System.mapLibraryName(SHARED_LIB_V);
            Enumeration<URL> fragments = Library.class.getClassLoader().getResources(String.valueOf(subDir) + "/chromium.properties");
            while (fragments.hasMoreElements()) {
                URL url = fragments.nextElement();
                Throwable throwable = null;
                Object var7_13 = null;
                try (InputStream is = url.openStream();){
                    Properties props = new Properties();
                    props.load(is);
                    for (String prop : props.stringPropertyNames()) {
                        String propValue;
                        Path path;
                        String fileName;
                        if ("cefVersion".equals(prop) || mapLibraryName.equals(fileName = (path = Paths.get(propValue = props.getProperty(prop), new String[0])).getFileName().toString())) continue;
                        ResourceExpander.findResource(path.getParent().toString(), fileName, false);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            cefrustlib = ResourceExpander.findResource(subDir, mapLibraryName, false);
            cefrustPath = cefrustlib.getParentFile().getCanonicalPath();
            LibraryLoader loader = LibraryLoader.create(Lib.class);
            Lib libc = (Lib)loader.failImmediately().search(cefrustPath).load(SHARED_LIB_V);
            Chromium.setupCookies();
            return libc;
        }
        catch (UnsatisfiedLinkError e) {
            String cefLib = System.mapLibraryName("cef");
            if ("cocoa".equals(platform)) {
                cefLib = "Chromium Embedded Framework.framework";
            } else if ("win32".equals(platform)) {
                cefLib = "libcef.dll";
            }
            if (cefrustlib != null && !new File(cefrustlib.getParentFile(), cefLib).exists()) {
                SWTException swtError = new SWTException(47, "Missing CEF binaries for Chromium Browser. Extract CEF binaries to " + cefrustPath);
                swtError.throwable = e;
                throw swtError;
            }
            throw e;
        }
        catch (IOException e) {
            SWTException swtError = new SWTException(47, "");
            swtError.throwable = e;
            throw swtError;
        }
    }

    private static void setupCookies() {
        WebBrowser.NativeClearSessions = () -> lib.cefswt_delete_cookies();
        WebBrowser.NativeSetCookie = () -> {
            List<HttpCookie> cookies = HttpCookie.parse(WebBrowser.CookieValue);
            Iterator<HttpCookie> iterator = cookies.iterator();
            if (iterator.hasNext()) {
                HttpCookie cookie = iterator.next();
                long age = cookie.getMaxAge();
                if (age != -1L) {
                    age = Instant.now().plusSeconds(age).getEpochSecond();
                }
                WebBrowser.CookieResult = lib.cefswt_set_cookie(WebBrowser.CookieUrl, cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getSecure() ? 1 : 0, cookie.isHttpOnly() ? 1 : 0, age);
            }
        };
        WebBrowser.NativeGetCookie = () -> {
            if (cookieVisitor == null) {
                Chromium.setCookieVisitor();
            }
            cookieVisited = new CompletableFuture();
            boolean result = lib.cefswt_get_cookie(WebBrowser.CookieUrl, cookieVisitor);
            if (!result) {
                cookieVisited = null;
                throw new SWTException("Failed to get cookies");
            }
            try {
                try {
                    cookieVisited.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException exception) {
                    cookieVisited = null;
                }
            }
            finally {
                cookieVisited = null;
            }
        };
    }

    private static void setCookieVisitor() {
        cookieVisitor = CEFFactory.newCookieVisitor();
        Chromium.cookieVisitor.visit.set((self, cefcookie, count, total, delete) -> {
            String name = lib.cefswt_cefstring_to_java(cefcookie.name);
            Chromium.debug("Visitor " + count + "/" + total + ": " + name + ":" + Thread.currentThread());
            if (WebBrowser.CookieName != null && WebBrowser.CookieName.equals(name)) {
                String value;
                WebBrowser.CookieValue = value = lib.cefswt_cookie_value(cefcookie);
                cookieVisited.complete(true);
                return 0;
            }
            return 1;
        });
    }

    private static void fixJNRClosureClassLoader() {
        try {
            NativeClosureManager closureManager = NativeRuntime.getInstance().getClosureManager();
            Field classLoader = Chromium.findField(closureManager.getClass(), "classLoader");
            classLoader.setAccessible(true);
            Object asmClassLoader = classLoader.get(closureManager);
            Field parent = Chromium.findField(ClassLoader.class, "parent");
            parent.setAccessible(true);
            parent.set(asmClassLoader, Chromium.class.getClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Field findField(Class<?> class1, String name) throws Exception {
        return class1.getDeclaredField(name);
    }

    @Override
    public boolean back() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.canGoBack) {
            lib.cefswt_go_back(this.browser);
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(String script) {
        if (!this.jsEnabled) {
            return false;
        }
        this.enableProgress.thenRun(() -> lib.cefswt_execute(this.browser, script));
        return true;
    }

    @Override
    public Object evaluate(String script) throws SWTException {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (!this.jsEnabled) {
            return null;
        }
        if (this.browser == null && this.paintListener != null) {
            this.chromium.removePaintListener(this.paintListener);
            this.paintListener = null;
            this.createBrowser();
        }
        Object[] ret = new Object[1];
        CEFFactory.EvalReturned callback = (loop, type, value) -> {
            if (loop == 1) {
                if (!loopDisable || !"cocoa".equals(SWT.getPlatform()) && !"gtk".equals(SWT.getPlatform())) {
                    this.chromium.getDisplay().readAndDispatch();
                }
            } else {
                objectArray[0] = this.mapType(type, value);
            }
        };
        StringBuilder buffer = new StringBuilder("(function() {");
        buffer.append("\n");
        buffer.append(script);
        buffer.append("\n})()");
        this.checkBrowser();
        boolean returnSt = lib.cefswt_eval(this.browser, buffer.toString(), EVAL++, callback);
        if (!returnSt) {
            throw new SWTException("Script that was evaluated failed");
        }
        return ret[0];
    }

    private Object mapType(CEFFactory.ReturnType type, String value) throws SWTException {
        if (type == CEFFactory.ReturnType.Error) {
            if ("51".equals(value)) {
                throw new SWTException(51);
            }
            throw new SWTException(50, value);
        }
        if (type == CEFFactory.ReturnType.Null) {
            return null;
        }
        if (type == CEFFactory.ReturnType.Bool) {
            return "1".equals(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (type == CEFFactory.ReturnType.Double) {
            return Double.parseDouble(value);
        }
        if (type == CEFFactory.ReturnType.Array) {
            String value_unquoted = value.substring(1, value.length() - 1);
            String[] elements = value_unquoted.split(";(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
            Object[] array = new Object[elements.length];
            int i = 0;
            while (i < array.length) {
                Object elemValue;
                String elemUnquoted = elements[i].substring(1, elements[i].length() - 1);
                String[] parts = elemUnquoted.split(",(?=(?:[^']*'[^']*')*[^']*$)", 2);
                CEFFactory.ReturnType elemType = CEFFactory.ReturnType.from(parts[0]);
                array[i] = elemValue = this.mapType(elemType, parts[1]);
                ++i;
            }
            return array;
        }
        return value;
    }

    @Override
    public boolean forward() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.canGoForward) {
            lib.cefswt_go_forward(this.browser);
            return true;
        }
        return false;
    }

    @Override
    public String getBrowserType() {
        return "chromium";
    }

    @Override
    public String getText() {
        this.checkBrowser();
        return this.text;
    }

    private void updateText() {
        if (this.browser != null && this.textVisitor != null) {
            this.debugPrint("update text");
            this.textReady = new CompletableFuture();
            lib.cefswt_get_text(this.browser, this.textVisitor);
        }
    }

    @Override
    public String getUrl() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.browser == null) {
            if (this.url == null) {
                return "about:blank";
            }
            return Chromium.getPlainUrl(this.url);
        }
        String cefurl = lib.cefswt_get_url(this.browser);
        if (cefurl == null) {
            cefurl = Chromium.getPlainUrl(this.url);
        }
        return cefurl;
    }

    @Override
    public boolean isBackEnabled() {
        return this.canGoBack;
    }

    @Override
    public boolean isForwardEnabled() {
        return this.canGoForward;
    }

    @Override
    public void refresh() {
        if (lib == null) {
            SWT.error((int)47);
        }
        this.jsEnabled = this.jsEnabledOnNextPage;
        if (this.browser != null) {
            lib.cefswt_reload(this.browser);
        }
    }

    @Override
    public boolean setText(String html, boolean trusted) {
        String texturl = DATA_TEXT_URL + Base64.getEncoder().encodeToString(html.getBytes());
        return this.setUrl(texturl, null, null);
    }

    private static String getPlainUrl(String url) {
        if (url != null && url.startsWith(DATA_TEXT_URL)) {
            return url.substring(0, DATA_TEXT_URL.length() - 8);
        }
        return url;
    }

    @Override
    public boolean setUrl(String url, String postData, String[] headers) {
        this.url = url;
        this.postData = postData;
        this.headers = headers;
        this.jsEnabled = this.jsEnabledOnNextPage;
        if (!this.chromium.isDisposed() && this.browser != null) {
            this.debugPrint("set url: " + url);
            this.doSetUrl(url, postData, headers);
        }
        return true;
    }

    private CompletableFuture<Void> doSetUrl(String url, String postData, String[] headers) {
        return this.enableProgress.thenRun(() -> {
            this.debugPrint("load url");
            this.doSetUrlPost(this.browser, url, postData, headers);
        });
    }

    private void doSetUrlPost(Pointer browser, String url, String postData, String[] headers) {
        byte[] bytes = postData != null ? postData.getBytes(Charset.forName("ASCII")) : null;
        int bytesLength = postData != null ? bytes.length : 0;
        int headersLength = headers != null ? headers.length : 0;
        lib.cefswt_load_url(browser, url, bytes, bytesLength, headers, headersLength);
    }

    @Override
    public void stop() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.browser != null) {
            lib.cefswt_stop(this.browser);
        }
    }

    private final class CefFocusListener
    implements FocusListener {
        private boolean enabled = true;

        private CefFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            if (!this.enabled) {
                return;
            }
            this.enabled = false;
            Chromium.this.browserFocus(false);
            this.enabled = true;
        }

        public void focusGained(FocusEvent e) {
            if (!this.enabled) {
                return;
            }
            Chromium.this.browserFocus(true);
        }
    }

    public static interface Lib {
        public void cefswt_init(@Direct CEF.cef_app_t var1, String var2, String var3, int var4);

        public void cefswt_set_window_info_parent(Pointer var1, Pointer var2, @Direct CEF.cef_client_t var3, long var4, int var6, int var7, int var8, int var9);

        public Pointer cefswt_create_browser(long var1, String var3, @Direct CEF.cef_client_t var4, int var5, int var6, int var7, int var8);

        public boolean cefswt_is_same(@Direct Pointer var1, @Direct Pointer var2);

        public int cefswt_do_message_loop_work();

        public void cefswt_load_url(Pointer var1, @Encoding(value="UTF8") String var2, byte[] var3, int var4, String[] var5, int var6);

        public void cefswt_load_text(Pointer var1, @Encoding(value="UTF8") String var2);

        public void cefswt_stop(Pointer var1);

        public void cefswt_reload(Pointer var1);

        @Encoding(value="UTF8")
        public String cefswt_get_url(Pointer var1);

        public void cefswt_get_text(Pointer var1, CEF.cef_string_visitor_t var2);

        public void cefswt_resized(Pointer var1, int var2, int var3);

        public void cefswt_set_focus(Pointer var1, boolean var2, long var3);

        public void cefswt_go_forward(Pointer var1);

        public void cefswt_go_back(Pointer var1);

        public void cefswt_execute(Pointer var1, @Encoding(value="UTF8") String var2);

        public boolean cefswt_eval(Pointer var1, @Encoding(value="UTF8") String var2, int var3, CEFFactory.EvalReturned var4);

        public boolean cefswt_function(Pointer var1, @Encoding(value="UTF8") String var2, int var3);

        public CEFFactory.FunctionSt cefswt_function_id(Pointer var1);

        public boolean cefswt_function_arg(Pointer var1, int var2, CEFFactory.EvalReturned var3);

        public boolean cefswt_function_return(Pointer var1, int var2, int var3, CEFFactory.ReturnType var4, @Encoding(value="UTF8") String var5);

        public void cefswt_close_browser(Pointer var1);

        public boolean cefswt_is_main_frame(Pointer var1);

        public void cefswt_shutdown();

        public void cefswt_free(@Direct Pointer var1);

        @Encoding(value="UTF8")
        public String cefswt_cefstring_to_java(CEF.cef_string_t var1);

        @Encoding(value="UTF8")
        public String cefswt_request_to_java(Pointer var1);

        public void cefswt_dialog_close(Pointer var1, int var2, CEF.cef_string_t var3);

        public void cefswt_context_menu_cancel(Pointer var1);

        public boolean cefswt_set_cookie(@Encoding(value="UTF8") String var1, @Encoding(value="UTF8") String var2, @Encoding(value="UTF8") String var3, @Encoding(value="UTF8") String var4, @Encoding(value="UTF8") String var5, int var6, int var7, double var8);

        public boolean cefswt_get_cookie(String var1, CEF.cef_cookie_visitor_t var2);

        public void cefswt_delete_cookies();

        @Encoding(value="UTF8")
        public String cefswt_cookie_value(CEF.cef_cookie_t var1);
    }
}

