/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.chromium;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.Delegate;
import jnr.ffi.annotations.Encoding;
import jnr.ffi.mapper.CompositeTypeMapper;
import jnr.ffi.mapper.DefaultTypeMapper;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.SignatureTypeMapper;
import jnr.ffi.mapper.SignatureTypeMapperAdapter;
import jnr.ffi.provider.converters.StructByReferenceFromNativeConverter;
import jnr.ffi.provider.jffi.NativeClosureManager;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.util.EnumMapper;
import org.eclipse.swt.internal.chromium.CEF;

public class CEFFactory {
    public static Runtime RUNTIME;
    private static DefaultTypeMapper typeMapper;
    private static final FromNativeContext closureToNativeContext;

    static {
        closureToNativeContext = new FromNativeContext(){

            public Runtime getRuntime() {
                return RUNTIME;
            }

            public Collection<Annotation> getAnnotations() {
                return null;
            }
        };
    }

    public static Lib create() {
        boolean isWin = System.getProperty("os.name").toLowerCase().contains("win");
        boolean isMac = System.getProperty("os.name").toLowerCase().contains("mac");
        String toLoad = "cef";
        String cefrustPath = System.getProperty("cefswt.path", "");
        toLoad = isWin ? "libcef" : (isMac ? String.valueOf(cefrustPath) + "/Chromium Embedded Framework.framework/Chromium Embedded Framework" : String.valueOf(cefrustPath) + "/libcef.so");
        Lib lib = (Lib)LibraryLoader.create(Lib.class).load(toLoad);
        RUNTIME = Runtime.getRuntime((Object)lib);
        return lib;
    }

    private static DefaultTypeMapper getClosureTypeMapper() {
        try {
            if (typeMapper == null) {
                NativeClosureManager closureManager = NativeRuntime.getInstance().getClosureManager();
                Field compTypeMapperField = closureManager.getClass().getDeclaredField("typeMapper");
                compTypeMapperField.setAccessible(true);
                CompositeTypeMapper compTypeMapper = (CompositeTypeMapper)compTypeMapperField.get(closureManager);
                Field signatureTypeMappersField = CompositeTypeMapper.class.getDeclaredField("signatureTypeMappers");
                signatureTypeMappersField.setAccessible(true);
                Collection signatureTypeMappers = (Collection)signatureTypeMappersField.get(compTypeMapper);
                SignatureTypeMapper signatureTypeMapper = (SignatureTypeMapper)signatureTypeMappers.iterator().next();
                Field typeMapperField = SignatureTypeMapperAdapter.class.getDeclaredField("typeMapper");
                typeMapperField.setAccessible(true);
                typeMapper = (DefaultTypeMapper)typeMapperField.get(signatureTypeMapper);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return typeMapper;
    }

    public static void mapTypeForClosure(Class<? extends Struct> structClass) {
        DefaultTypeMapper typeMapper = CEFFactory.getClosureTypeMapper();
        if (typeMapper != null) {
            typeMapper.put(structClass, StructByReferenceFromNativeConverter.getInstance(structClass, (FromNativeContext)closureToNativeContext));
        }
    }

    public static CEF.cef_app_t newApp() {
        CEFFactory.mapTypeForClosure(CEF.cef_string_utf16_t.class);
        CEFFactory.mapTypeForClosure(CEF.cef_string_t.class);
        CEFFactory.mapTypeForClosure(CEF.cef_popup_features_t.class);
        CEFFactory.mapTypeForClosure(CEF.cef_cookie_t.class);
        CEF.cef_app_t st = new CEF.cef_app_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    public static CEF.cef_browser_process_handler_t newBrowserProcessHandler() {
        CEF.cef_browser_process_handler_t st = new CEF.cef_browser_process_handler_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    public static CEF.cef_client_t newClient() {
        CEF.cef_client_t st = new CEF.cef_client_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    public static CEF.cef_focus_handler_t newFocusHandler() {
        CEF.cef_focus_handler_t st = new CEF.cef_focus_handler_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    public static CEF.cef_life_span_handler_t newLifeSpanHandler() {
        CEF.cef_life_span_handler_t st = new CEF.cef_life_span_handler_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    public static CEF.cef_load_handler_t newLoadHandler() {
        CEF.cef_load_handler_t st = new CEF.cef_load_handler_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    public static CEF.cef_display_handler_t newDisplayHandler() {
        CEF.cef_display_handler_t st = new CEF.cef_display_handler_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    public static CEF.cef_request_handler_t newRequestHandler() {
        CEF.cef_request_handler_t st = new CEF.cef_request_handler_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    public static CEF.cef_jsdialog_handler_t newJsDialogHandler() {
        CEF.cef_jsdialog_handler_t st = new CEF.cef_jsdialog_handler_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    public static CEF.cef_context_menu_handler_t newContextMenuHandler() {
        CEF.cef_context_menu_handler_t st = new CEF.cef_context_menu_handler_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    public static CEF.cef_string_visitor_t newStringVisitor() {
        CEF.cef_string_visitor_t st = new CEF.cef_string_visitor_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    public static CEF.cef_cookie_visitor_t newCookieVisitor() {
        CEF.cef_cookie_visitor_t st = new CEF.cef_cookie_visitor_t(RUNTIME);
        CEFFactory.setBase(st, st.base);
        return st;
    }

    private static void setBase(Struct st, cef_base_ref_counted_t base) {
        CEFFactory.directMemoryForStruct(st);
        CEFFactory.setBaseRefCounting(st, base);
        CEFFactory.setBaseSize(st, base);
    }

    private static void setBaseSize(Struct st, cef_base_ref_counted_t base) {
        int sizeof = Struct.size((Struct)st);
        base.size.set((long)sizeof);
        base.name = st.getClass().getSimpleName();
    }

    private static void setBaseRefCounting(Struct st, cef_base_ref_counted_t base) {
        base.add_ref.set((Object)new AddRefFN(base));
        base.release.set((Object)new ReleaseFN(base));
        base.has_one_ref.set((Object)new HasOneRefFN(base));
    }

    static void directMemoryForStruct(Struct struct) {
        Struct.getMemory((Struct)struct, (int)32);
    }

    public static class AddRefFN
    implements cef_base_ref_counted_t.add_ref {
        private cef_base_ref_counted_t base;

        public AddRefFN(cef_base_ref_counted_t base) {
            this.base = base;
        }

        @Override
        @Delegate
        public void invoke(cef_base_ref_counted_t self) {
            ++this.base.ref;
        }
    }

    public static interface EvalReturned {
        @Delegate
        public void invoke(int var1, ReturnType var2, @Encoding(value="UTF8") String var3);
    }

    public static class FunctionSt
    extends Struct {
        public Struct.Signed32 id = new Struct.Signed32((Struct)this);
        public Struct.Signed32 port = new Struct.Signed32((Struct)this);
        public Struct.size_t args = new Struct.size_t((Struct)this);

        static {
            CEFFactory.mapTypeForClosure(FunctionSt.class);
        }

        public FunctionSt(Runtime runtime) {
            super(runtime);
        }
    }

    public static class HasOneRefFN
    implements cef_base_ref_counted_t.has_one_ref {
        private cef_base_ref_counted_t base;

        public HasOneRefFN(cef_base_ref_counted_t base) {
            this.base = base;
        }

        @Override
        public int invoke(cef_base_ref_counted_t self) {
            return this.base.ref == 1 ? 1 : 0;
        }
    }

    public static interface Lib {
    }

    public static class ReleaseFN
    implements cef_base_ref_counted_t.release {
        private cef_base_ref_counted_t base;

        public ReleaseFN(cef_base_ref_counted_t base) {
            this.base = base;
        }

        @Override
        public int invoke(cef_base_ref_counted_t self) {
            --this.base.ref;
            int cfr_ignored_0 = this.base.ref;
            return this.base.ref == 0 ? 1 : 0;
        }
    }

    public static enum ReturnType implements EnumMapper.IntegerEnum
    {
        Double(0),
        Bool(1),
        Str(2),
        Null(3),
        Array(4),
        Error(5);

        private int value;

        private ReturnType(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }

        public static ReturnType from(String v) {
            try {
                int value = Integer.parseInt(v);
                ReturnType[] returnTypeArray = ReturnType.values();
                int n = returnTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ReturnType rt = returnTypeArray[n2];
                    if (rt.intValue() == value) {
                        return rt;
                    }
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new IllegalArgumentException(v);
        }
    }

    public static class cef_base_ref_counted_t
    extends Struct {
        public Struct.UnsignedLong size = new Struct.UnsignedLong((Struct)this);
        public Struct.Function<add_ref> add_ref = this.function(add_ref.class);
        public Struct.Function<release> release = this.function(release.class);
        public Struct.Function<has_one_ref> has_one_ref = this.function(has_one_ref.class);
        int ref = 1;
        public String name;

        static {
            CEFFactory.mapTypeForClosure(cef_base_ref_counted_t.class);
        }

        public cef_base_ref_counted_t(Runtime runtime) {
            super(runtime);
        }

        public static interface add_ref {
            @Delegate
            public void invoke(cef_base_ref_counted_t var1);
        }

        public static interface has_one_ref {
            @Delegate
            public int invoke(cef_base_ref_counted_t var1);
        }

        public static interface release {
            @Delegate
            public int invoke(cef_base_ref_counted_t var1);
        }
    }
}

