/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.script.internal;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.relation.DocumentEntityRelation;
import it.jrc.osint.analysis.relation.EntityTextPosition;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.script.ScriptPlugin;
import it.jrc.osint.script.api.Document;
import it.jrc.osint.script.api.TextPosition;
import it.jrc.osint.script.internal.DocumentEntityRelationAdapter;
import it.jrc.osint.script.internal.EntityAdapter;
import it.jrc.osint.script.internal.TextPositionAdapter;
import it.jrc.osint.workspace.CaseProject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;

public class DocumentAdapter
implements Document {
    private static final Logger log = LogManager.getLogger((String)DocumentAdapter.class.getName());
    private ResourceId resourceId;
    private String title;
    private CaseProject cp;

    public DocumentAdapter(ResourceId id, CaseProject cp) {
        this.resourceId = id;
        this.cp = cp;
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            this.title = this.cp.getMetaItem(this.resourceId).getTitle();
        }
        return this.title;
    }

    @Override
    public String getLink() {
        return this.cp.getMetaItem(this.resourceId).getLink();
    }

    @Override
    public String getId() {
        return this.resourceId.toString();
    }

    @Override
    public String getFilePath() {
        IFile aFile = this.cp.getFile(this.resourceId);
        if (aFile != null && aFile.exists()) {
            return aFile.getLocation().toString();
        }
        return "";
    }

    @Override
    public String getText() {
        return this.cp.getMetaItem(this.resourceId).getText();
    }

    @Override
    public List<it.jrc.osint.script.api.Entity> getRelatedEntities() {
        LinkedList<it.jrc.osint.script.api.Entity> resultList = new LinkedList<it.jrc.osint.script.api.Entity>();
        Set entities = this.getAnalysisDatamodel().getRelatedEntities(this.resourceId);
        for (Entity anEntity : entities) {
            if (0L == anEntity.getId()) {
                log.warn("getRelatedEntitiey: Entity with null id found, not returned");
            }
            resultList.add(new EntityAdapter(anEntity, this.cp));
        }
        return resultList;
    }

    @Override
    public List<it.jrc.osint.script.api.DocumentEntityRelation> getDocumentEntityRelations() {
        ArrayList<it.jrc.osint.script.api.DocumentEntityRelation> resultList = new ArrayList<it.jrc.osint.script.api.DocumentEntityRelation>();
        Set relations = this.getAnalysisService().getDocumentEntityRelations(this.resourceId);
        for (DocumentEntityRelation r : relations) {
            DocumentEntityRelationAdapter rel = new DocumentEntityRelationAdapter(this, new EntityAdapter(r.getEntity(), this.cp), this.getTextPositionList(r.getTextPositions()));
            resultList.add(rel);
        }
        return resultList;
    }

    private List<TextPosition> getTextPositionList(Set<EntityTextPosition> textPositions) {
        ArrayList<TextPosition> resultList = new ArrayList<TextPosition>();
        for (EntityTextPosition t : textPositions) {
            resultList.add(new TextPositionAdapter(t.getPos(), t.getLength()));
        }
        return resultList;
    }

    private AnalysisService getAnalysisService() {
        return ScriptPlugin.getAnalysisService();
    }

    private AnalysisDatamodel getAnalysisDatamodel() {
        return this.getAnalysisService().getAnalysisDatamodel(this.cp.getId(), false);
    }
}

