/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.script.internal;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.script.ScriptPlugin;
import it.jrc.osint.script.api.Document;
import it.jrc.osint.script.internal.DocumentAdapter;
import it.jrc.osint.workspace.CaseProject;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class EntityAdapter
implements it.jrc.osint.script.api.Entity {
    private Entity entity;
    private CaseProject cp;

    public EntityAdapter(Entity anEntity, CaseProject cp) {
        this.entity = anEntity;
        this.cp = cp;
    }

    @Override
    public String getName() {
        return this.entity.getName();
    }

    @Override
    public String getId() {
        return Long.toString(this.entity.getId());
    }

    @Override
    public String getType() {
        return this.entity.getType();
    }

    @Override
    public String getTypeName() {
        String typeId;
        ExtractionService es = ScriptPlugin.getExtractionService();
        EntityType type = es.getEntityType(typeId = this.entity.getType());
        if (type != null) {
            return type.getName();
        }
        return typeId;
    }

    @Override
    public List<Document> getRelatedDocuments() {
        LinkedList<Document> resultList = new LinkedList<Document>();
        Set relatedDocIds = this.getAnalysisDatamodel().getRelatedDocumentIds(this.entity);
        for (ResourceId docId : relatedDocIds) {
            resultList.add(new DocumentAdapter(docId, this.cp));
        }
        return resultList;
    }

    @Override
    public List<it.jrc.osint.script.api.Entity> getRelatedEntities() {
        LinkedList<it.jrc.osint.script.api.Entity> resultList = new LinkedList<it.jrc.osint.script.api.Entity>();
        Set relatedEntities = this.getAnalysisDatamodel().getRelatedEntities(this.entity);
        for (Entity anEntity : relatedEntities) {
            resultList.add(new EntityAdapter(anEntity, this.cp));
        }
        return resultList;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private AnalysisDatamodel getAnalysisDatamodel() {
        return ScriptPlugin.getAnalysisService().getAnalysisDatamodel(this.cp.getId(), false);
    }
}

