/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.script.internal;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.graph.EntityEntityEdge;
import it.jrc.osint.analysis.graph.EntityEntityRelationshipGraph;
import it.jrc.osint.analysis.graph.GraphEdge;
import it.jrc.osint.analysis.relation.EntityTextPosition;
import it.jrc.osint.cmatcher.CategoryDatamodel;
import it.jrc.osint.cmatcher.CmatcherPlugin;
import it.jrc.osint.cmatcher.CmatcherService;
import it.jrc.osint.cmatcher.DocumentCategoryRelation;
import it.jrc.osint.cmatcher.internal.Alerts;
import it.jrc.osint.console.Console;
import it.jrc.osint.console.OSINTConsolePlugin;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.operations.OperationResult;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.script.ScriptPlugin;
import it.jrc.osint.script.api.Bookmark;
import it.jrc.osint.script.api.Category;
import it.jrc.osint.script.api.Document;
import it.jrc.osint.script.api.DocumentEntityRelation;
import it.jrc.osint.script.api.EntityEntityRelation;
import it.jrc.osint.script.api.Project;
import it.jrc.osint.script.api.TextPosition;
import it.jrc.osint.script.internal.BookmarkAdapter;
import it.jrc.osint.script.internal.CategoryAdapter;
import it.jrc.osint.script.internal.DocumentAdapter;
import it.jrc.osint.script.internal.DocumentEntityRelationAdapter;
import it.jrc.osint.script.internal.EntityAdapter;
import it.jrc.osint.script.internal.EntityEntityRelationAdapter;
import it.jrc.osint.script.internal.TextPositionAdapter;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;

public class ProjectAdapter
implements Project {
    private CaseProject cp;

    public ProjectAdapter(CaseProject cp) {
        this.cp = cp;
    }

    @Override
    public List<it.jrc.osint.script.api.Entity> getEntities() {
        ArrayList<it.jrc.osint.script.api.Entity> resultList = new ArrayList<it.jrc.osint.script.api.Entity>();
        AnalysisDatamodel ad = this.getAnalysisDatamodel();
        Set es = ad.getEntities();
        for (Entity entity : es) {
            resultList.add(new EntityAdapter(entity, this.cp));
        }
        return resultList;
    }

    @Override
    public List<String> getActiveCategories() {
        ArrayList<String> resultList = new ArrayList<String>();
        List listAlerts = this.getCmatcherService().getCategories();
        for (Alerts alerts : listAlerts) {
            List listtemp = alerts.getAlerts();
            for (Alerts.AlertOSINT alert : listtemp) {
                resultList.add(alert.getId());
            }
        }
        return resultList;
    }

    @Override
    public List<Document> getDocuments() {
        ArrayList<Document> resultList = new ArrayList<Document>();
        Set ds = this.getAnalysisDatamodel().getDocumentIds();
        for (String docId : ds) {
            resultList.add(new DocumentAdapter(new ResourceId(docId), this.cp));
        }
        return resultList;
    }

    @Override
    public List<Category> getDocumentsByCategory() {
        ArrayList<Category> resultList = new ArrayList<Category>();
        CategoryDatamodel cdm = this.getCategoryDatamodel();
        Set dcrs = cdm.getAllCategoryRelations();
        HashMap tempMap = new HashMap();
        for (DocumentCategoryRelation dcr : dcrs) {
            ResourceId docId = dcr.getDocumentId();
            Set categories = dcr.getCategories();
            for (SimpleElement se : categories) {
                List<DocumentAdapter> templistdoc = new ArrayList<DocumentAdapter>();
                if (tempMap.keySet().contains(se.getValue())) {
                    templistdoc = (List)tempMap.get(se.getValue());
                }
                templistdoc.add(new DocumentAdapter(docId, this.cp));
                tempMap.put(se.getValue(), templistdoc);
            }
        }
        for (String catname : tempMap.keySet()) {
            CategoryAdapter newcat = new CategoryAdapter(catname);
            for (Document newdoc : (List)tempMap.get(catname)) {
                newcat.addDocument(newdoc);
            }
            resultList.add(newcat);
        }
        return resultList;
    }

    @Override
    public List<Bookmark> getBookmarks() {
        Set bookmarkFileIds = this.cp.getFilesByContentType((IContainer)this.cp.getProject(), "it.jrc.osint.contenttype.URLBookmark");
        SearchService ss = ScriptPlugin.getSearchService();
        ArrayList<Bookmark> resultList = new ArrayList<Bookmark>();
        for (ResourceId id : bookmarkFileIds) {
            URLBookmark bm = ss.loadBookmark(id);
            IPath filePath = this.getWorkspaceService().getPath(id);
            if (bm == null) continue;
            resultList.add(new BookmarkAdapter(bm, filePath.toString()));
        }
        return resultList;
    }

    @Override
    public String getName() {
        return this.cp.getName();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public it.jrc.osint.script.api.Entity getEntityById(String id) {
        int searchId = Integer.parseInt(id);
        AnalysisDatamodel ad = this.getAnalysisDatamodel();
        Entity entity = ad.getEntity((long)searchId);
        if (entity != null) {
            return new EntityAdapter(entity, this.cp);
        }
        return null;
    }

    @Override
    public Document getDocumentById(String docIdStr) {
        ResourceId docId = new ResourceId(docIdStr);
        return new DocumentAdapter(docId, this.cp);
    }

    @Override
    public it.jrc.osint.script.api.Entity getEntityByName(String name) {
        AnalysisDatamodel ad = this.getAnalysisDatamodel();
        Entity entity = ad.findEntityByName(name);
        if (!Entity.NULL_ENTITY.equals((Object)entity)) {
            return new EntityAdapter(entity, this.cp);
        }
        return null;
    }

    @Override
    public List<it.jrc.osint.script.api.Entity> getEntitiesByNamePattern(String pattern) {
        OperationResult result = this.getAnalysisDatamodel().findEntityByNamePattern(pattern);
        OperationStatus status = result.getStatus();
        if (!status.isOK()) {
            this.getConsole().error("Report script: Failed to obtain entities by pattern. Reason:  " + status.getException());
            return Collections.emptyList();
        }
        ArrayList<it.jrc.osint.script.api.Entity> resultList = new ArrayList<it.jrc.osint.script.api.Entity>();
        for (Entity anEntity : (Set)result.getResult()) {
            resultList.add(new EntityAdapter(anEntity, this.cp));
        }
        return resultList;
    }

    @Override
    public List<it.jrc.osint.script.api.Entity> getEntitiesByEntityType(String entityType) {
        OperationResult result = this.getAnalysisDatamodel().findEntityByEntityType(entityType);
        OperationStatus status = result.getStatus();
        if (!status.isOK()) {
            this.getConsole().error("Report script: Failed to obtain entities by type. Reason:  " + status.getException());
            return Collections.emptyList();
        }
        ArrayList<it.jrc.osint.script.api.Entity> resultList = new ArrayList<it.jrc.osint.script.api.Entity>();
        for (Entity anEntity : (Set)result.getResult()) {
            resultList.add(new EntityAdapter(anEntity, this.cp));
        }
        return resultList;
    }

    @Override
    public List<DocumentEntityRelation> getDocumentEntityRelations() {
        ArrayList<DocumentEntityRelation> resultList = new ArrayList<DocumentEntityRelation>();
        Set relations = this.getAnalysisService().getAllDocumentEntityRelations(this.cp.getId());
        for (it.jrc.osint.analysis.relation.DocumentEntityRelation r : relations) {
            Document doc = this.getDocumentById(r.getDocumentId().toString());
            EntityAdapter entity = new EntityAdapter(r.getEntity(), this.cp);
            resultList.add(new DocumentEntityRelationAdapter(doc, entity, this.getTextPositions(r.getTextPositions())));
        }
        return resultList;
    }

    private List<TextPosition> getTextPositions(Set<EntityTextPosition> positionList) {
        ArrayList<TextPosition> resultList = new ArrayList<TextPosition>();
        for (EntityTextPosition t : positionList) {
            resultList.add(new TextPositionAdapter(t.getPos(), t.getLength()));
        }
        return resultList;
    }

    @Override
    public List<EntityEntityRelation> getEntityEntityRelations() {
        AnalysisDatamodel ad = this.getAnalysisDatamodel();
        EntityEntityRelationshipGraph eerGraph = ad.getEntityEntityRelationshipGraph(null);
        Set edges = eerGraph.getEdges();
        ArrayList<EntityEntityRelation> resultList = new ArrayList<EntityEntityRelation>();
        for (GraphEdge e : edges) {
            EntityEntityEdge eee = (EntityEntityEdge)e;
            Entity[] graphVertices = eee.getVertices();
            EntityAdapter eA = new EntityAdapter(graphVertices[0], this.cp);
            EntityAdapter eB = new EntityAdapter(graphVertices[1], this.cp);
            List<DocumentAdapter> docList = this.getConnectingDocumentList(graphVertices[0], graphVertices[1]);
            EntityEntityRelationAdapter r = new EntityEntityRelationAdapter(eA, eB, docList);
            resultList.add(r);
        }
        return resultList;
    }

    private List<DocumentAdapter> getConnectingDocumentList(Entity entityA, Entity entityB) {
        ArrayList<DocumentAdapter> resultList = new ArrayList<DocumentAdapter>();
        Set connectingDocs = this.getAnalysisDatamodel().getConnectingDocuments(entityA, entityB);
        for (ResourceId id : connectingDocs) {
            resultList.add(new DocumentAdapter(id, this.cp));
        }
        return resultList;
    }

    private AnalysisService getAnalysisService() {
        return ScriptPlugin.getAnalysisService();
    }

    private AnalysisDatamodel getAnalysisDatamodel() {
        return this.getAnalysisService().getAnalysisDatamodel(this.cp.getId(), false);
    }

    private CategoryDatamodel getCategoryDatamodel() {
        return this.getCmatcherService().getCategoryDatamodel(true);
    }

    private CmatcherService getCmatcherService() {
        return CmatcherPlugin.getCmatcherService();
    }

    private WorkspaceService getWorkspaceService() {
        return WorkspacePlugin.getWorkspaceService();
    }

    private Console getConsole() {
        return OSINTConsolePlugin.getConsole();
    }
}

