/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.script.internal;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.script.ScriptExecutionResult;
import it.jrc.osint.script.ScriptService;
import it.jrc.osint.script.api.Project;
import it.jrc.osint.script.internal.ProjectAdapter;
import it.jrc.osint.script.internal.ScriptExecutionResultImpl;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.osint.workspace.CaseProject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptServiceImpl
implements ScriptService {
    private static final Logger log = LogManager.getLogger((String)ScriptServiceImpl.class.getName());

    @Override
    public Project getProject(CaseProject cp) {
        ProjectAdapter project = new ProjectAdapter(cp);
        return project;
    }

    /*
     * Loose catch block
     */
    @Override
    public ScriptExecutionResult executeJavaScript(String scriptPath, String[] resourcePaths, File outputFolder, Map<String, Object> scriptContextBindings) {
        ScriptExecutionResultImpl scriptExecutionResultImpl;
        File scriptFile;
        InputStreamReader in;
        block12: {
            ScriptEngineManager sem = new ScriptEngineManager();
            List<ScriptEngineFactory> factories = sem.getEngineFactories();
            for (ScriptEngineFactory sef : factories) {
                log.debug(String.valueOf(sef.getEngineName()) + ":" + sef.getLanguageName() + ":" + sef.getLanguageVersion());
            }
            if (scriptPath == null || scriptPath.isEmpty()) {
                OperationStatus resultStatus = OperationStatus.createErrorStatus((String)"Script path parameter is empty", null);
                return new ScriptExecutionResultImpl(resultStatus, null);
            }
            in = null;
            scriptFile = this.getScriptFile(scriptPath, resourcePaths);
            if (scriptFile != null) break block12;
            log.error("Could not execute script " + scriptPath + " - file not found. ");
            OperationStatus resultStatus = OperationStatus.createErrorStatus((String)"Script file not found", null);
            ScriptExecutionResultImpl scriptExecutionResultImpl2 = new ScriptExecutionResultImpl(resultStatus, null);
            FileUtil.close((Reader)in);
            return scriptExecutionResultImpl2;
        }
        try {
            in = new InputStreamReader(new FileInputStream(scriptFile));
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("JavaScript");
            if (outputFolder != null) {
                engine.put("output", outputFolder);
            }
            if (scriptContextBindings != null) {
                for (String key : scriptContextBindings.keySet()) {
                    engine.put(key, scriptContextBindings.get(key));
                }
            }
            Object evalResult = engine.eval(in);
            scriptExecutionResultImpl = new ScriptExecutionResultImpl(OperationStatus.OK_STATUS, evalResult);
        }
        catch (ScriptException e) {
            log.error("Failed to execute script at line number: " + e.getLineNumber(), (Throwable)e);
            OperationStatus resultStatus = OperationStatus.createErrorStatus((String)("Script execution failed at line: " + e.getLineNumber()), (Throwable)e);
            ScriptExecutionResultImpl scriptExecutionResultImpl3 = new ScriptExecutionResultImpl(resultStatus, null);
            FileUtil.close((Reader)in);
            return scriptExecutionResultImpl3;
        }
        catch (Throwable t) {
            log.error("Failed to execute script", t);
            OperationStatus resultStatus = OperationStatus.createErrorStatus((String)"Script execution failed.", (Throwable)t);
            ScriptExecutionResultImpl scriptExecutionResultImpl4 = new ScriptExecutionResultImpl(resultStatus, null);
            {
                catch (Throwable throwable) {
                    FileUtil.close(in);
                    throw throwable;
                }
            }
            FileUtil.close((Reader)in);
            return scriptExecutionResultImpl4;
        }
        FileUtil.close((Reader)in);
        return scriptExecutionResultImpl;
    }

    private File getScriptFile(String scriptPath, String[] resourcePaths) {
        String[] stringArray = resourcePaths;
        int n = resourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String resourcePath = stringArray[n2];
            String scriptFilePath = null;
            scriptFilePath = !scriptPath.startsWith("/") ? String.valueOf(resourcePath) + File.separator + scriptPath : String.valueOf(resourcePath) + scriptPath;
            File scriptFile = new File(scriptFilePath);
            if (scriptFile.exists()) {
                return scriptFile;
            }
            ++n2;
        }
        return null;
    }
}

