/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.console.ui.internal;

import it.jrc.osint.console.ConsoleEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleImpl
extends MessageConsole {
    private static final int MSG_INFORMATION = 1;
    private static final int MSG_WARNING = 2;
    private static final int MSG_ERROR = 3;

    public ConsoleImpl() {
        super("OSINT Console", null);
    }

    void print(ConsoleEvent msg) {
        ConsoleEvent.MessageType type = msg.getType();
        if (type == null) {
            return;
        }
        if (type.equals((Object)ConsoleEvent.MessageType.INFO)) {
            this.printInfo(msg.getMessage());
        } else if (type.equals((Object)ConsoleEvent.MessageType.WARN)) {
            this.printWarning(msg.getMessage());
        } else if (type.equals((Object)ConsoleEvent.MessageType.ERROR)) {
            this.printError(msg.getMessage());
        }
    }

    void printInfo(final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConsoleImpl.this.displayConsoleView();
                MessageConsoleStream msgConsoleStream = ConsoleImpl.this.getNewMessageConsoleStream(1);
                msgConsoleStream.println(msg);
            }
        });
    }

    void printError(final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConsoleImpl.this.displayConsoleView();
                MessageConsoleStream msgConsoleStream = ConsoleImpl.this.getNewMessageConsoleStream(3);
                msgConsoleStream.println(msg);
            }
        });
    }

    void printWarning(final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConsoleImpl.this.displayConsoleView();
                MessageConsoleStream msgConsoleStream = ConsoleImpl.this.getNewMessageConsoleStream(2);
                msgConsoleStream.println(msg);
            }
        });
    }

    private boolean displayConsoleView() {
        try {
            IWorkbenchPage activePage;
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
                activePage.showView("org.eclipse.ui.console.ConsoleView", null, 2);
            }
        }
        catch (PartInitException partEx) {
            return false;
        }
        return true;
    }

    private MessageConsoleStream getNewMessageConsoleStream(int msgKind) {
        int swtColorId = 6;
        int fontStyleId = 0;
        switch (msgKind) {
            case 1: {
                swtColorId = 2;
                break;
            }
            case 3: {
                swtColorId = 12;
                break;
            }
            case 2: {
                swtColorId = 10;
                fontStyleId = 2;
            }
        }
        MessageConsoleStream msgConsoleStream = this.newMessageStream();
        msgConsoleStream.setColor(Display.getDefault().getSystemColor(swtColorId));
        msgConsoleStream.setFontStyle(fontStyleId);
        return msgConsoleStream;
    }
}

