/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui;

import it.jrc.osint.util.EventSourceSupport;
import it.jrc.osint.util.io.IOUtil;
import it.jrc.osint.util.ui.EditElementDialog;
import it.jrc.osint.util.ui.LabelProviderAdapter;
import it.jrc.osint.util.ui.ListEditorEventListener;
import it.jrc.osint.util.ui.StructuredContentProviderAdapter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ListEditorComponent
extends Composite {
    public static final String PROP_DIRTY = "dirty";
    protected Button addButton;
    protected String addButtonTitle = "Add...";
    private IContentProvider contentProvider = new DefaultListContentProvider();
    private boolean dirty;
    protected Button editButton;
    protected String editButtonTitle = "Edit...";
    protected String elementName = "anElement";
    private EventSourceSupport<ListEditorEventListener> eventSourceSupport = new EventSourceSupport();
    private FormToolkit formToolkit;
    private String modelInitialValueStr;
    private ILabelProvider labelProvider = new DefaultListLabelProvider();
    private org.eclipse.swt.widgets.List list;
    private ListViewer listViewer;
    private List model = new ArrayList();
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    protected Button removeButton;
    protected String removeButtonTitle = "Remove";
    private Object selectedElement;

    public ListEditorComponent(Composite parent, int style) {
        super(parent, style);
        this.model = new ArrayList();
        this.createControl();
    }

    public void setEditButtonTitle(String newTitle) {
        this.editButtonTitle = newTitle;
    }

    public void setAddButtonTitle(String newTitle) {
        this.addButtonTitle = newTitle;
    }

    public void setRemoveButtonTitle(String newTitle) {
        this.removeButtonTitle = newTitle;
    }

    public void addListEditorEventListener(ListEditorEventListener aListener) {
        this.eventSourceSupport.addEventListener((EventListener)aListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    protected void createControl() {
        this.performCreateControl();
    }

    protected void performCreateControl() {
        if (this.formToolkit == null) {
            this.formToolkit = new FormToolkit(this.getParent().getDisplay());
        }
        this.formToolkit.adapt((Composite)this);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.marginHeight = 0;
        gridLayout_1.numColumns = 2;
        gridLayout_1.marginWidth = 0;
        this.setLayout((Layout)gridLayout_1);
        this.formToolkit.paintBordersFor((Composite)this);
        Composite listComposite = this.formToolkit.createComposite((Composite)this, 0);
        listComposite.setLayout((Layout)new GridLayout());
        listComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.formToolkit.paintBordersFor(listComposite);
        this.listViewer = new ListViewer(listComposite, 2048);
        this.list = this.listViewer.getList();
        this.list.setLayoutData((Object)new GridData(4, 4, true, true));
        this.list.setRedraw(true);
        this.formToolkit.adapt((Control)this.list, true, true);
        this.listViewer.setContentProvider(this.contentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setInput((Object)this.model);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    ListEditorComponent.this.selectedElement = null;
                    ListEditorComponent.this.editButton.setEnabled(false);
                    ListEditorComponent.this.removeButton.setEnabled(false);
                } else {
                    ListEditorComponent.this.selectedElement = selection.getFirstElement();
                    ListEditorComponent.this.editButton.setEnabled(true);
                    ListEditorComponent.this.removeButton.setEnabled(true);
                }
            }
        });
        Composite buttonComposite = this.formToolkit.createComposite((Composite)this, 0);
        GridData gd_buttonComposite = new GridData();
        gd_buttonComposite.verticalAlignment = 128;
        buttonComposite.setLayoutData((Object)gd_buttonComposite);
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.marginWidth = 5;
        fillLayout.marginHeight = 5;
        fillLayout.spacing = 5;
        buttonComposite.setLayout((Layout)fillLayout);
        this.formToolkit.paintBordersFor(buttonComposite);
        this.addButton = this.formToolkit.createButton(buttonComposite, this.addButtonTitle, 0);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditElementDialog addDialog = ListEditorComponent.this.createAddDialog(ListEditorComponent.this.getShell());
                if (addDialog.open() == 0) {
                    Object addedItem = addDialog.getValue();
                    ListEditorComponent.this.model.add(addedItem);
                    ListEditorComponent.this.listViewer.refresh();
                    ListEditorComponent.this.fireAddEvent(addedItem, addDialog.getDialogModel());
                }
            }
        });
        this.editButton = this.formToolkit.createButton(buttonComposite, this.editButtonTitle, 0);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ListEditorComponent.this.listViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    ListEditorComponent.this.selectedElement = selection.getFirstElement();
                }
                String origStrValue = IOUtil.serialize((Object)ListEditorComponent.this.selectedElement);
                EditElementDialog editDialog = ListEditorComponent.this.createEditDialog(ListEditorComponent.this.getShell(), ListEditorComponent.this.selectedElement);
                if (editDialog.open() == 0) {
                    Object changedItem = editDialog.getValue();
                    String editedStrValue = IOUtil.serialize((Object)changedItem);
                    if (origStrValue.equals(editedStrValue)) {
                        return;
                    }
                    int indexOfSelectedUrl = ListEditorComponent.this.model.indexOf(ListEditorComponent.this.selectedElement);
                    if (indexOfSelectedUrl != -1) {
                        ListEditorComponent.this.model.set(indexOfSelectedUrl, changedItem);
                        ListEditorComponent.this.fireEditEvent(changedItem, editDialog.getDialogModel());
                    }
                    ListEditorComponent.this.listViewer.refresh();
                }
            }
        });
        this.removeButton = this.formToolkit.createButton(buttonComposite, this.removeButtonTitle, 0);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection i = (IStructuredSelection)ListEditorComponent.this.listViewer.getSelection();
                Object item = i.getFirstElement();
                ListEditorComponent.this.model.remove(item);
                ListEditorComponent.this.listViewer.refresh();
                ListEditorComponent.this.fireDeleteEvent(item);
            }
        });
        if (!this.hasEditDialog()) {
            this.editButton.setVisible(false);
        }
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void fireAddEvent(Object addedElement, Object addDialogModel) {
        for (ListEditorEventListener listener : this.eventSourceSupport) {
            listener.elementAdded(addedElement, addDialogModel);
        }
        this.fireDirtyPropertyChanged();
    }

    private void fireDeleteEvent(Object deletedElement) {
        for (ListEditorEventListener listener : this.eventSourceSupport) {
            listener.elementDeleted(deletedElement);
        }
        this.fireDirtyPropertyChanged();
    }

    private void fireDirtyPropertyChanged() {
        boolean newDirty = this.dirty;
        String currentStrValue = IOUtil.serialize((Object)this.model);
        newDirty = !this.modelInitialValueStr.equals(currentStrValue);
        if (this.dirty != newDirty) {
            this.dirty = newDirty;
            this.propertyChangeSupport.firePropertyChange(PROP_DIRTY, !newDirty, newDirty);
        }
    }

    private void fireEditEvent(Object changedElement, Object editDialogModel) {
        for (ListEditorEventListener listener : this.eventSourceSupport) {
            listener.elementEdited(changedElement, editDialogModel);
        }
        this.fireDirtyPropertyChanged();
    }

    public List getModel() {
        return this.model;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected abstract EditElementDialog createAddDialog(Shell var1);

    protected EditElementDialog createEditDialog(Shell parentShell, Object selectedElement) {
        return null;
    }

    public void removeListEditorEventListener(ListEditorEventListener aListener) {
        this.eventSourceSupport.removeEventListener((EventListener)aListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setContentProvider(IContentProvider newContentProvider) {
        this.contentProvider = newContentProvider;
        if (this.listViewer != null) {
            this.listViewer.setContentProvider(newContentProvider);
        }
    }

    protected boolean hasEditDialog() {
        return false;
    }

    public void setElementName(String newElementName) {
        this.elementName = newElementName;
    }

    public void setFormToolkit(FormToolkit formToolkit) {
        this.formToolkit = formToolkit;
    }

    public void setLabelProvider(ILabelProvider newLabelProvider) {
        this.labelProvider = newLabelProvider;
        if (this.listViewer != null) {
            this.listViewer.setLabelProvider((IBaseLabelProvider)newLabelProvider);
        }
    }

    public void setModel(List newModel) {
        this.model = newModel;
        this.modelInitialValueStr = IOUtil.serialize((Object)newModel);
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ListEditorComponent.this.listViewer.setInput((Object)ListEditorComponent.this.model);
                ListEditorComponent.this.listViewer.refresh();
            }
        });
    }

    public void setEnabledAddButton(final boolean enable) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ListEditorComponent.this.addButton.setEnabled(enable);
            }
        });
    }

    private static class DefaultListContentProvider
    extends StructuredContentProviderAdapter {
        private DefaultListContentProvider() {
        }

        @Override
        public Object[] getElements(Object inputElement) {
            List v = (List)inputElement;
            return v.toArray();
        }
    }

    private static class DefaultListLabelProvider
    extends LabelProviderAdapter {
        private DefaultListLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            return element.toString();
        }
    }
}

