/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class TextStyleRegistry {
    private static final Logger log = LogManager.getLogger((String)TextStyleRegistry.class.getName());
    private Map<String, TextStyleEntry> styleMap = new HashMap<String, TextStyleEntry>();
    private Color defaultForeground = Display.getCurrent().getSystemColor(22);
    private Color defaultBackground = Display.getCurrent().getSystemColor(21);

    public void register(String styleId, Color foreground, Color background, int fontstyle) {
        this.styleMap.put(styleId, new TextStyleEntry(foreground, background, fontstyle));
    }

    public void register(String styleId, Color foreground) {
        this.register(styleId, foreground, Display.getCurrent().getSystemColor(15), 0);
    }

    public int getFontStyle(String aStyle) {
        TextStyleEntry entry = this.styleMap.get(aStyle);
        if (entry != null) {
            return entry.fontstyle;
        }
        return 0;
    }

    public Color[] getColors(String styleId) {
        TextStyleEntry entry = this.styleMap.get(styleId);
        if (entry != null) {
            Color[] colors = new Color[]{entry.foreground, entry.background};
            return colors;
        }
        return new Color[]{this.defaultForeground, this.defaultBackground};
    }

    public void dispose() {
    }

    private static class TextStyleEntry {
        Color foreground;
        Color background;
        int fontstyle;

        TextStyleEntry(Color foreground, Color background, int fontstyle) {
            this.foreground = foreground;
            this.background = background;
            this.fontstyle = fontstyle;
        }
    }
}

