/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IInputValidator;

public class Validators {
    public static IInputValidator containsOnlyValidFilenameCharacters(String errorHint) {
        return new ValidFilenameCharacterValidator(errorHint);
    }

    public static IInputValidator containsOnlyValidFilenameCharacters(String errorHint, IInputValidator chainedValidator) {
        return new ValidFilenameCharacterValidator(errorHint, chainedValidator);
    }

    public static IInputValidator isValidWebsiteURL(String errorHint) {
        return new URLValidator(errorHint);
    }

    public static IInputValidator notEmpty(String errorHint) {
        return new NotEmptyValidator(errorHint);
    }

    public static IInputValidator notEmpty(String errorHint, IInputValidator chainedValidator) {
        return new NotEmptyValidator(errorHint, chainedValidator);
    }

    public static IInputValidator notEqualsExistingValues(String errorHint, List<String> existingValues) {
        return new NotEqualsExistingValidator(errorHint, existingValues);
    }

    public static IInputValidator notEqualsExistingValues(String errorHint, List<String> existingValues, IInputValidator chainedValidator) {
        return new NotEqualsExistingValidator(errorHint, existingValues, chainedValidator);
    }

    public static IInputValidator notEqualsExistingValues(String errorHint, List<String> existingValues, String editedValue, IInputValidator chainedValidator) {
        return new NotEqualsExistingValidator(errorHint, existingValues, editedValue, chainedValidator);
    }

    public static abstract class AbstractValidator
    implements IInputValidator {
        private IInputValidator nextValidator;
        private String errorMessage;

        public AbstractValidator(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public AbstractValidator(String errorMessage, IInputValidator chainedValidator) {
            this(errorMessage);
            this.nextValidator = chainedValidator;
        }

        public void addChainedValidator(IInputValidator chainedValidator) {
            this.nextValidator = chainedValidator;
        }

        public String isValid(String newText) {
            if (this.validate(newText)) {
                if (this.nextValidator != null) {
                    return this.nextValidator.isValid(newText);
                }
                return null;
            }
            return this.errorMessage;
        }

        protected abstract boolean validate(String var1);
    }

    private static class NotEmptyValidator
    extends AbstractValidator {
        public NotEmptyValidator(String errorMessage) {
            super(errorMessage);
        }

        public NotEmptyValidator(String errorMessage, IInputValidator chainedValidator) {
            super(errorMessage, chainedValidator);
        }

        @Override
        public boolean validate(String text) {
            if (text == null) {
                return false;
            }
            if ("".equals(text.trim())) {
                return false;
            }
            return (text = text.trim()).length() >= 1;
        }
    }

    private static class NotEqualsExistingValidator
    extends AbstractValidator {
        private String editedValue;
        private List<String> existingValues;

        public NotEqualsExistingValidator(String errorMessage, List<String> existingValues) {
            super(errorMessage);
            this.existingValues = existingValues;
        }

        public NotEqualsExistingValidator(String errorMessage, List<String> existingValues, IInputValidator chainedValidator) {
            super(errorMessage, chainedValidator);
            this.existingValues = existingValues;
        }

        public NotEqualsExistingValidator(String errorMessage, List<String> existingValues, String editedValue, IInputValidator chainedValidator) {
            this(errorMessage, existingValues, chainedValidator);
            this.editedValue = editedValue;
        }

        @Override
        protected boolean validate(String newText) {
            if (this.existingValues == null) {
                return true;
            }
            for (String aValue : this.existingValues) {
                if (!aValue.equals(newText)) continue;
                if (this.editedValue != null) {
                    return this.editedValue.equals(newText);
                }
                return false;
            }
            return true;
        }
    }

    private static class RegularExpressionValidator
    extends AbstractValidator {
        private String regexPattern;
        private Pattern compiledPattern;

        public RegularExpressionValidator(String regularExpressionPattern, String errorMessage) {
            super(errorMessage);
            this.regexPattern = regularExpressionPattern;
            this.compiledPattern = Pattern.compile(this.regexPattern);
        }

        @Override
        protected boolean validate(String newText) {
            Matcher m = this.compiledPattern.matcher(newText);
            return m.matches();
        }
    }

    private static class URLValidator
    extends AbstractValidator {
        private static final String regexPattern = "^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?";
        private Pattern compiledPattern = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");

        public URLValidator(String errorMessage) {
            super(errorMessage);
        }

        @Override
        protected boolean validate(String newText) {
            Matcher m = this.compiledPattern.matcher(newText);
            if (!m.matches()) {
                return false;
            }
            String protocol = m.group(2);
            if (!"http".equals(protocol) && !"https".equals(protocol)) {
                return false;
            }
            String host = m.group(4);
            return host != null && !"".equals(host);
        }
    }

    private static class ValidFilenameCharacterValidator
    extends AbstractValidator {
        private char[] forbiddenCharacters = new char[]{'*', '\\', '\"', '/', '[', ']', ':', ';', '|', '=', ','};

        public ValidFilenameCharacterValidator(String errorMessage) {
            super(errorMessage);
        }

        public ValidFilenameCharacterValidator(String errorMessage, IInputValidator chainedValidator) {
            super(errorMessage, chainedValidator);
        }

        @Override
        protected boolean validate(String newText) {
            char[] cArray = this.forbiddenCharacters;
            int n = this.forbiddenCharacters.length;
            int n2 = 0;
            while (n2 < n) {
                char forbiddenCharacter = cArray[n2];
                if (newText.indexOf(forbiddenCharacter) != -1) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

