/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui;

import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.WorkspaceFileEditorModel;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import it.jrc.osint.util.ui.PartListenerAdapter;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.osint.workspace.WorkspaceServiceEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public abstract class WorkspaceFileEditor
extends EditorPart {
    private static final Logger log = LogManager.getLogger((String)WorkspaceFileEditor.class.getName());
    private EventBroker eventBroker;
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();
    private IPartListener partListener = new PartListenerImpl();
    protected ResourceId fileId;
    private boolean underlyingFileDeleted;

    public WorkspaceFileEditor(EventBroker eventBroker) {
        this.eventBroker = eventBroker;
    }

    protected abstract void loadModel(InputStream var1);

    protected abstract boolean performSave(IFile var1, IProgressMonitor var2);

    public void doSave(IProgressMonitor monitor) {
        IFileEditorInput fileInput = (IFileEditorInput)this.getEditorInput();
        IFile file = fileInput.getFile();
        this.performSave(file, monitor);
        this.getEditorModel().afterSave();
        this.getEditorModel().checkpoint();
    }

    protected void performSaveAs(IProgressMonitor monitor) {
        boolean isDeleted;
        IFile original;
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        try {
            dialog.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        boolean bl = isDeleted = !workspace.getRoot().exists(original.getFullPath());
        if (isDeleted && original != null) {
            dialog.setErrorMessage(null);
            dialog.setMessage("File does not exist " + original.getName(), 2);
        }
        if (dialog.open() == 1) {
            if (monitor != null) {
                monitor.setCanceled(true);
            }
            return;
        }
        IPath saveToFilePath = dialog.getResult();
        if (saveToFilePath == null) {
            if (monitor != null) {
                monitor.setCanceled(true);
            }
            return;
        }
        IFile file = workspace.getRoot().getFile(saveToFilePath);
        FileEditorInput newInput = new FileEditorInput(file);
        boolean success = this.performSave(file, monitor);
        if (success) {
            this.setInput((IEditorInput)newInput);
            this.getEditorModel().afterSave();
            this.getEditorModel().checkpoint();
            this.fileId = this.getWorkspaceService().getId(saveToFilePath);
        } else {
            MessageDialog.openError((Shell)shell, (String)"Save operation failed", (String)"Failed to save file");
        }
        if (monitor != null) {
            monitor.setCanceled(!success);
        }
    }

    public void doSaveAs() {
        this.performSaveAs(null);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof IFileEditorInput) {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            this.fileId = this.getWorkspaceService().getId(file.getFullPath());
            try {
                this.loadModel(file.getContents());
                this.getEditorModel().addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent arg0) {
                        WorkspaceFileEditor.this.fireDirtyPropertyChanged();
                    }
                });
                this.eventBroker.register(new String[]{"osint/workspace/metaDataChanged", "osint/workspace/resourceDeleted", "osint/workspace/resourceMoved"}, this.topicEventListener);
            }
            catch (CoreException e) {
                throw new PartInitException("Could not read file " + file.getFullPath().toString() + " from workspace");
            }
            this.updateTitle();
            this.getSite().getPage().addPartListener(this.partListener);
            this.afterInit();
        }
    }

    protected void afterInit() {
    }

    public boolean isDirty() {
        return this.getEditorModel().isDirty();
    }

    private void fireDirtyPropertyChanged() {
        Display display = this.getSite().getShell().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                WorkspaceFileEditor.this.firePropertyChange(257);
            }
        });
    }

    private void updateTitle() {
        this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                WorkspaceFileEditor.this.setPartName(WorkspaceFileEditor.this.getEditorInput().getName());
                WorkspaceFileEditor.this.setTitleToolTip(WorkspaceFileEditor.this.getEditorInput().getToolTipText());
            }
        });
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    protected abstract WorkspaceFileEditorModel getEditorModel();

    protected void removeListeners() {
        this.eventBroker.unregister(this.topicEventListener);
        this.getSite().getPage().removePartListener(this.partListener);
    }

    protected ResourceId getProjectId() {
        return this.getWorkspaceService().getProjectByResourceId(this.fileId).getId();
    }

    private WorkspaceService getWorkspaceService() {
        return WorkspacePlugin.getWorkspaceService();
    }

    private class PartListenerImpl
    extends PartListenerAdapter {
        private PartListenerImpl() {
        }

        @Override
        public void partActivated(IWorkbenchPart part) {
            if (part != WorkspaceFileEditor.this) {
                return;
            }
            if (WorkspaceFileEditor.this.underlyingFileDeleted) {
                WorkspaceFileEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkspaceFileEditor.this.getSite().getPage().activate((IWorkbenchPart)WorkspaceFileEditor.this);
                        MessageDialog dialog = new MessageDialog(WorkspaceFileEditor.this.getSite().getShell(), "File Not Accessible", null, "The file has been deleted or is not accessible. Do you want to save your changes or close the editor without saving?", 3, new String[]{"Save", IDialogConstants.CLOSE_LABEL}, 0);
                        int userChoice = dialog.open();
                        if (userChoice == 0) {
                            WorkspaceFileEditor.this.getSite().getPage().saveEditor((IEditorPart)WorkspaceFileEditor.this, false);
                            WorkspaceFileEditor.this.underlyingFileDeleted = false;
                        } else {
                            WorkspaceFileEditor.this.getSite().getPage().closeEditor((IEditorPart)WorkspaceFileEditor.this, false);
                        }
                    }
                });
            }
        }

        @Override
        public void partClosed(IWorkbenchPart part) {
            if (WorkspaceFileEditor.this == part) {
                WorkspaceFileEditor.this.removeListeners();
            }
        }
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            if (event instanceof WorkspaceServiceEvent) {
                WorkspaceServiceEvent wsEvent = (WorkspaceServiceEvent)event;
                if ("osint/workspace/metaDataChanged".equals(event.getTopic())) {
                    wsEvent.getResourceIds().contains(WorkspaceFileEditor.this.fileId);
                }
                if ("osint/workspace/resourceDeleted".equals(event.getTopic()) && wsEvent.getResourceIds().contains(WorkspaceFileEditor.this.fileId)) {
                    if (WorkspaceFileEditor.this.isDirty()) {
                        WorkspaceFileEditor.this.underlyingFileDeleted = true;
                    } else {
                        WorkspaceFileEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                WorkspaceFileEditor.this.getSite().getPage().closeEditor((IEditorPart)WorkspaceFileEditor.this, false);
                            }
                        });
                    }
                }
                if ("osint/workspace/resourceMoved".equals(event.getTopic()) && wsEvent.getResourceIds().contains(WorkspaceFileEditor.this.fileId)) {
                    IFile movedFile = WorkspaceFileEditor.this.getWorkspaceService().getFile(WorkspaceFileEditor.this.fileId);
                    FileEditorInput newInputResource = new FileEditorInput(movedFile);
                    WorkspaceFileEditor.this.setInput((IEditorInput)newInputResource);
                    WorkspaceFileEditor.this.updateTitle();
                }
            }
        }
    }
}

