/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui.wizard;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.ui.wizard.SelectFolderWizardPage;
import it.jrc.osint.util.ui.wizard.SelectFolderWizardPageModel;
import it.jrc.osint.util.ui.wizard.WizardPageController;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class SelectFolderWizardPageController
extends WizardPageController {
    private static final Logger log = LogManager.getLogger((String)SelectFolderWizardPageController.class.getName());
    private SelectFolderWizardPageModel model = new SelectFolderWizardPageModel();
    private SelectFolderWizardPage view;
    private String pageFileInputLabel = "Select the output folder:";
    private String dialogTitle = "Select the output folder";
    private boolean isSaveDialog = false;

    void setView(SelectFolderWizardPage view) {
        this.view = view;
    }

    @Override
    public IWizardPage getView() {
        if (this.view == null) {
            this.view = new SelectFolderWizardPage("Select the output folder", this);
        }
        return this.view;
    }

    void showFileDialog(Shell shell) {
        int style = 4096;
        if (this.isSaveDialog) {
            style = 8192;
        }
        DirectoryDialog dirDialog = new DirectoryDialog(shell, style);
        dirDialog.setText(this.dialogTitle);
        String selectedPath = dirDialog.open();
        if (this.verifyPath(selectedPath)) {
            this.view.showFilePath(selectedPath);
            this.view.setSelectionValid(true);
            this.model.setFilePath(selectedPath);
        } else {
            this.view.setSelectionValid(false);
        }
    }

    private boolean verifyPath(String filePath) {
        return filePath != null;
    }

    public boolean hasFilePath() {
        return this.model.getFilePath() != null && !"".equals(this.model.getFilePath());
    }

    public String getFilePath() {
        return this.model.getFilePath();
    }

    public void setDialogTitle(String newTitle) {
        this.dialogTitle = newTitle;
    }

    public void setPageFileInputLabel(String newLabel) {
        this.pageFileInputLabel = newLabel;
    }

    String getPageFileInputLabel() {
        return this.pageFileInputLabel;
    }

    public void setSaveDialog(boolean isSave) {
        this.isSaveDialog = isSave;
    }
}

