/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui.wizard;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.ui.wizard.IDEWorkbenchMessages;
import it.jrc.osint.util.ui.wizard.ResourceAndContainerGroup;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class WizardNewFileCreationPage
extends WizardPage
implements Listener {
    private static final Logger log = LogManager.getLogger((String)WizardNewFileCreationPage.class.getName());
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    private IStructuredSelection currentSelection;
    private IFile newFile;
    private URI linkTargetPath;
    private ResourceAndContainerGroup resourceGroup;
    private Button advancedButton;
    private Composite linkedResourceParent;
    private Composite linkedResourceComposite;
    private String initialFileName;
    private String initialFileExtension;
    private IPath initialContainerFullPath;
    private boolean initialAllowExistingResources = false;
    private int linkedResourceGroupHeight = -1;
    private boolean firstLinkCheck = true;

    public WizardNewFileCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setPageComplete(false);
        this.currentSelection = selection;
    }

    protected void createAdvancedControls(Composite parent) {
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topLevel, "org.eclipse.ui.ide.new_file_wizard_page_context");
        this.resourceGroup = new ResourceAndContainerGroup(topLevel, this, this.getNewFileLabel(), IDEWorkbenchMessages.WizardNewFileCreationPage_file, false, 250);
        this.resourceGroup.setAllowExistingResources(this.initialAllowExistingResources);
        this.initialPopulateContainerNameField();
        this.createAdvancedControls(topLevel);
        if (this.initialFileName != null) {
            this.resourceGroup.setResource(this.initialFileName);
        }
        if (this.initialFileExtension != null) {
            this.resourceGroup.setResourceExtension(this.initialFileExtension);
        }
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    protected void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            if (this.linkTargetPath != null) {
                fileHandle.createLink(this.linkTargetPath, 16, monitor);
            } else {
                IPath path = fileHandle.getFullPath();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                int numSegments = path.segmentCount();
                if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                    int i = numSegments - 2;
                    while (i > 0) {
                        IFolder folder = root.getFolder(path.removeLastSegments(i));
                        if (!folder.exists()) {
                            folder.create(false, true, monitor);
                        }
                        --i;
                    }
                }
                fileHandle.create(contents, false, monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFile createFileHandle(IPath filePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    protected void createLinkTarget() {
    }

    public IFile createNewFile() {
        if (this.newFile != null) {
            return this.newFile;
        }
        IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFilePath = containerPath.append(this.resourceGroup.getResource());
        final IFile newFileHandle = this.createFileHandle(newFilePath);
        final InputStream initialContents = this.getInitialContents();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateFileOperation op = new CreateFileOperation(newFileHandle, WizardNewFileCreationPage.this.linkTargetPath, initialContents, IDEWorkbenchMessages.WizardNewFileCreationPage_title);
                try {
                    op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)WizardNewFileCreationPage.this.getShell()));
                }
                catch (ExecutionException e) {
                    WizardNewFileCreationPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)WizardNewFileCreationPage.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, null, (IStatus)((CoreException)e.getCause()).getStatus());
                            } else {
                                log.error("createNewFile failed", (Throwable)e);
                                MessageDialog.openError((Shell)WizardNewFileCreationPage.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            log.error("createNewFile failed", (Throwable)e);
            MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getTargetException().getMessage()), (int)0x10000000);
            return null;
        }
        this.newFile = newFileHandle;
        return this.newFile;
    }

    protected ISchedulingRule createRule(IResource resource) {
        IContainer parent = resource.getParent();
        while (parent != null) {
            if (parent.exists()) {
                return resource.getWorkspace().getRuleFactory().createRule(resource);
            }
            resource = parent;
            parent = parent.getParent();
        }
        return resource.getWorkspace().getRoot();
    }

    public IPath getContainerFullPath() {
        return this.resourceGroup.getContainerFullPath();
    }

    public String getFileName() {
        if (this.resourceGroup == null) {
            return this.initialFileName;
        }
        return this.resourceGroup.getResource();
    }

    public String getFileExtension() {
        if (this.resourceGroup == null) {
            return this.initialFileExtension;
        }
        return this.resourceGroup.getResourceExtension();
    }

    protected InputStream getInitialContents() {
        return null;
    }

    protected String getNewFileLabel() {
        return IDEWorkbenchMessages.WizardNewFileCreationPage_fileLabel;
    }

    protected void handleAdvancedButtonSelect() {
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    protected void initialPopulateContainerNameField() {
        if (this.initialContainerFullPath != null) {
            this.resourceGroup.setContainerFullPath(this.initialContainerFullPath);
        } else {
            Iterator it = this.currentSelection.iterator();
            if (it.hasNext()) {
                Object object = it.next();
                IResource selectedResource = null;
                if (object instanceof IResource) {
                    selectedResource = (IResource)object;
                } else if (object instanceof IAdaptable) {
                    selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
                }
                if (selectedResource != null) {
                    if (selectedResource.getType() == 1) {
                        selectedResource = selectedResource.getParent();
                    }
                    if (selectedResource.isAccessible()) {
                        this.resourceGroup.setContainerFullPath(selectedResource.getFullPath());
                    }
                }
            }
        }
    }

    public void setAllowExistingResources(boolean value) {
        if (this.resourceGroup == null) {
            this.initialAllowExistingResources = value;
        } else {
            this.resourceGroup.setAllowExistingResources(value);
        }
    }

    public void setContainerFullPath(IPath path) {
        if (this.resourceGroup == null) {
            this.initialContainerFullPath = path;
        } else {
            this.resourceGroup.setContainerFullPath(path);
        }
    }

    public void setFileName(String value) {
        if (this.resourceGroup == null) {
            this.initialFileName = value;
        } else {
            this.resourceGroup.setResource(value);
        }
    }

    public void setFileExtension(String value) {
        if (this.resourceGroup == null) {
            this.initialFileExtension = value;
        } else {
            this.resourceGroup.setResourceExtension(value);
        }
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            valid = false;
        }
        String resourceName = this.resourceGroup.getResource();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validateName(resourceName, 1);
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        Object linkedResourceStatus = null;
        if (valid && (linkedResourceStatus == null || linkedResourceStatus.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
            if (this.resourceGroup.getAllowExistingResources()) {
                String problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_nameExists, (Object)this.getFileName());
                IPath resourcePath = this.getContainerFullPath().append(this.getFileName());
                if (workspace.getRoot().getFolder(resourcePath).exists()) {
                    this.setErrorMessage(problemMessage);
                    valid = false;
                }
                if (workspace.getRoot().getFile(resourcePath).exists()) {
                    this.setMessage(problemMessage, 2);
                }
            }
        }
        return valid;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.resourceGroup.setFocus();
        }
    }
}

