/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.alert;

import it.jrc.alert.Alert;
import it.jrc.alert.AlertDefParser;
import it.jrc.alert.AlertMatchResult;
import it.jrc.alert.AlertResult;
import it.jrc.emmutils.FileExtFilter;
import it.jrc.matcher.MatchResult;
import it.jrc.matcher.MatchWords;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlertManager {
    private Hashtable<String, Alert> alerts;
    private Hashtable<Integer, String> alertPos;
    private static Logger logger = LogManager.getLogger((String)"it.jrc.alert.AlertManager");
    private MatchWords matchWords = MatchWords.getInstance((String)"alert");
    private int totalAlerts;

    public int nAlerts() {
        return this.totalAlerts;
    }

    private void buildPatternTable(String sDir, Hashtable<String, Alert> alerts, Hashtable<String, StringBuilder> patterns, Hashtable<Integer, String> pos) {
        long start = new Date().getTime();
        File xmlDirectory = new File(sDir);
        File[] xmlFiles = xmlDirectory.listFiles((FilenameFilter)new FileExtFilter(".xml"));
        logger.info("we found " + xmlFiles.length + " xml files");
        AlertDefParser alertDefParser = new AlertDefParser(alerts, patterns, pos);
        if (xmlFiles != null && xmlFiles.length > 0) {
            for (int i = 0; i < xmlFiles.length; ++i) {
                try {
                    File xml = xmlFiles[i];
                    alertDefParser.parse(xml);
                    continue;
                }
                catch (Exception e) {
                    logger.error("could not parse alert file" + xmlFiles[i].getName(), (Throwable)e);
                }
            }
        }
        alertDefParser = null;
        logger.info("alert definition parsing took " + (new Date().getTime() - start));
    }

    public boolean alertInit(String alertDefDir) {
        logger.info("alertInit (v3.0) alertDefDir = " + alertDefDir);
        long start = new Date().getTime();
        boolean bInit = false;
        Object nAlertID = null;
        Object nCurrentID = null;
        Hashtable<String, Alert> newAlerts = new Hashtable<String, Alert>();
        Hashtable<Integer, String> newAlertPos = new Hashtable<Integer, String>();
        Hashtable<String, StringBuilder> alertPatterns = new Hashtable<String, StringBuilder>();
        this.buildPatternTable(alertDefDir, newAlerts, alertPatterns, newAlertPos);
        if (this.alerts != null) {
            this.alerts.clear();
        }
        this.alerts = null;
        this.alertPos = null;
        System.gc();
        this.alerts = newAlerts;
        this.alertPos = newAlertPos;
        logger.info("AlertManager alertInit");
        this.totalAlerts = this.alerts.size();
        int nPatterns = alertPatterns.size();
        MatchWords matchWords = MatchWords.getInstance((String)"alert");
        matchWords.init(alertPatterns);
        logger.info("matcher initialized");
        alertPatterns = null;
        System.gc();
        logger.info("AlertManager: Initialized Matcher with " + nPatterns + " patterns and " + this.totalAlerts + " alerts");
        logger.info("alertInit took " + (new Date().getTime() - start));
        bInit = true;
        return bInit;
    }

    public HashMap<Alert, AlertResult> filter(String sText) {
        HashMap<Alert, AlertResult> alertScore = new HashMap<Alert, AlertResult>();
        AlertMatchResult matchResult = new AlertMatchResult();
        this.matchWords.match(sText, (MatchResult)matchResult);
        for (Integer nPos : this.alertPos.keySet()) {
            if (!matchResult.isMatched(nPos)) continue;
            AlertResult alertResult = new AlertResult(matchResult, nPos);
            Alert alert = this.alerts.get(this.alertPos.get(nPos));
            alertScore.put(alert, alertResult);
        }
        return alertScore;
    }

    public String alertInfo(String alertID) {
        Alert a = this.alerts.get(alertID);
        if (a != null) {
            return a.getDefinitionFile();
        }
        return "";
    }

    public String Info() {
        StringBuilder sInfo = new StringBuilder(1024);
        sInfo.append("<Alerts>");
        Enumeration<Alert> e = this.alerts.elements();
        while (e.hasMoreElements()) {
            Alert a = e.nextElement();
            sInfo.append(a.toString());
        }
        sInfo.append("</Alerts>");
        return sInfo.toString();
    }

    public void destroy() {
        this.alerts.clear();
        this.alerts = null;
    }
}

