/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.alert;

import it.jrc.alert.PatternMatch;
import it.jrc.matcher.MatchResult;
import java.util.HashMap;

public class AlertMatchResult
implements MatchResult {
    private HashMap<Integer, HashMap<String, PatternMatch>> matchProfiles = new HashMap();
    private int nWordCount = 0;
    private int nParts = 0;
    private int nNumerator = 1;
    private static double log2 = Math.log(2.0);

    public void addMatch(char[] data, int index, String word, int wordIndex, int charIndex) {
        int infoIndex = index + 2;
        char patternLen = data[infoIndex];
        int nWeights = data[infoIndex + 1];
        String pattern = String.valueOf(data, index - patternLen + 1, patternLen);
        int weigthsIndex = infoIndex + 2;
        for (int i = 0; i < nWeights; ++i) {
            PatternMatch match;
            char nAlertPos = data[weigthsIndex++];
            short weight = (short)data[weigthsIndex++];
            HashMap<String, PatternMatch> profile = this.matchProfiles.get(nAlertPos);
            if (profile == null) {
                profile = new HashMap();
                this.matchProfiles.put(Integer.valueOf(nAlertPos), profile);
                match = new PatternMatch(word, weight, wordIndex);
                profile.put(pattern, match);
                continue;
            }
            match = profile.get(pattern);
            if (match == null) {
                match = new PatternMatch(word, weight, wordIndex);
                profile.put(pattern, match);
                continue;
            }
            match.addMatch(word, wordIndex);
        }
    }

    public void setWordCount(int n) {
        this.nWordCount = n;
        this.nParts = (int)Math.round(Math.log((double)(this.nWordCount * 2) / 100.0) / log2) + 1;
        if (this.nParts < 1) {
            this.nParts = 1;
        }
        if (this.nParts > 5) {
            this.nParts = 5;
        }
        this.nNumerator = this.nWordCount / this.nParts;
    }

    public int getWordCount() {
        return this.nWordCount;
    }

    public int getParts() {
        return this.nParts;
    }

    public int getNumerator() {
        return this.nNumerator;
    }

    public HashMap<String, PatternMatch> getProfile(int a) {
        return this.matchProfiles.get(a);
    }

    public boolean isMatched(int a) {
        return this.matchProfiles.get(a) != null;
    }
}

