/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.alert;

import it.jrc.alert.AlertManager;
import it.jrc.alert.Analyser;
import it.jrc.alert.ProcessRSS;
import it.jrc.dispatcher.Dispatcher;
import it.jrc.dispatcher.QAlert;
import it.jrc.matcher.MatchWords;
import it.jrc.scheduler.CachedJob;
import it.jrc.scheduler.Job;
import it.jrc.scheduler.Scheduler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlertMonitor
extends HttpServlet
implements QAlert {
    private static AlertManager alertManager;
    private static MatchWords matchWords;
    private ArrayList<ProcessRSS> threadPool;
    private int nThreads = 5;
    private int maxQlen = 2000;
    private boolean bUpdate = false;
    private String alertsDefDir = null;
    private String alertsDefURL = null;
    private Date dStart = null;
    private Logger logger = LogManager.getLogger((String)"it.jrc.alert.AlertMonitor");
    private static UpdateMonitor updateMonitor;
    private static Timer updateTimer;
    private Date lastUpdate = null;
    private Date checkUpdate = null;
    private static final String CONTENT_TYPE = "text/xml; charset=\"utf-8\"";
    private String servletName;
    private Analyser analyser;
    private static Dispatcher dispatcher;
    private static Scheduler scheduler;
    private String jobQ = null;

    private void initProcesses() {
        this.logger.info("init processes");
        this.threadPool = new ArrayList();
        scheduler.start();
        for (int nP = 0; nP < this.nThreads; ++nP) {
            ProcessRSS processRSS = new ProcessRSS(this.servletName + ":rss:" + nP, alertManager, scheduler, dispatcher);
            processRSS.start();
            this.threadPool.add(processRSS);
            this.logger.info("Started " + processRSS.getName());
        }
    }

    private void stopProcesses() {
        this.logger.info("stopping processes");
        for (int i = 0; i < this.threadPool.size(); ++i) {
            try {
                ProcessRSS p = this.threadPool.get(i);
                this.logger.info("stopping " + p.getName());
                p.end();
                p.join(500L);
                p = null;
                continue;
            }
            catch (Exception e) {
                this.logger.warn("error stopping " + this.threadPool.get(i).getName(), (Throwable)e);
            }
        }
        scheduler.stop();
        this.threadPool.clear();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.dStart = new Date();
        this.servletName = config.getServletName();
        this.logger.info("AlertMonitor init");
        this.jobQ = config.getInitParameter("jobQ");
        if (this.jobQ == null || this.jobQ.equals("")) {
            this.jobQ = config.getServletContext().getRealPath("/jobs");
        }
        this.logger.info("jobs live in:" + this.jobQ);
        String qDef = config.getInitParameter("qDef");
        if (qDef == null || qDef.equals("")) {
            qDef = config.getServletContext().getRealPath("/queues.xml");
        }
        this.logger.info("queue definition file lives at:" + qDef);
        String sThreads = config.getInitParameter("nThreads");
        if (sThreads != null && !sThreads.equals("")) {
            this.nThreads = new Integer(sThreads);
        }
        this.logger.info("the number of worker threads: " + this.nThreads);
        String sMaxQlen = config.getInitParameter("maxQlen");
        if (sMaxQlen != null && !sMaxQlen.equals("")) {
            this.maxQlen = new Integer(sMaxQlen);
        }
        this.logger.info("the maximum job Q length: " + this.maxQlen);
        String hostURL = config.getInitParameter("hostURL");
        this.logger.info("the alert system lives on:" + hostURL);
        this.alertsDefDir = config.getServletContext().getRealPath("/" + config.getInitParameter("alertsDefDir"));
        this.logger.info("the alerts live in:" + this.alertsDefDir);
        this.alertsDefURL = hostURL + "/" + this.servletName + "/" + config.getInitParameter("alertsDefDir") + "/";
        this.logger.info("so the alerts live at:" + this.alertsDefURL);
        alertManager = new AlertManager();
        if (!alertManager.alertInit(this.alertsDefDir)) {
            throw new ServletException("AlertMonitor: could not initialize alertManager");
        }
        scheduler = new Scheduler(this.jobQ);
        dispatcher = new Dispatcher();
        try {
            dispatcher.initQs(qDef, config.getServletContext().getRealPath("/Qs/"));
        }
        catch (Exception ex) {
            this.logger.error("could not init client qs", (Throwable)ex);
            throw new ServletException("could not init client qs");
        }
        this.initProcesses();
        updateTimer = new Timer(true);
        updateMonitor = new UpdateMonitor();
        this.lastUpdate = new Date();
        this.checkUpdate = new Date();
        updateTimer.scheduleAtFixedRate((TimerTask)updateMonitor, 3600000L, 3600000L);
        this.analyser = new Analyser(alertManager);
        this.logger.info("AlertMonitor Init succesful");
    }

    public void qSize(String qName, int size) {
        this.logger.warn(qName + " now contains " + size + " items.");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = "";
        try {
            action = request.getParameter("action");
            if (action.equals("abort")) {
                System.exit(-2);
            } else if (action.equals("jobQ")) {
                response.setContentType(CONTENT_TYPE);
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8"));
                out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                out.print("<AlertMonitorQ>");
                out.print("</AlertMonitorQ>");
                out.flush();
            } else if (action.equals("alertInfo")) {
                response.setContentType(CONTENT_TYPE);
                StringBuilder sOut = new StringBuilder(2048);
                sOut.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                sOut.append("<alertInfo startDate=\"" + this.dStart + "\" update=\"" + this.lastUpdate + "\" >");
                sOut.append(alertManager.Info());
                sOut.append("</alertInfo>");
                ServletOutputStream os = response.getOutputStream();
                os.write(sOut.toString().getBytes("utf-8"));
                os.flush();
            } else if (action.equals("alertUpdate")) {
                String sUpdate = request.getParameter("update");
                this.bUpdate = sUpdate != null && sUpdate.toLowerCase().equals("true");
                response.setContentType(CONTENT_TYPE);
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8"));
                if (this.bUpdate) {
                    long now = new Date().getTime();
                    long diff = this.checkUpdate.getTime() + 3600000L - now;
                    out.write("<update><status>" + diff / 1000L / 60L + "</status><last>" + this.lastUpdate + "</last></update>");
                } else {
                    out.write("<update><status>cancelled</status><last>" + this.lastUpdate + "</last></update>");
                }
                out.flush();
            } else if (action.equals("alertInit")) {
                response.setContentType(CONTENT_TYPE);
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8"));
                out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.stopProcesses();
                if (alertManager.alertInit(this.alertsDefDir)) {
                    this.lastUpdate = new Date();
                    this.checkUpdate = new Date();
                    out.print(new String(alertManager.Info().getBytes("UTF-8")));
                    out.flush();
                    this.bUpdate = false;
                    this.logger.info("Initialised alertManager on init request");
                } else {
                    this.logger.error("ERROR in alertManager on init request");
                }
                System.gc();
                this.initProcesses();
            } else if (action.equals("alertDefURL")) {
                String alertID = new String(request.getParameter("alertID").getBytes("iso-8859-1"), "utf-8");
                String sURL = "";
                if (alertID != null && !alertID.equals("")) {
                    sURL = this.alertsDefURL + alertManager.alertInfo(alertID);
                }
                response.setContentType("text/plain; charset=\"utf-8\"");
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8"));
                out.print(sURL);
                out.flush();
                out.close();
            }
        }
        catch (OutOfMemoryError err) {
            this.logger.error("for some strange reason I am running out of memory. abort and restart Tomcat", (Throwable)err);
            System.exit(-1);
        }
        catch (Exception e) {
            this.logger.warn("AlertMonitor ERROR action=" + action, (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sText = null;
        String sURL = null;
        String sId = null;
        String sRSS = null;
        sText = request.getParameter("Text");
        sURL = request.getParameter("url");
        sId = request.getParameter("id");
        sRSS = request.getParameter("xml");
        if (sId != null && !sId.equals("")) {
            this.logger.info("received job for " + sId);
            CachedJob job = CachedJob.makeJob((String)this.jobQ, (String)sId, (String)sRSS);
            int nJobsInQ = scheduler.schedule((Job)job);
            response.setStatus(200);
        } else if (sText != null || sURL != null) {
            response.setContentType("text/xml; charset=utf-8");
            this.logger.info("received analyse request for url/text: " + sURL + "/" + sText);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8"));
            this.analyser.run(pw, sURL, sText);
        } else {
            response.setStatus(400);
        }
    }

    public void destroy() {
        this.logger.info("AlertMonitor destroy");
        updateTimer.cancel();
        this.stopProcesses();
        scheduler.destroy();
        dispatcher.destroy();
        alertManager.destroy();
        System.gc();
        this.logger.info("AlertMonitor stopped");
    }

    private class UpdateMonitor
    extends TimerTask {
        @Override
        public void run() {
            AlertMonitor.this.logger.info("checking for update request");
            AlertMonitor.this.checkUpdate = new Date();
            if (AlertMonitor.this.bUpdate) {
                AlertMonitor.this.logger.info("update requested: init alertmanager. Current free memory :" + Runtime.getRuntime().freeMemory());
                AlertMonitor.this.stopProcesses();
                alertManager.alertInit(AlertMonitor.this.alertsDefDir);
                AlertMonitor.this.lastUpdate = new Date();
                AlertMonitor.this.bUpdate = false;
                System.gc();
                AlertMonitor.this.initProcesses();
                AlertMonitor.this.logger.info("update completed: Current free memory :" + Runtime.getRuntime().freeMemory());
            }
        }
    }
}

