/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.alert;

import it.jrc.alert.Alert;
import it.jrc.alert.AlertManager;
import it.jrc.alert.AlertResult;
import it.jrc.alert.PatternMatch;
import it.jrc.emmutils.HTTPStream;
import it.jrc.emmutils.Utils;
import it.jrc.htmlparser.HTMLDocument;
import it.jrc.htmlparser.HTMLDocumentBuilder;
import it.jrc.htmlparser.TextFilter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Analyser {
    private static Logger logger = LogManager.getLogger((String)"it.jrc.alert.Analyser");
    private static AlertManager alertManager;
    private HTMLDocumentBuilder htmlDocBuilder;
    private long parseTime = 0L;

    public Analyser(AlertManager manager) {
        alertManager = manager;
        this.htmlDocBuilder = new HTMLDocumentBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String htmlIn(String sUrl) {
        String theText = null;
        String inputEncoding = null;
        HTTPStream httpStream = new HTTPStream(sUrl);
        try {
            if (httpStream.getType().equals("html")) {
                String sReference = httpStream.getFragment();
                logger.info("httpStream.getFragment() = " + sReference);
                inputEncoding = httpStream.getEncoding();
                logger.info("httpStream.getEncoding() = " + inputEncoding);
                if (inputEncoding == null) {
                    inputEncoding = "iso-8859-1";
                }
                Date start = new Date();
                HTMLDocument htmlDoc = this.htmlDocBuilder.parse((InputStream)httpStream, inputEncoding);
                TextFilter textFilter = new TextFilter();
                textFilter.parse(htmlDoc, sReference);
                theText = textFilter.getPlainText();
                Date end = new Date();
                this.parseTime = end.getTime() - start.getTime();
            } else {
                logger.error(sUrl + " does not return HTML??? return code = " + httpStream.getStatus());
            }
        }
        catch (Exception e) {
            logger.error("could not read from " + sUrl + " return code = " + httpStream.getStatus());
        }
        finally {
            httpStream.close();
        }
        return theText;
    }

    public void run(PrintWriter pw, String sURL, String sText) {
        long filterTime = 0L;
        this.parseTime = 0L;
        pw.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        try {
            String sToFilter = sURL != null && !sURL.equals("") ? this.htmlIn(sURL) : new String(sText.getBytes("iso-8859-1"), "UTF-8");
            if (sToFilter == null) {
                pw.print("<noResult>" + sURL + "</noResult>");
            } else {
                Date start = new Date();
                HashMap<Alert, AlertResult> score = alertManager.filter(sToFilter);
                Date end = new Date();
                filterTime = end.getTime() - start.getTime();
                pw.print("<alertResult filterTime=\"" + filterTime + "\" >");
                for (Alert a : score.keySet()) {
                    AlertResult result = score.get(a);
                    int value = result.getSimpleScore();
                    double[] accum = result.getScore();
                    HashMap<String, ArrayList<Integer>> patterns = result.getPatterns();
                    int nScoreRank = a.exceedsThreshold(accum);
                    int nComboRank = a.containsCombi(patterns, result.getNumerator());
                    int nRank = -1;
                    if (nScoreRank >= 0 || nComboRank >= 0) {
                        nRank = nScoreRank >= 0 && nComboRank >= 0 ? Math.min(nScoreRank, nComboRank) : (nScoreRank >= 0 ? nScoreRank : nComboRank);
                    }
                    pw.print("<alert id=\"" + a.getID() + "\" ");
                    if (nRank >= 0) {
                        pw.print(" triggered=\"true\">");
                        pw.print("<score");
                        if (nScoreRank >= 0) {
                            pw.print(" value=\"" + value + "\" threshold=\"" + a.getThreshold() + "\"");
                        }
                        if (nComboRank >= 0) {
                            pw.print(" combination=\"true\"");
                        }
                        pw.print(" />");
                        pw.print("<accum>");
                        pw.print(accum[0]);
                        for (int i = 1; i < accum.length; ++i) {
                            pw.print("," + accum[i]);
                        }
                        pw.print("</accum>");
                        pw.print("<rank>" + nRank + "</rank>");
                    } else {
                        pw.print(" >");
                    }
                    HashMap<String, PatternMatch> profile = score.get(a).getProfile();
                    pw.print("<profile>");
                    for (String sKey : profile.keySet()) {
                        PatternMatch match = profile.get(sKey);
                        pw.print("<pattern value=\"" + Utils.encodeXML((String)sKey) + "\" weight=\"" + match.getWeight() + "\">");
                        HashMap<String, ArrayList<Integer>> wordsMatched = match.getWords();
                        for (String matchWord : wordsMatched.keySet()) {
                            ArrayList<Integer> indices = wordsMatched.get(matchWord);
                            pw.print("<word value=\"" + Utils.encodeXML((String)matchWord) + "\">");
                            pw.print(indices.get(0));
                            for (int i = 1; i < indices.size(); ++i) {
                                pw.print("," + indices.get(i));
                            }
                            pw.print("</word>");
                        }
                        pw.print("</pattern>");
                    }
                    pw.print("</profile>");
                    pw.print("</alert>");
                }
                pw.print("<text characters=\"" + sToFilter.length() + "\"");
                if (this.parseTime > 0L) {
                    pw.print(" parseTime=\"" + this.parseTime + "\"");
                }
                pw.print(">");
                pw.print(Utils.encodeXML((String)sToFilter));
                pw.print("</text>");
                pw.print("</alertResult>");
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            logger.error("could not get result ", (Throwable)e);
        }
    }
}

