/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.alert;

import it.jrc.alert.Alert;
import it.jrc.alert.AlertManager;
import it.jrc.alert.AlertResult;
import it.jrc.dispatcher.Dispatcher;
import it.jrc.emmutils.Utils;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import it.jrc.scheduler.CachedJob;
import it.jrc.scheduler.Scheduler;
import java.util.HashMap;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessRSS
extends Thread {
    private static AlertManager alertManager;
    private static Scheduler scheduler;
    private static Dispatcher dispatcher;
    private RSSParser rssParser;
    private Logger logger = null;
    private boolean bRunning;

    public ProcessRSS(String name, AlertManager manager, Scheduler s, Dispatcher disp) {
        super(name);
        this.logger = LogManager.getLogger((String)name);
        alertManager = manager;
        this.rssParser = new RSSParser();
        scheduler = s;
        dispatcher = disp;
        this.bRunning = true;
    }

    private void processItem(RSSItem item) {
        HashMap<Alert, AlertResult> alertScore = alertManager.filter(Utils.checkCase((String)item.getTitle()) + ". " + item.getText());
        StringBuilder sb = new StringBuilder();
        for (Alert alert : alertScore.keySet()) {
            AlertResult alertResult = alertScore.get(alert);
            int nScoreRank = alert.exceedsThreshold(alertResult.getScore());
            int nComboRank = alert.containsCombi(alertResult.getPatterns(), alertResult.getNumerator());
            int nRank = -1;
            if (nScoreRank < 0 && nComboRank < 0) continue;
            nRank = nScoreRank >= 0 && nComboRank >= 0 ? Math.min(nScoreRank, nComboRank) : (nScoreRank >= 0 ? nScoreRank : nComboRank);
            SimpleElement category = new SimpleElement("category", alert.getID());
            category.addAttribute("emm:rank", Integer.toString(nRank));
            category.addAttribute("emm:score", Integer.toString(alertResult.getSimpleScore()));
            StringBuilder triggers = new StringBuilder(32);
            HashMap<String, Integer> words = alertResult.getWords();
            for (String word : words.keySet()) {
                triggers.append(word).append("[").append(words.get(word)).append("]; ");
            }
            category.addAttribute("emm:trigger", Utils.encodeXML((String)triggers.toString()));
            item.addCategory(category);
            sb.append(alert.getID()).append(";");
        }
        this.logger.info(item.getTitle() + " :" + sb.toString());
    }

    @Override
    public void run() {
        while (this.bRunning) {
            this.logger.info("waiting for job ");
            CachedJob job = (CachedJob)scheduler.next();
            boolean bl = this.bRunning = job != null;
            if (!this.bRunning) continue;
            this.logger.info("processing job " + job.getId());
            try {
                RSS rss = this.rssParser.parse(job.getReader());
                Vector items = rss.getItems();
                this.logger.info("items to do =" + items.size());
                for (int i = 0; i < items.size(); ++i) {
                    RSSItem item = (RSSItem)items.get(i);
                    this.processItem(item);
                }
                dispatcher.send(rss.getGuid(), rss.toString());
                job.delete();
            }
            catch (Exception e) {
                this.logger.error("error processing RSS for " + job.getId(), (Throwable)e);
            }
        }
        this.logger.info(this.getName() + " is terminating");
    }

    public void end() {
        this.bRunning = false;
        this.interrupt();
    }
}

