/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint;

import it.jrc.osint.Identifiable;
import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.AcquisitionMetaData;
import it.jrc.osint.metadata.ErrorStatusMetaData;
import it.jrc.osint.metadata.GrabberMetaData;
import it.jrc.osint.metadata.MetaTag;
import it.jrc.osint.metadata.MetaTagImpl;
import it.jrc.osint.metadata.RepositoryMetaData;
import it.jrc.osint.metadata.SearchMetaData;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;

public class DocumentMetaItem
implements Identifiable {
    private static final Logger log = LogManager.getLogger((String)DocumentMetaItem.class.getName());
    public static final DocumentMetaItem NULL_ITEM = new DocumentMetaItem();
    private RSSItem item;

    public DocumentMetaItem() {
        this.item = new RSSItem();
        this.item.setText("");
        this.item.setTitle("");
    }

    public DocumentMetaItem(RSSItem wrappedItem) {
        if (wrappedItem == null) {
            throw new IllegalArgumentException("Wrapped RSSItem must not be null");
        }
        this.item = wrappedItem;
        if (this.item.getTitle() == null) {
            this.item.setTitle("");
        }
        if (this.item.getText() == null) {
            this.item.setText("");
        }
    }

    public RSSItem getItem() {
        return this.item;
    }

    @Override
    public String getId() {
        return this.getResourceId().toString();
    }

    public ResourceId getResourceId() {
        return RepositoryMetaData.getResourceId(this);
    }

    public String getGuid() {
        return this.item.getGuid();
    }

    public void setLanguage(String language) {
        this.item.setLanguage(language);
    }

    private SimpleElement getSimpleElement(String tagName) {
        String elementName = this.getElementName(tagName);
        ArrayList elements = this.item.getElements(elementName);
        if (elements == null || elements.isEmpty()) {
            SimpleElement element = new SimpleElement(elementName);
            this.item.addElement(element);
            return element;
        }
        return (SimpleElement)elements.get(0);
    }

    private boolean hasMetaTag(String tagName) {
        ArrayList elements = this.item.getElements(tagName);
        return elements != null && elements.size() != 0;
    }

    private String getElementName(String tagName) {
        return "emm:os-" + tagName;
    }

    public void setTag(MetaTag tag) {
        MetaTagImpl tagImpl = (MetaTagImpl)tag;
        this.item.removeElement(this.getSimpleElement(tagImpl.getName()));
        this.item.addElement(tagImpl.getSimpleElement());
    }

    public MetaTag getTag(String tagName) {
        boolean isNew = !this.hasMetaTag(this.getElementName(tagName));
        return new MetaTagImpl(this.getSimpleElement(tagName), isNew);
    }

    public String getContentType() {
        return this.item.getContentType();
    }

    public String getTitle() {
        return this.item.getTitle();
    }

    public String getText() {
        return this.item.getText();
    }

    public String getLanguage() {
        return this.item.getLanguage();
    }

    public String getLink() {
        return this.item.getLink();
    }

    public void setLink(String newLink) {
        this.item.setLink(newLink);
    }

    public String getLastModified() {
        return this.item.getLastModified();
    }

    public void setText(String text) {
        this.item.setText(text);
    }

    public String getDescription() {
        if (this.item.getDescription() == null) {
            return "";
        }
        return this.item.getDescription();
    }

    public void setDescription(String description) {
        this.item.setDescription(description);
    }

    public void setGuid(String guid) {
        this.item.setGuid(guid);
    }

    public void setContentType(String contentType) {
        this.item.setContentType(contentType);
    }

    public void setTitle(String title) {
        this.item.setTitle(title);
    }

    public String toString() {
        return String.valueOf(this.getTitle()) + "(" + this.getId() + ")";
    }

    public void dump() {
        log.debug("MetaItem DUMP");
        log.debug("Title: \t\t" + this.getTitle());
        log.debug("Link:  \t\t" + this.getLink());
        log.debug("Description: \t" + this.getDescription());
        log.debug("Content-Type: \t" + this.getContentType());
        log.debug("Language: \t\t" + this.getLanguage());
        AcquisitionMetaData amd = new AcquisitionMetaData(this);
        amd.dump(log);
        SearchMetaData smd = new SearchMetaData(this);
        smd.dump(log);
        GrabberMetaData gmd = new GrabberMetaData(this);
        gmd.dump(log);
        ErrorStatusMetaData emd = new ErrorStatusMetaData(this);
        emd.dump(log);
        RepositoryMetaData rmd = new RepositoryMetaData(this);
        rmd.dump(log);
    }
}

