/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.metadata;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.MetaTag;
import it.jrc.osint.operations.ErrorCondition;
import it.jrc.osint.operations.OperationStatus;

public class ErrorStatusMetaData {
    public static final String NAME = "error-status";
    private static final String ERROR_MESSAGE = "message";
    private static final String ERROR_CODE = "code";
    private MetaTag mt;

    public ErrorStatusMetaData(MetaTag mt) {
        this.mt = mt;
    }

    public ErrorStatusMetaData(DocumentMetaItem inputItem) {
        this.mt = inputItem.getTag(NAME);
    }

    public int getErrorCode() {
        String errorCodeStr = this.mt.getAttribute(ERROR_CODE);
        if (errorCodeStr == null) {
            return 0;
        }
        return Integer.parseInt(errorCodeStr);
    }

    public void setErrorCode(int errorCode) {
        this.mt.setAttribute(ERROR_CODE, Integer.toString(errorCode));
    }

    public boolean hasErrorStatus() {
        return this.getErrorCode() != 0;
    }

    public String getErrorMessage() {
        return this.mt.getAttribute(ERROR_MESSAGE);
    }

    public void setErrorMessage(String errorMessage) {
        this.mt.setAttribute(ERROR_MESSAGE, errorMessage);
    }

    public void setOperationStatus(OperationStatus status) {
        if (status.isOK()) {
            this.cleanErrorStatus();
        } else {
            ErrorCondition errorCond = status.getErrorCondition();
            if (errorCond != null) {
                this.setErrorCode(errorCond.getCode());
                this.setErrorMessage(errorCond.getMessage());
            }
        }
    }

    public ErrorCondition getErrorCondition() {
        if (this.hasErrorStatus()) {
            int errorCode = this.getErrorCode();
            String errorMsg = this.getErrorMessage();
            ErrorCondition errorCond = new ErrorCondition(errorCode, errorMsg, "");
            return errorCond;
        }
        return null;
    }

    public void cleanErrorStatus() {
        this.setErrorCode(0);
        this.setErrorMessage(null);
    }

    public void dump(Logger log) {
        log.debug("---ErrorStatusMeta Data ---");
        log.debug("ErrorMessage: \t\t" + this.getErrorMessage());
        log.debug("ErrorCode: \t\t" + this.getErrorCode());
    }
}

