/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.metadata;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.MetaTag;
import it.jrc.osint.operations.FetchStatus;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GrabberMetaData {
    public static final String NAME = "grabber";
    private static final String FETCH_STATUS = "fetch-status";
    private static final String FETCH_STATUS_DESCRIPTION = "fetch-status-description";
    private static final String RAW_CONTENT_PATH = "raw-content-path";
    private static final String TIMESTAMP = "timestamp";
    private MetaTag mt;

    public GrabberMetaData(MetaTag mt) {
        this.mt = mt;
    }

    public GrabberMetaData(DocumentMetaItem item) {
        this.mt = item.getTag(NAME);
    }

    public FetchStatus getFetchStatus() {
        String fetchStatusName = this.mt.getAttribute(FETCH_STATUS);
        if (fetchStatusName == null) {
            return FetchStatus.UNKNOWN;
        }
        return FetchStatus.valueOf(fetchStatusName);
    }

    public void setFetchStatus(FetchStatus status) {
        this.mt.setAttribute(FETCH_STATUS, status.name());
    }

    public String getFetchStatusDescription() {
        return this.mt.getAttribute(FETCH_STATUS_DESCRIPTION);
    }

    public void setFetchStatusDescription(String desc) {
        this.mt.setAttribute(FETCH_STATUS_DESCRIPTION, desc);
    }

    public String getRawContentPath() {
        return this.mt.getAttribute(RAW_CONTENT_PATH);
    }

    public void setRawContentPath(String rawContentPath) {
        this.mt.setAttribute(RAW_CONTENT_PATH, rawContentPath);
    }

    public Date getTimeStamp() {
        String dateStr = this.mt.getAttribute(TIMESTAMP);
        if (dateStr != null) {
            long timestamp = Long.parseLong(dateStr);
            return new Date(timestamp);
        }
        return null;
    }

    public void setTimeStamp(Date timeStamp) {
        this.mt.setAttribute(TIMESTAMP, Long.toString(timeStamp.getTime()));
    }

    public void dump(Logger log) {
        log.debug("---Grabber Meta Data ---");
        log.debug("FetchStatus: \t\t" + (Object)((Object)this.getFetchStatus()));
        log.debug("FetchStatusDescription: \t\t" + this.getFetchStatusDescription());
        log.debug("RawContentPath: \t\t" + this.getRawContentPath());
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        log.debug("TimeStamp: \t\t" + dateFormat.format(this.getTimeStamp()));
    }
}

