/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.metadata;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.MetaTag;

public class RepositoryMetaData {
    public static final String NAME = "repository";
    private static final String ID = "id";
    private static final String TEXT_EXTRACTION_SUCCESSFUL = "text-extracted";
    private static final String LINKED_FILE = "linked-file";
    private static final String CONTENT_TYPE_ID = "content-type";
    private static final String BINARY_HASH = "binary-hash";
    private static final String FILENAME = "filename";
    private MetaTag mt;

    public RepositoryMetaData(DocumentMetaItem dmi) {
        MetaTag tag = dmi.getTag(NAME);
        if (tag == null) {
            throw new IllegalArgumentException("Could not find MetaTag for NAME");
        }
        this.mt = tag;
    }

    public RepositoryMetaData(MetaTag mdc) {
        if (mdc == null) {
            throw new IllegalArgumentException("Assigned null MetaTag");
        }
        this.mt = mdc;
    }

    public boolean isTextExtracted() {
        String textExtraction = this.mt.getAttribute(TEXT_EXTRACTION_SUCCESSFUL);
        return textExtraction != null && "true".equals(textExtraction);
    }

    public void setTextExtracted(boolean extracted) {
        this.mt.setAttribute(TEXT_EXTRACTION_SUCCESSFUL, Boolean.toString(extracted));
    }

    public static ResourceId getResourceId(DocumentMetaItem dmi) {
        String resourceIdStr = dmi.getTag(NAME).getAttribute(ID);
        if (resourceIdStr == null) {
            return ResourceId.NULL_ID;
        }
        return new ResourceId(resourceIdStr);
    }

    public ResourceId getResourceId() {
        String resourceIdStr = this.mt.getAttribute(ID);
        return new ResourceId(resourceIdStr);
    }

    public void setResourceId(ResourceId id) {
        if (id == null) {
            throw new IllegalArgumentException("ResourceId is null");
        }
        this.mt.setAttribute(ID, id.toString());
    }

    public String getLinkedFile() {
        return this.mt.getAttribute(LINKED_FILE);
    }

    public void setLinkedFile(String linkedFile) {
        this.mt.setAttribute(LINKED_FILE, linkedFile);
    }

    public String getContentTypeId() {
        return this.mt.getAttribute(CONTENT_TYPE_ID);
    }

    public void setContentTypeId(String contentTypeId) {
        this.mt.setAttribute(CONTENT_TYPE_ID, contentTypeId);
    }

    public String getBinaryHash() {
        return this.mt.getAttribute(BINARY_HASH);
    }

    public void setBinaryHash(String binaryHash) {
        this.mt.setAttribute(BINARY_HASH, binaryHash);
    }

    public String getFileName() {
        return this.mt.getAttribute(FILENAME);
    }

    public void setFileName(String fileName) {
        this.mt.setAttribute(FILENAME, fileName);
    }

    public void dump(Logger log) {
        log.debug("---Repository Meta Data ---");
        log.debug("ResourceId: \t\t" + this.getResourceId().toString());
        log.debug("TextExtractionSuccess: \t\t" + this.isTextExtracted());
        log.debug("LinkedFile: \t\t" + this.getLinkedFile());
        log.debug("ContentTypeId: \t\t" + this.getContentTypeId());
        log.debug("FileName: \t\t" + this.getBinaryHash());
    }
}

