/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.operations;

import java.text.MessageFormat;

public class ErrorCondition {
    public static final ErrorCondition NULL_ERROR = new ErrorCondition(0, "no error", "no action required");
    private int code;
    private String message;
    private String solution;
    private Throwable exception;

    public ErrorCondition(int code, String message, String solution) {
        this.code = code;
        this.message = message;
        this.solution = solution;
    }

    public ErrorCondition(int code, String message, String solution, Throwable exception) {
        this(code, message, solution);
        this.exception = exception;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSolution() {
        return this.solution;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable t) {
        this.exception = t;
    }

    public String toString() {
        String errorSolution;
        int errorCode = this.getCode();
        String errorMessage = this.getMessage();
        if (errorMessage == null) {
            errorMessage = "";
        }
        if ((errorSolution = this.getSolution()) == null) {
            errorSolution = "";
        }
        String errorCause = "No internal error cause.";
        if (this.getException() != null) {
            errorCause = "Internal error: " + this.getException().toString();
        }
        String logMessage = "An error {0} has occurred: {1}. {2}. Additional Info: {3}";
        String formattedLogMessage = MessageFormat.format(logMessage, Integer.toString(errorCode), errorMessage, errorSolution, errorCause);
        return formattedLogMessage;
    }
}

